/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekatool;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.CarvedPumpkinBlock;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeehiveTileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.ToolType;

@ParametersAreNonnullByDefault
public class ModuleShearingUnit
implements ICustomModule<ModuleShearingUnit> {
    public static final ToolType SHEARS_TOOL_TYPE = ToolType.get((String)"shears");
    private static final Predicate<Entity> SHEARABLE = entity -> !entity.func_175149_v() && entity instanceof IForgeShearable;

    @Override
    @Nonnull
    public ActionResultType onItemUse(IModule<ModuleShearingUnit> module, ItemUseContext context) {
        IEnergyContainer energyContainer = module.getEnergyContainer();
        if (energyContainer == null || energyContainer.getEnergy().smallerThan((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearBlock.get())) {
            return ActionResultType.PASS;
        }
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        return MekanismUtils.performActions(this.carvePumpkin(energyContainer, context, state), () -> this.shearBeehive(energyContainer, context, state));
    }

    @Override
    @Nonnull
    public ActionResultType onInteract(IModule<ModuleShearingUnit> module, PlayerEntity player, LivingEntity entity, Hand hand) {
        IEnergyContainer energyContainer;
        if (entity instanceof IForgeShearable && (energyContainer = module.getEnergyContainer()) != null && energyContainer.getEnergy().greaterOrEqual((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get()) && this.shearEntity(energyContainer, entity, player, module.getContainer(), entity.field_70170_p, entity.func_233580_cy_())) {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    @Nonnull
    public ICustomModule.ModuleDispenseResult onDispense(IModule<ModuleShearingUnit> module, IBlockSource source) {
        IEnergyContainer energyContainer = module.getEnergyContainer();
        if (energyContainer != null) {
            ServerWorld world = source.func_197524_h();
            Direction facing = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            BlockPos pos = source.func_180699_d().func_177972_a(facing);
            if (this.tryShearBlock(energyContainer, world, pos, facing.func_176734_d()) || this.tryShearLivingEntity(energyContainer, world, pos, module.getContainer())) {
                return ICustomModule.ModuleDispenseResult.HANDLED;
            }
        }
        return ICustomModule.ModuleDispenseResult.FAIL_PREVENT_DROP;
    }

    private ActionResultType carvePumpkin(IEnergyContainer energyContainer, ItemUseContext context, BlockState state) {
        if (state.func_203425_a(Blocks.field_150423_aK)) {
            World world = context.func_195991_k();
            if (!world.field_72995_K) {
                BlockPos pos = context.func_195995_a();
                Direction direction = context.func_196000_l();
                Direction side = direction.func_176740_k() == Direction.Axis.Y ? context.func_195992_f().func_176734_d() : direction;
                world.func_184133_a(null, pos, SoundEvents.field_199059_fV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_180501_a(pos, (BlockState)Blocks.field_196625_cS.func_176223_P().func_206870_a((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)side), 11);
                ItemEntity itementity = new ItemEntity(world, (double)pos.func_177958_n() + 0.5 + (double)side.func_82601_c() * 0.65, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5 + (double)side.func_82599_e() * 0.65, new ItemStack((IItemProvider)Items.field_151080_bb, 4));
                itementity.func_213293_j(0.05 * (double)side.func_82601_c() + world.field_73012_v.nextDouble() * 0.02, 0.05, 0.05 * (double)side.func_82599_e() + world.field_73012_v.nextDouble() * 0.02);
                world.func_217376_c((Entity)itementity);
                energyContainer.extract((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearBlock.get(), Action.EXECUTE, AutomationType.MANUAL);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    private ActionResultType shearBeehive(IEnergyContainer energyContainer, ItemUseContext context, BlockState state) {
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        if (state.func_235714_a_((ITag)BlockTags.field_226151_aa_) && state.func_177230_c() instanceof BeehiveBlock && (Integer)state.func_177229_b((Property)BeehiveBlock.field_226873_c_) >= 5) {
            World world = context.func_195991_k();
            BlockPos pos = context.func_195995_a();
            world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_226133_ah_, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            BeehiveBlock.func_226878_a_((World)world, (BlockPos)pos);
            BeehiveBlock beehive = (BeehiveBlock)state.func_177230_c();
            if (CampfireBlock.func_235474_a_((World)world, (BlockPos)pos)) {
                beehive.func_226876_a_(world, state, pos);
            } else {
                if (beehive.func_226882_d_(world, pos)) {
                    beehive.func_226881_b_(world, pos);
                }
                beehive.func_226877_a_(world, state, pos, player, BeehiveTileEntity.State.EMERGENCY);
            }
            if (!world.field_72995_K) {
                energyContainer.extract((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearBlock.get(), Action.EXECUTE, AutomationType.MANUAL);
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    private boolean tryShearBlock(IEnergyContainer energyContainer, ServerWorld world, BlockPos pos, Direction sideClicked) {
        if (energyContainer.getEnergy().greaterOrEqual((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearBlock.get())) {
            BlockState state = world.func_180495_p(pos);
            if (state.func_235714_a_((ITag)BlockTags.field_226151_aa_) && state.func_177230_c() instanceof BeehiveBlock && (Integer)state.func_177229_b((Property)BeehiveBlock.field_226873_c_) >= 5) {
                world.func_184133_a(null, pos, SoundEvents.field_226133_ah_, SoundCategory.BLOCKS, 1.0f, 1.0f);
                BeehiveBlock.func_226878_a_((World)world, (BlockPos)pos);
                ((BeehiveBlock)state.func_177230_c()).func_226877_a_((World)world, state, pos, null, BeehiveTileEntity.State.BEE_RELEASED);
                energyContainer.extract((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearBlock.get(), Action.EXECUTE, AutomationType.MANUAL);
                return true;
            }
            if (state.func_203425_a(Blocks.field_150423_aK)) {
                Direction side = sideClicked.func_176740_k() == Direction.Axis.Y ? Direction.NORTH : sideClicked;
                world.func_184133_a(null, pos, SoundEvents.field_199059_fV, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_180501_a(pos, (BlockState)Blocks.field_196625_cS.func_176223_P().func_206870_a((Property)CarvedPumpkinBlock.field_196359_a, (Comparable)side), 11);
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)Items.field_151080_bb, 4));
                energyContainer.extract((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearBlock.get(), Action.EXECUTE, AutomationType.MANUAL);
                return true;
            }
        }
        return false;
    }

    private boolean tryShearLivingEntity(IEnergyContainer energyContainer, ServerWorld world, BlockPos pos, ItemStack stack) {
        if (energyContainer.getEnergy().greaterOrEqual((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get())) {
            for (LivingEntity entity : world.func_175647_a(LivingEntity.class, new AxisAlignedBB(pos), SHEARABLE)) {
                if (!this.shearEntity(energyContainer, entity, null, stack, (World)world, pos)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean shearEntity(IEnergyContainer energyContainer, LivingEntity entity, @Nullable PlayerEntity player, ItemStack stack, World world, BlockPos pos) {
        IForgeShearable target = (IForgeShearable)entity;
        if (target.isShearable(stack, world, pos)) {
            if (!world.field_72995_K) {
                for (ItemStack drop : target.onSheared(player, stack, world, pos, EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack))) {
                    ItemEntity ent = entity.func_70099_a(drop, 1.0f);
                    if (ent == null) continue;
                    ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f), (double)(world.field_73012_v.nextFloat() * 0.05f), (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f)));
                }
                energyContainer.extract((FloatingLong)MekanismConfig.gear.mekaToolEnergyUsageShearEntity.get(), Action.EXECUTE, AutomationType.MANUAL);
            }
            return true;
        }
        return false;
    }
}

