/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.gear.mekasuit;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.IModuleConfigItem;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.gear.config.ModuleEnumData;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.MekanismLang;
import net.minecraft.util.text.ITextComponent;

@ParametersAreNonnullByDefault
public class ModuleHydraulicPropulsionUnit
implements ICustomModule<ModuleHydraulicPropulsionUnit> {
    private IModuleConfigItem<JumpBoost> jumpBoost;
    private IModuleConfigItem<StepAssist> stepAssist;

    @Override
    public void init(IModule<ModuleHydraulicPropulsionUnit> module, ModuleConfigItemCreator configItemCreator) {
        this.jumpBoost = configItemCreator.createConfigItem("jump_boost", MekanismLang.MODULE_JUMP_BOOST, new ModuleEnumData<JumpBoost>(JumpBoost.class, module.getInstalledCount() + 1, JumpBoost.LOW));
        this.stepAssist = configItemCreator.createConfigItem("step_assist", MekanismLang.MODULE_STEP_ASSIST, new ModuleEnumData<StepAssist>(StepAssist.class, module.getInstalledCount() + 1, StepAssist.LOW));
    }

    public float getBoost() {
        return this.jumpBoost.get().getBoost();
    }

    public float getStepHeight() {
        return this.stepAssist.get().getHeight();
    }

    public static enum StepAssist implements IHasTextComponent
    {
        OFF(0.0f),
        LOW(0.5f),
        MED(1.0f),
        HIGH(1.5f),
        ULTRA(2.0f);

        private final float height;
        private final ITextComponent label;

        private StepAssist(float height) {
            this.height = height;
            this.label = TextComponentUtil.getString(Float.toString(height));
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.label;
        }

        public float getHeight() {
            return this.height;
        }
    }

    public static enum JumpBoost implements IHasTextComponent
    {
        OFF(0.0f),
        LOW(0.5f),
        MED(1.0f),
        HIGH(3.0f),
        ULTRA(5.0f);

        private final float boost;
        private final ITextComponent label;

        private JumpBoost(float boost) {
            this.boost = boost;
            this.label = TextComponentUtil.getString(Float.toString(boost));
        }

        @Override
        public ITextComponent getTextComponent() {
            return this.label;
        }

        public float getBoost() {
            return this.boost;
        }
    }
}

