/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mekanism.api.annotations.NonNull;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedResolvableConfigValue;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class CachedResourceLocationListValue
extends CachedResolvableConfigValue<List<ResourceLocation>, List<? extends String>> {
    private static final Supplier<List<? extends String>> EMPTY = ArrayList::new;

    private CachedResourceLocationListValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<List<? extends String>> internal) {
        super(config, internal);
    }

    public static CachedResourceLocationListValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String path, Predicate<@NonNull ResourceLocation> rlValidator) {
        return new CachedResourceLocationListValue(config, (ForgeConfigSpec.ConfigValue<List<? extends String>>)builder.defineListAllowEmpty(Collections.singletonList(path), EMPTY, o -> {
            ResourceLocation rl;
            if (o instanceof String && (rl = ResourceLocation.func_208304_a((String)((String)o).toLowerCase(Locale.ROOT))) != null) {
                return rlValidator.test(rl);
            }
            return false;
        }));
    }

    @Override
    protected List<ResourceLocation> resolve(List<? extends String> encoded) {
        return encoded.stream().map(s -> ResourceLocation.func_208304_a((String)s.toLowerCase(Locale.ROOT))).filter(Objects::nonNull).collect(Collectors.toCollection(() -> new ArrayList(encoded.size())));
    }

    @Override
    protected List<? extends String> encode(List<ResourceLocation> values) {
        return values.stream().map(ResourceLocation::toString).collect(Collectors.toCollection(() -> new ArrayList(values.size())));
    }
}

