/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.RenderTickHandler;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadUtils;
import mekanism.client.render.lib.Vertex;
import mekanism.client.render.tileentity.IWireFrameRenderer;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.tile.machine.TileEntityPigmentMixer;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.vector.Vector3f;

@ParametersAreNonnullByDefault
public class RenderPigmentMixer
extends MekanismTileEntityRenderer<TileEntityPigmentMixer>
implements IWireFrameRenderer {
    private static final List<Vertex[]> vertices = new ArrayList<Vertex[]>();
    private static final float SHAFT_SPEED = 5.0f;

    public static void resetCached() {
        vertices.clear();
    }

    public RenderPigmentMixer(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityPigmentMixer tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (tile.getActive()) {
            this.performTranslations(tile, partialTick, matrix);
            MatrixStack.Entry entry = matrix.func_227866_c_();
            IVertexBuilder buffer = renderer.getBuffer(Atlases.func_228782_g_());
            for (BakedQuad quad : MekanismModelCache.INSTANCE.PIGMENT_MIXER_SHAFT.getBakedModel().func_200117_a(null, null, tile.func_145831_w().field_73012_v)) {
                buffer.addVertexData(entry, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlayLight);
            }
            matrix.func_227865_b_();
        }
    }

    @Override
    protected String getProfilerSection() {
        return "pigmentMixer";
    }

    @Override
    public boolean hasSelectionBox(BlockState state) {
        return Attribute.isActive(state);
    }

    @Override
    public boolean isCombined() {
        return true;
    }

    @Override
    public void renderWireFrame(TileEntity tile, float partialTick, MatrixStack matrix, IVertexBuilder buffer, float red, float green, float blue, float alpha) {
        if (tile instanceof TileEntityPigmentMixer) {
            this.performTranslations((TileEntityPigmentMixer)tile, partialTick, matrix);
            if (vertices.isEmpty()) {
                for (Quad quad : QuadUtils.unpack(MekanismModelCache.INSTANCE.PIGMENT_MIXER_SHAFT.getBakedModel().func_200117_a(null, null, tile.func_145831_w().field_73012_v))) {
                    vertices.add(quad.getVertices());
                }
            }
            RenderTickHandler.renderVertexWireFrame(vertices, buffer, matrix.func_227866_c_().func_227870_a_(), red, green, blue, alpha);
            matrix.func_227865_b_();
        }
    }

    private void performTranslations(TileEntityPigmentMixer tile, float partialTick, MatrixStack matrix) {
        matrix.func_227860_a_();
        switch (tile.getDirection()) {
            case NORTH: {
                matrix.func_227861_a_(0.4375, 0.0, 0.375);
                break;
            }
            case SOUTH: {
                matrix.func_227861_a_(0.4375, 0.0, 0.5);
                break;
            }
            case WEST: {
                matrix.func_227861_a_(0.375, 0.0, 0.4375);
                break;
            }
            case EAST: {
                matrix.func_227861_a_(0.5, 0.0, 0.4375);
            }
        }
        float shift = 0.0625f;
        matrix.func_227861_a_((double)shift, 0.0, (double)shift);
        matrix.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(((float)tile.func_145831_w().func_82737_E() + partialTick) * 5.0f % 360.0f));
        matrix.func_227861_a_((double)(-shift), 0.0, (double)(-shift));
    }
}

