/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.client.model.MekanismModelCache;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.tileentity.MekanismTileEntityRenderer;
import mekanism.common.tile.machine.TileEntityNutritionalLiquifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class RenderNutritionalLiquifier
extends MekanismTileEntityRenderer<TileEntityNutritionalLiquifier> {
    private static final Map<Gas, MekanismRenderer.Model3D> cachedModels = new HashMap<Gas, MekanismRenderer.Model3D>(1);
    private static final Map<TileEntityNutritionalLiquifier, PseudoParticleData> particles = new WeakHashMap<TileEntityNutritionalLiquifier, PseudoParticleData>();
    private static final float BLADE_SPEED = 25.0f;
    private static final float ROTATE_SPEED = 10.0f;

    public static void resetCachedModels() {
        cachedModels.clear();
    }

    public RenderNutritionalLiquifier(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityNutritionalLiquifier tile, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        if (!tile.gasTank.isEmpty()) {
            GasStack paste = (GasStack)tile.gasTank.getStack();
            float gasScale = (float)paste.getAmount() / (float)tile.gasTank.getCapacity();
            MekanismRenderer.renderObject(this.getPasteModel(paste), matrix, renderer.getBuffer(Atlases.func_228785_j_()), MekanismRenderer.getColorARGB(paste, gasScale, true), light, overlayLight, RenderResizableCuboid.FaceDisplay.FRONT);
        }
        boolean active = tile.getActive();
        matrix.func_227860_a_();
        if (active) {
            matrix.func_227861_a_(0.5, 0.5, 0.5);
            matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)tile.func_145831_w().func_82737_E() + partialTick) * 25.0f % 360.0f));
            matrix.func_227861_a_(-0.5, -0.5, -0.5);
        }
        MatrixStack.Entry entry = matrix.func_227866_c_();
        IVertexBuilder bladeBuffer = renderer.getBuffer(Atlases.func_228782_g_());
        for (BakedQuad quad : MekanismModelCache.INSTANCE.LIQUIFIER_BLADE.getBakedModel().func_200117_a(null, null, tile.func_145831_w().field_73012_v)) {
            bladeBuffer.addVertexData(entry, quad, 1.0f, 1.0f, 1.0f, 1.0f, light, overlayLight);
        }
        matrix.func_227865_b_();
        ItemStack stack = tile.getRenderStack();
        if (!stack.func_190926_b()) {
            matrix.func_227860_a_();
            matrix.func_227861_a_(0.5, 0.6, 0.5);
            if (active) {
                matrix.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(((float)tile.func_145831_w().func_82737_E() + partialTick) * 10.0f % 360.0f));
            }
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.GROUND, light, overlayLight, matrix, renderer);
            matrix.func_227865_b_();
            if (active && Minecraft.func_71410_x().field_71474_y.field_74362_aa != ParticleStatus.MINIMAL) {
                PseudoParticleData pseudoParticles = particles.computeIfAbsent(tile, t -> new PseudoParticleData());
                if (!Minecraft.func_71410_x().func_147113_T()) {
                    int rate;
                    if (pseudoParticles.lastTick != tile.func_145831_w().func_82737_E()) {
                        pseudoParticles.lastTick = tile.func_145831_w().func_82737_E();
                        pseudoParticles.particles.removeIf(PseudoParticle::tick);
                    }
                    int n = rate = Minecraft.func_71410_x().field_71474_y.field_74362_aa == ParticleStatus.DECREASED ? 12 : 4;
                    if (tile.func_145831_w().func_82737_E() % (long)rate == 0L) {
                        pseudoParticles.particles.add(new PseudoParticle(tile.func_145831_w(), stack));
                    }
                }
                IVertexBuilder buffer = renderer.getBuffer(MekanismRenderType.nutritionalParticle());
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.5, 0.55, 0.5);
                Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
                for (PseudoParticle particle : pseudoParticles.particles) {
                    particle.render(matrix4f, buffer, partialTick, light);
                }
                matrix.func_227865_b_();
            } else {
                particles.remove(tile);
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "nutritionalLiquifier";
    }

    private MekanismRenderer.Model3D getPasteModel(@Nonnull GasStack stack) {
        return cachedModels.computeIfAbsent((Gas)stack.getType(), gas -> {
            MekanismRenderer.Model3D model = new MekanismRenderer.Model3D();
            model.setTexture(MekanismRenderer.getChemicalTexture(gas));
            model.minX = 0.001f;
            model.minY = 0.313f;
            model.minZ = 0.001f;
            model.maxX = 0.999f;
            model.maxY = 0.937f;
            model.maxZ = 0.999f;
            return model;
        });
    }

    private static class PseudoParticle {
        private static final AxisAlignedBB INITIAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        private final TextureAtlasSprite sprite;
        private final float quadSize;
        private final float uo;
        private final float vo;
        protected double xo;
        protected double yo;
        protected double zo;
        protected double x;
        protected double y;
        protected double z;
        protected double xd;
        protected double yd;
        protected double zd;
        protected int lifetime;
        protected int age;
        protected float gravity;
        private AxisAlignedBB bb = INITIAL_AABB;
        protected float bbWidth = 0.6f;
        protected float bbHeight = 1.8f;

        protected PseudoParticle(World world, ItemStack stack) {
            this.setSize(0.2f, 0.2f);
            this.x = ((double)world.field_73012_v.nextFloat() - 0.5) * 0.3;
            this.y = ((double)world.field_73012_v.nextFloat() - 0.5) * 0.3;
            this.z = ((double)world.field_73012_v.nextFloat() - 0.5) * 0.3;
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
            this.lifetime = (int)(4.0f / (world.field_73012_v.nextFloat() * 0.9f + 0.1f));
            this.xd = (Math.random() * 2.0 - 1.0) * 0.4;
            this.yd = (Math.random() * 2.0 - 1.0) * 0.4;
            this.zd = (Math.random() * 2.0 - 1.0) * 0.4;
            float f = (float)(Math.random() + Math.random() + 1.0) * 0.15f;
            float f1 = MathHelper.func_76133_a((double)(this.xd * this.xd + this.yd * this.yd + this.zd * this.zd));
            this.xd = this.xd / (double)f1 * (double)f * 0.4;
            this.yd = this.yd / (double)f1 * (double)f * 0.4 + 0.1;
            this.zd = this.zd / (double)f1 * (double)f * 0.4;
            this.sprite = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, world, null).func_177554_e();
            this.gravity = 1.0f;
            this.quadSize = 0.1f * (world.field_73012_v.nextFloat() * 0.5f + 0.5f);
            this.uo = world.field_73012_v.nextFloat() * 3.0f;
            this.vo = world.field_73012_v.nextFloat() * 3.0f;
            this.xd *= 0.1;
            this.yd *= 0.1;
            this.zd *= 0.1;
            this.xd += ((double)world.field_73012_v.nextFloat() - 0.5) * 0.075;
            this.yd += Math.random() * 0.1 + 0.05;
            this.zd += ((double)world.field_73012_v.nextFloat() - 0.5) * 0.075;
        }

        public boolean tick() {
            if (this.age++ >= this.lifetime || this.y < -0.25) {
                return true;
            }
            this.xo = this.x;
            this.yo = this.y;
            this.zo = this.z;
            this.yd -= 0.04 * (double)this.gravity;
            if (this.xd != 0.0 || this.yd != 0.0 || this.zd != 0.0) {
                this.bb = this.bb.func_72317_d(this.xd, this.yd, this.zd);
                this.x = (this.bb.field_72340_a + this.bb.field_72336_d) / 2.0;
                this.y = this.bb.field_72338_b;
                this.z = (this.bb.field_72339_c + this.bb.field_72334_f) / 2.0;
            }
            this.xd *= 0.98;
            this.yd *= 0.98;
            this.zd *= 0.98;
            return false;
        }

        public void render(Matrix4f matrix, IVertexBuilder buffer, float partialTicks, int light) {
            float f = (float)MathHelper.func_219803_d((double)partialTicks, (double)this.xo, (double)this.x);
            float f1 = (float)MathHelper.func_219803_d((double)partialTicks, (double)this.yo, (double)this.y);
            float f2 = (float)MathHelper.func_219803_d((double)partialTicks, (double)this.zo, (double)this.z);
            Quaternion quaternion = Minecraft.func_71410_x().func_175598_ae().field_217783_c.func_227995_f_();
            Vector3f[] vectors = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
            for (int i = 0; i < 4; ++i) {
                Vector3f vector3f = vectors[i];
                vector3f.func_214905_a(quaternion);
                vector3f.func_195898_a(this.quadSize);
                vector3f.func_195904_b(f, f1, f2);
            }
            float f7 = this.getU0();
            float f8 = this.getU1();
            float f5 = this.getV0();
            float f6 = this.getV1();
            buffer.func_227888_a_(matrix, vectors[0].func_195899_a(), vectors[0].func_195900_b(), vectors[0].func_195902_c()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(f8, f6).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(matrix, vectors[1].func_195899_a(), vectors[1].func_195900_b(), vectors[1].func_195902_c()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(f8, f5).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(matrix, vectors[2].func_195899_a(), vectors[2].func_195900_b(), vectors[2].func_195902_c()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(f7, f5).func_227886_a_(light).func_181675_d();
            buffer.func_227888_a_(matrix, vectors[3].func_195899_a(), vectors[3].func_195900_b(), vectors[3].func_195902_c()).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(f7, f6).func_227886_a_(light).func_181675_d();
        }

        protected float getU0() {
            return this.sprite.func_94214_a((double)((this.uo + 1.0f) / 4.0f * 16.0f));
        }

        protected float getU1() {
            return this.sprite.func_94214_a((double)(this.uo / 4.0f * 16.0f));
        }

        protected float getV0() {
            return this.sprite.func_94207_b((double)(this.vo / 4.0f * 16.0f));
        }

        protected float getV1() {
            return this.sprite.func_94207_b((double)((this.vo + 1.0f) / 4.0f * 16.0f));
        }

        protected void setSize(float particleWidth, float particleHeight) {
            if (particleWidth != this.bbWidth || particleHeight != this.bbHeight) {
                this.bbWidth = particleWidth;
                this.bbHeight = particleHeight;
                double d0 = (this.bb.field_72340_a + this.bb.field_72336_d - (double)particleWidth) / 2.0;
                double d1 = (this.bb.field_72339_c + this.bb.field_72334_f - (double)particleWidth) / 2.0;
                this.bb = new AxisAlignedBB(d0, this.bb.field_72338_b, d1, d0 + (double)this.bbWidth, this.bb.field_72338_b + (double)this.bbHeight, d1 + (double)this.bbWidth);
            }
        }
    }

    private static class PseudoParticleData {
        private final List<PseudoParticle> particles = new ArrayList<PseudoParticle>();
        private long lastTick;

        private PseudoParticleData() {
        }
    }
}

