/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib.effect;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.lib.effect.CustomEffect;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;

public class BillboardingEffectRenderer {
    private static final Minecraft minecraft = Minecraft.func_71410_x();

    private BillboardingEffectRenderer() {
    }

    public static void render(CustomEffect effect, BlockPos renderPos, MatrixStack matrixStack, IRenderTypeBuffer renderer, long time, float partialTick) {
        matrixStack.func_227860_a_();
        int gridSize = effect.getTextureGridSize();
        IVertexBuilder buffer = BillboardingEffectRenderer.getRenderBuffer(renderer, effect.getTexture());
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        ActiveRenderInfo renderInfo = BillboardingEffectRenderer.minecraft.field_71460_t.func_215316_n();
        int tick = (int)time % (gridSize * gridSize);
        int xIndex = tick % gridSize;
        int yIndex = tick / gridSize;
        float spriteSize = 1.0f / (float)gridSize;
        Quaternion quaternion = renderInfo.func_227995_f_();
        Vector3f[] vertexPos = new Vector3f[]{new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
        Vector3d pos = effect.getPos(partialTick).func_178788_d(Vector3d.func_237491_b_((Vector3i)renderPos));
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vertexPos[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(effect.getScale());
            vector3f.func_195904_b((float)pos.func_82615_a(), (float)pos.func_82617_b(), (float)pos.func_82616_c());
        }
        int[] color = effect.getColor().rgbaArray();
        float minU = (float)xIndex * spriteSize;
        float maxU = minU + spriteSize;
        float minV = (float)yIndex * spriteSize;
        float maxV = minV + spriteSize;
        buffer.func_227888_a_(matrix, vertexPos[0].func_195899_a(), vertexPos[0].func_195900_b(), vertexPos[0].func_195902_c()).func_225586_a_(color[0], color[1], color[2], color[3]).func_225583_a_(minU, maxV).func_181675_d();
        buffer.func_227888_a_(matrix, vertexPos[1].func_195899_a(), vertexPos[1].func_195900_b(), vertexPos[1].func_195902_c()).func_225586_a_(color[0], color[1], color[2], color[3]).func_225583_a_(maxU, maxV).func_181675_d();
        buffer.func_227888_a_(matrix, vertexPos[2].func_195899_a(), vertexPos[2].func_195900_b(), vertexPos[2].func_195902_c()).func_225586_a_(color[0], color[1], color[2], color[3]).func_225583_a_(maxU, minV).func_181675_d();
        buffer.func_227888_a_(matrix, vertexPos[3].func_195899_a(), vertexPos[3].func_195900_b(), vertexPos[3].func_195902_c()).func_225586_a_(color[0], color[1], color[2], color[3]).func_225583_a_(minU, minV).func_181675_d();
        matrixStack.func_227865_b_();
    }

    protected static IVertexBuilder getRenderBuffer(IRenderTypeBuffer renderer, ResourceLocation texture) {
        return renderer.getBuffer(MekanismRenderType.renderSPS(texture));
    }
}

