/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.client.render.lib.Quad;
import mekanism.client.render.lib.QuadUtils;
import mekanism.common.lib.Color;
import mekanism.common.lib.math.Quaternion;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;

public interface QuadTransformation {
    public static final Direction[][] ROTATION_MATRIX = new Direction[][]{{Direction.SOUTH, Direction.NORTH, Direction.DOWN, Direction.DOWN, Direction.DOWN, Direction.DOWN}, {Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.UP, Direction.UP, Direction.UP}, {Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}, {Direction.UP, Direction.DOWN, Direction.SOUTH, Direction.NORTH, Direction.EAST, Direction.WEST}, {Direction.WEST, Direction.WEST, Direction.WEST, Direction.EAST, Direction.SOUTH, Direction.NORTH}, {Direction.EAST, Direction.EAST, Direction.EAST, Direction.WEST, Direction.NORTH, Direction.SOUTH}};
    public static final QuadTransformation identity = q -> {};
    public static final QuadTransformation fullbright = QuadTransformation.light(1.0f);
    public static final QuadTransformation filtered_fullbright = TextureFilteredTransformation.of(fullbright, rl -> rl.func_110623_a().contains("led"));

    public static QuadTransformation color(Color color) {
        return new ColorTransformation(color);
    }

    public static QuadTransformation light(float light) {
        return new LightTransformation(light, light);
    }

    public static QuadTransformation translate(Vector3d translation) {
        return new TranslationTransformation(translation);
    }

    public static QuadTransformation rotate(Direction side) {
        if (side == null) {
            return identity;
        }
        switch (side) {
            case UP: {
                return QuadTransformation.rotate(90.0, 0.0, 0.0);
            }
            case DOWN: {
                return QuadTransformation.rotate(-90.0, 0.0, 0.0);
            }
            case WEST: {
                return QuadTransformation.rotate(0.0, 90.0, 0.0);
            }
            case EAST: {
                return QuadTransformation.rotate(0.0, -90.0, 0.0);
            }
            case SOUTH: {
                return QuadTransformation.rotate(0.0, 180.0, 0.0);
            }
        }
        return identity;
    }

    public static QuadTransformation rotateY(double degrees) {
        return QuadTransformation.rotate(0.0, degrees, 0.0);
    }

    public static QuadTransformation rotate(double rotationX, double rotationY, double rotationZ) {
        return QuadTransformation.rotate(new Quaternion(rotationX, rotationY, rotationZ, true));
    }

    public static QuadTransformation rotate(Quaternion quat) {
        return new RotationTransformation(quat);
    }

    public static QuadTransformation sideRotate(Direction side) {
        return new SideTransformation(side);
    }

    public static QuadTransformation texture(TextureAtlasSprite texture) {
        return new TextureTransformation(texture);
    }

    public static QuadTransformation list(QuadTransformation ... transforms) {
        return TransformationList.of(transforms);
    }

    public void transform(Quad var1);

    default public QuadTransformation and(QuadTransformation other) {
        return QuadTransformation.list(this, other);
    }

    public static class TransformationList
    implements QuadTransformation {
        private final List<QuadTransformation> list;
        private final int hashCode;

        protected TransformationList(List<QuadTransformation> list) {
            this.list = list;
            this.hashCode = list.hashCode();
        }

        public static TransformationList of(QuadTransformation ... trans) {
            return new TransformationList(Arrays.asList(trans));
        }

        @Override
        public void transform(Quad quad) {
            this.list.forEach(transformation -> transformation.transform(quad));
        }

        public boolean equals(Object other) {
            return other instanceof TransformationList && this.list.equals(((TransformationList)other).list);
        }

        @Override
        public QuadTransformation and(QuadTransformation other) {
            ArrayList<QuadTransformation> newList = new ArrayList<QuadTransformation>(this.list);
            newList.add(other);
            return new TransformationList(newList);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    public static class TextureFilteredTransformation
    implements QuadTransformation {
        private final QuadTransformation original;
        private final Predicate<ResourceLocation> verifier;

        protected TextureFilteredTransformation(QuadTransformation original, Predicate<ResourceLocation> verifier) {
            this.original = original;
            this.verifier = verifier;
        }

        public static TextureFilteredTransformation of(QuadTransformation original, Predicate<ResourceLocation> verifier) {
            return new TextureFilteredTransformation(original, verifier);
        }

        @Override
        public void transform(Quad quad) {
            if (this.verifier.test(quad.getTexture().func_195668_m())) {
                quad.transform(v -> this.original.transform(quad));
            }
        }

        public boolean equals(Object other) {
            return other instanceof TextureFilteredTransformation && this.verifier.equals(((TextureFilteredTransformation)other).verifier);
        }

        public int hashCode() {
            return Objects.hash(this.original, this.verifier);
        }
    }

    public static class TextureTransformation
    implements QuadTransformation {
        private final TextureAtlasSprite texture;

        protected TextureTransformation(TextureAtlasSprite texture) {
            this.texture = texture;
        }

        @Override
        public void transform(Quad quad) {
            if (this.texture == null) {
                return;
            }
            QuadUtils.remapUVs(quad, this.texture);
            quad.setTexture(this.texture);
        }

        public boolean equals(Object other) {
            return other instanceof TextureTransformation && this.texture == ((TextureTransformation)other).texture;
        }

        public int hashCode() {
            return this.texture != null ? this.texture.hashCode() : -1;
        }
    }

    public static class TranslationTransformation
    implements QuadTransformation {
        private final Vector3d translation;

        protected TranslationTransformation(Vector3d translation) {
            this.translation = translation;
        }

        @Override
        public void transform(Quad quad) {
            quad.vertexTransform(v -> v.pos(v.getPos().func_178787_e(this.translation)));
        }

        public boolean equals(Object other) {
            return other instanceof TranslationTransformation && this.translation.equals((Object)((TranslationTransformation)other).translation);
        }

        public int hashCode() {
            return this.translation.hashCode();
        }
    }

    public static class RotationTransformation
    implements QuadTransformation {
        private static final double EPSILON = 10000.0;
        private final Quaternion quaternion;

        protected RotationTransformation(Quaternion quaternion) {
            this.quaternion = quaternion;
        }

        @Override
        public void transform(Quad quad) {
            quad.vertexTransform(v -> {
                v.pos(RotationTransformation.round(this.quaternion.rotate(v.getPos().func_178786_a(0.5, 0.5, 0.5)).func_72441_c(0.5, 0.5, 0.5)));
                v.normal(RotationTransformation.round(this.quaternion.rotate(v.getNormal()).normalize()));
            });
        }

        private static Vector3d round(Vector3d vec) {
            return new Vector3d((double)Math.round(vec.field_72450_a * 10000.0) / 10000.0, (double)Math.round(vec.field_72448_b * 10000.0) / 10000.0, (double)Math.round(vec.field_72449_c * 10000.0) / 10000.0);
        }

        public boolean equals(Object other) {
            return other instanceof RotationTransformation && this.quaternion.equals(((RotationTransformation)other).quaternion);
        }

        public int hashCode() {
            return this.quaternion.hashCode();
        }
    }

    public static class LightTransformation
    implements QuadTransformation {
        private final float lightU;
        private final float lightV;

        public LightTransformation(float lightU, float lightV) {
            this.lightU = lightU;
            this.lightV = lightV;
        }

        @Override
        public void transform(Quad quad) {
            quad.vertexTransform(v -> v.light(this.lightU, this.lightV));
        }

        public boolean equals(Object other) {
            return other instanceof LightTransformation && this.lightU == ((LightTransformation)other).lightU && this.lightV == ((LightTransformation)other).lightV;
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.lightU), Float.valueOf(this.lightV));
        }
    }

    public static class ColorTransformation
    implements QuadTransformation {
        private final Color color;

        protected ColorTransformation(Color color) {
            this.color = color;
        }

        @Override
        public void transform(Quad quad) {
            quad.vertexTransform(v -> v.color(this.color));
        }

        public boolean equals(Object other) {
            return other instanceof ColorTransformation && this.color.equals(((ColorTransformation)other).color);
        }

        public int hashCode() {
            return this.color.hashCode();
        }
    }

    public static class SideTransformation
    implements QuadTransformation {
        private final Direction side;

        protected SideTransformation(Direction side) {
            this.side = side;
        }

        @Override
        public void transform(Quad quad) {
            if (this.side == null) {
                return;
            }
            quad.setSide(ROTATION_MATRIX[quad.getSide().ordinal()][this.side.ordinal()]);
        }

        public boolean equals(Object other) {
            return other instanceof SideTransformation && this.side == ((SideTransformation)other).side;
        }

        public int hashCode() {
            return this.side != null ? this.side.hashCode() : -1;
        }
    }
}

