/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class GuiElement
extends Widget
implements IFancyFontRenderer {
    private static final int BUTTON_TEX_X = 200;
    private static final int BUTTON_TEX_Y = 60;
    public static final ResourceLocation WARNING_BACKGROUND_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "warning_background.png");
    public static final ResourceLocation WARNING_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "warning.png");
    public static final Minecraft minecraft = Minecraft.func_71410_x();
    protected ButtonBackground buttonBackground = ButtonBackground.NONE;
    protected final List<GuiElement> children = new ArrayList<GuiElement>();
    private final List<GuiElement> positionOnlyChildren = new ArrayList<GuiElement>();
    private IGuiWrapper guiObj;
    protected boolean playClickSound;
    protected int relativeX;
    protected int relativeY;
    public boolean isOverlay;

    public GuiElement(IGuiWrapper gui, int x, int y, int width, int height) {
        this(gui, x, y, width, height, StringTextComponent.field_240750_d_);
    }

    public GuiElement(IGuiWrapper gui, int x, int y, int width, int height, ITextComponent text) {
        super(gui.getLeft() + x, gui.getTop() + y, width, height, text);
        this.relativeX = x;
        this.relativeY = y;
        this.guiObj = gui;
    }

    public int getRelativeX() {
        return this.relativeX;
    }

    public int getRelativeY() {
        return this.relativeY;
    }

    public void transferToNewGui(IGuiWrapper gui) {
        int prevLeft = this.getGuiLeft();
        int prevTop = this.getGuiTop();
        this.transferToNewGuiInternal(gui);
        this.resize(prevLeft, prevTop, this.getGuiLeft(), this.getGuiTop());
    }

    private void transferToNewGuiInternal(IGuiWrapper gui) {
        this.guiObj = gui;
        this.children.forEach(child -> child.transferToNewGuiInternal(gui));
        this.positionOnlyChildren.forEach(child -> child.transferToNewGuiInternal(gui));
    }

    protected <ELEMENT extends GuiElement> ELEMENT addChild(ELEMENT element) {
        this.children.add(element);
        if (this.isOverlay) {
            element.isOverlay = true;
        }
        return element;
    }

    protected <ELEMENT extends GuiElement> ELEMENT addPositionOnlyChild(ELEMENT element) {
        this.positionOnlyChildren.add(element);
        return element;
    }

    public final IGuiWrapper gui() {
        return this.guiObj;
    }

    public final int getGuiLeft() {
        return this.guiObj.getLeft();
    }

    public final int getGuiTop() {
        return this.guiObj.getTop();
    }

    public final int getGuiWidth() {
        return this.guiObj.getWidth();
    }

    public final int getGuiHeight() {
        return this.guiObj.getHeight();
    }

    public List<GuiElement> children() {
        return this.children;
    }

    public void tick() {
        this.children.forEach(GuiElement::tick);
    }

    public void resize(int prevLeft, int prevTop, int left, int top) {
        this.field_230690_l_ = this.field_230690_l_ - prevLeft + left;
        this.field_230691_m_ = this.field_230691_m_ - prevTop + top;
        this.children.forEach(child -> child.resize(prevLeft, prevTop, left, top));
        this.positionOnlyChildren.forEach(child -> child.resize(prevLeft, prevTop, left, top));
    }

    public boolean childrenContainsElement(Predicate<GuiElement> checker) {
        return this.children.stream().anyMatch(e -> e.containsElement(checker));
    }

    public boolean containsElement(Predicate<GuiElement> checker) {
        return checker.test(this) || this.childrenContainsElement(checker);
    }

    public void func_230996_d_(boolean focused) {
        super.func_230996_d_(focused);
    }

    public void move(int changeX, int changeY) {
        this.field_230690_l_ += changeX;
        this.field_230691_m_ += changeY;
        this.relativeX += changeX;
        this.relativeY += changeY;
        this.children.forEach(child -> child.move(changeX, changeY));
        this.positionOnlyChildren.forEach(child -> child.move(changeX, changeY));
    }

    public void onWindowClose() {
        this.children.forEach(GuiElement::onWindowClose);
    }

    protected ResourceLocation getButtonLocation(String name) {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, name + ".png");
    }

    protected IHoverable getOnHover(ILangEntry translationHelper) {
        return this.getOnHover(() -> translationHelper.translate(new Object[0]));
    }

    protected IHoverable getOnHover(Supplier<ITextComponent> componentSupplier) {
        return (onHover, matrix, xAxis, yAxis) -> this.displayTooltip(matrix, (ITextComponent)componentSupplier.get(), xAxis, yAxis);
    }

    public boolean hasPersistentData() {
        return this.children.stream().anyMatch(GuiElement::hasPersistentData);
    }

    public void syncFrom(GuiElement element) {
        int numChildren = this.children.size();
        if (numChildren > 0) {
            for (int i = 0; i < element.children.size(); ++i) {
                GuiElement child;
                GuiElement prevChild = element.children.get(i);
                if (!prevChild.hasPersistentData() || i >= numChildren || (child = this.children.get(i)).getClass() != prevChild.getClass()) continue;
                child.syncFrom(prevChild);
            }
        }
    }

    public final void onRenderForeground(MatrixStack matrix, int mouseX, int mouseY, int zOffset, int totalOffset) {
        if (this.field_230694_p_) {
            matrix.func_227861_a_(0.0, 0.0, (double)zOffset);
            GuiMekanism.maxZOffset = Math.max(totalOffset, GuiMekanism.maxZOffset);
            matrix.func_227861_a_((double)(-this.getGuiLeft()), (double)(-this.getGuiTop()), 0.0);
            this.renderBackgroundOverlay(matrix, mouseX, mouseY);
            this.children.forEach(child -> child.func_230430_a_(matrix, mouseX, mouseY, 0.0f));
            this.children.forEach(child -> child.onDrawBackground(matrix, mouseX, mouseY, 0.0f));
            matrix.func_227861_a_((double)this.getGuiLeft(), (double)this.getGuiTop(), 0.0);
            this.renderForeground(matrix, mouseX, mouseY);
            this.children.forEach(child -> {
                matrix.func_227860_a_();
                child.onRenderForeground(matrix, mouseX, mouseY, 50, totalOffset + 50);
                matrix.func_227865_b_();
            });
        }
    }

    public void renderForeground(MatrixStack matrix, int mouseX, int mouseY) {
        this.drawButtonText(matrix, mouseX, mouseY);
    }

    public void renderBackgroundOverlay(MatrixStack matrix, int mouseX, int mouseY) {
    }

    public void func_230443_a_(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.children.stream().filter(child -> child.func_231047_b_(mouseX + this.getGuiLeft(), mouseY + this.getGuiTop())).forEach(child -> child.func_230443_a_(matrix, mouseX, mouseY));
    }

    public void displayTooltip(MatrixStack matrix, ITextComponent component, int xAxis, int yAxis, int maxWidth) {
        this.guiObj.displayTooltip(matrix, component, xAxis, yAxis, maxWidth);
    }

    public void displayTooltip(MatrixStack matrix, ITextComponent component, int xAxis, int yAxis) {
        this.guiObj.displayTooltip(matrix, component, xAxis, yAxis);
    }

    public void displayTooltips(MatrixStack matrix, List<ITextComponent> components, int xAxis, int yAxis) {
        this.guiObj.displayTooltips(matrix, components, xAxis, yAxis);
    }

    public void displayTooltips(MatrixStack matrix, List<ITextComponent> components, int xAxis, int yAxis, int maxWidth) {
        this.guiObj.displayTooltips(matrix, components, xAxis, yAxis, maxWidth);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return GuiUtils.checkChildren(this.children, child -> child.func_231044_a_(mouseX, mouseY, button)) || super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        return GuiUtils.checkChildren(this.children, child -> child.func_231046_a_(keyCode, scanCode, modifiers)) || super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char c, int keyCode) {
        return GuiUtils.checkChildren(this.children, child -> child.func_231042_a_(c, keyCode)) || super.func_231042_a_(c, keyCode);
    }

    public void func_230983_a_(double mouseX, double mouseY, double mouseXOld, double mouseYOld) {
        this.children.forEach(element -> element.func_230983_a_(mouseX, mouseY, mouseXOld, mouseYOld));
        super.func_230983_a_(mouseX, mouseY, mouseXOld, mouseYOld);
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        this.children.forEach(element -> element.func_231000_a__(mouseX, mouseY));
        super.func_231000_a__(mouseX, mouseY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        return GuiUtils.checkChildren(this.children, child -> child.func_231043_a_(mouseX, mouseY, delta)) || super.func_231043_a_(mouseX, mouseY, delta);
    }

    @Override
    public FontRenderer getFont() {
        return this.guiObj.getFont();
    }

    @Override
    public int getXSize() {
        return this.field_230688_j_;
    }

    public void setButtonBackground(ButtonBackground buttonBackground) {
        this.buttonBackground = buttonBackground;
    }

    protected boolean func_230992_c_(double mouseX, double mouseY) {
        return this.func_231047_b_(mouseX, mouseY);
    }

    protected int getButtonX() {
        return this.field_230690_l_;
    }

    protected int getButtonY() {
        return this.field_230691_m_;
    }

    protected int getButtonWidth() {
        return this.field_230688_j_;
    }

    protected int getButtonHeight() {
        return this.field_230689_k_;
    }

    protected boolean resetColorBeforeRender() {
        return true;
    }

    public boolean func_231047_b_(double mouseX, double mouseY) {
        return super.func_231047_b_(mouseX, mouseY) || GuiUtils.checkChildren(this.children, child -> child.func_231047_b_(mouseX, mouseY));
    }

    public final boolean isMouseOverCheckWindows(double mouseX, double mouseY) {
        GuiWindow window;
        boolean isHovering = this.func_231047_b_(mouseX, mouseY);
        if (isHovering && (window = this.guiObj.getWindowHovering(mouseX, mouseY)) != null && !window.childrenContainsElement(e -> e == this)) {
            isHovering = false;
        }
        return isHovering;
    }

    public void drawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonBackground != ButtonBackground.NONE) {
            this.drawButton(matrix, mouseX, mouseY);
        }
    }

    public final void onDrawBackground(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            this.drawBackground(matrix, mouseX, mouseY, partialTicks);
        }
    }

    public void func_230431_b_(@Nonnull MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
    }

    protected int getButtonTextColor(int mouseX, int mouseY) {
        return this.getFGColor();
    }

    protected void drawButtonText(MatrixStack matrix, int mouseX, int mouseY) {
        ITextComponent text = this.func_230458_i_();
        if (!text.getString().isEmpty()) {
            int color = this.getButtonTextColor(mouseX, mouseY) | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24;
            this.drawCenteredTextScaledBound(matrix, text, this.field_230688_j_ - 4, (float)this.field_230689_k_ / 2.0f - 4.0f, color);
        }
    }

    protected void drawButton(MatrixStack matrix, int mouseX, int mouseY) {
        if (this.resetColorBeforeRender()) {
            MekanismRenderer.resetColor();
        }
        MekanismRenderer.bindTexture(this.buttonBackground.getTexture());
        int i = this.func_230989_a_(this.isMouseOverCheckWindows(mouseX, mouseY));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        int width = this.getButtonWidth();
        int height = this.getButtonHeight();
        int halfWidthLeft = width / 2;
        int halfWidthRight = width % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
        int halfHeightTop = height / 2;
        int halfHeightBottom = height % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
        int position = i * 20;
        int x = this.getButtonX();
        int y = this.getButtonY();
        GuiElement.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)position, (int)halfWidthLeft, (int)halfHeightTop, (int)200, (int)60);
        GuiElement.func_238463_a_((MatrixStack)matrix, (int)x, (int)(y + halfHeightTop), (float)0.0f, (float)(position + 20 - halfHeightBottom), (int)halfWidthLeft, (int)halfHeightBottom, (int)200, (int)60);
        GuiElement.func_238463_a_((MatrixStack)matrix, (int)(x + halfWidthLeft), (int)y, (float)(200 - halfWidthRight), (float)position, (int)halfWidthRight, (int)halfHeightTop, (int)200, (int)60);
        GuiElement.func_238463_a_((MatrixStack)matrix, (int)(x + halfWidthLeft), (int)(y + halfHeightTop), (float)(200 - halfWidthRight), (float)(position + 20 - halfHeightBottom), (int)halfWidthRight, (int)halfHeightBottom, (int)200, (int)60);
        this.func_230441_a_(matrix, minecraft, mouseX, mouseY);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
    }

    protected void renderExtendedTexture(MatrixStack matrix, ResourceLocation resource, int sideWidth, int sideHeight) {
        GuiUtils.renderExtendedTexture(matrix, resource, sideWidth, sideHeight, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight());
    }

    protected void renderBackgroundTexture(MatrixStack matrix, ResourceLocation resource, int sideWidth, int sideHeight) {
        GuiUtils.renderBackgroundTexture(matrix, resource, sideWidth, sideHeight, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight(), 256, 256);
    }

    public void func_230988_a_(@Nonnull SoundHandler soundHandler) {
        if (this.playClickSound) {
            super.func_230988_a_(soundHandler);
        }
    }

    protected void playClickSound() {
        super.func_230988_a_(minecraft.func_147118_V());
    }

    protected void drawTiledSprite(MatrixStack matrix, int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, GuiUtils.TilingDirection tilingDirection) {
        GuiUtils.drawTiledSprite(matrix, xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, 16, 16, this.func_230927_p_(), tilingDirection);
    }

    @Override
    public void drawCenteredTextScaledBound(MatrixStack matrix, ITextComponent text, float maxLength, float x, float y, int color) {
        IFancyFontRenderer.super.drawCenteredTextScaledBound(matrix, text, maxLength, (float)this.relativeX + x, (float)this.relativeY + y, color);
    }

    @FunctionalInterface
    public static interface IClickable {
        public void onClick(GuiElement var1, int var2, int var3);
    }

    @FunctionalInterface
    public static interface IHoverable {
        public void onHover(GuiElement var1, MatrixStack var2, int var3, int var4);
    }

    public static enum ButtonBackground {
        DEFAULT(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "button.png")),
        DIGITAL(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "button_digital.png")),
        NONE(null);

        private final ResourceLocation texture;

        private ButtonBackground(ResourceLocation texture) {
            this.texture = texture;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }
    }
}

