/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class CombinerCachedRecipe
extends CachedRecipe<CombinerRecipe> {
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final IInputHandler<@NonNull ItemStack> inputHandler;
    private final IInputHandler<@NonNull ItemStack> extraInputHandler;
    private ItemStack recipeMain = ItemStack.field_190927_a;
    private ItemStack recipeExtra = ItemStack.field_190927_a;

    public CombinerCachedRecipe(CombinerRecipe recipe, IInputHandler<@NonNull ItemStack> inputHandler, IInputHandler<@NonNull ItemStack> extraInputHandler, IOutputHandler<@NonNull ItemStack> outputHandler) {
        super(recipe);
        this.inputHandler = Objects.requireNonNull(inputHandler, "Main input handler cannot be null.");
        this.extraInputHandler = Objects.requireNonNull(extraInputHandler, "Secondary/Extra input handler cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Output handler cannot be null.");
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        this.recipeMain = this.inputHandler.getRecipeInput(((CombinerRecipe)this.recipe).getMainInput());
        if (this.recipeMain.func_190926_b()) {
            return -1;
        }
        this.recipeExtra = this.extraInputHandler.getRecipeInput(((CombinerRecipe)this.recipe).getExtraInput());
        if (this.recipeExtra.func_190926_b()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(this.recipeMain, currentMax);
        if ((currentMax = this.extraInputHandler.operationsCanSupport(this.recipeExtra, currentMax)) <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((CombinerRecipe)this.recipe).getOutput(this.recipeMain, this.recipeExtra), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((CombinerRecipe)this.recipe).test(this.inputHandler.getInput(), this.extraInputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.recipeMain.func_190926_b() || this.recipeExtra.func_190926_b()) {
            return;
        }
        this.inputHandler.use(this.recipeMain, operations);
        this.extraInputHandler.use(this.recipeExtra, operations);
        this.outputHandler.handleOutput(((CombinerRecipe)this.recipe).getOutput(this.recipeMain, this.recipeExtra), operations);
    }
}

