/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.functions.FloatSupplier;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.ModuleConfigItemCreator;
import mekanism.api.math.FloatingLongSupplier;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;

@ParametersAreNonnullByDefault
public interface ICustomModule<MODULE extends ICustomModule<MODULE>> {
    default public void init(IModule<MODULE> module, ModuleConfigItemCreator configItemCreator) {
    }

    default public void tickServer(IModule<MODULE> module, PlayerEntity player) {
    }

    default public void tickClient(IModule<MODULE> module, PlayerEntity player) {
    }

    default public void addHUDStrings(IModule<MODULE> module, PlayerEntity player, Consumer<ITextComponent> hudStringAdder) {
    }

    default public void addHUDElements(IModule<MODULE> module, PlayerEntity player, Consumer<IHUDElement> hudElementAdder) {
    }

    default public boolean canChangeModeWhenDisabled(IModule<MODULE> module) {
        return false;
    }

    default public void changeMode(IModule<MODULE> module, PlayerEntity player, ItemStack stack, int shift, boolean displayChangeMessage) {
    }

    default public void onAdded(IModule<MODULE> module, boolean first) {
    }

    default public void onRemoved(IModule<MODULE> module, boolean last) {
    }

    default public void onEnabledStateChange(IModule<MODULE> module) {
    }

    @Nullable
    default public ModuleDamageAbsorbInfo getDamageAbsorbInfo(IModule<MODULE> module, DamageSource damageSource) {
        return null;
    }

    @Nonnull
    default public ActionResultType onItemUse(IModule<MODULE> module, ItemUseContext context) {
        return ActionResultType.PASS;
    }

    @Nonnull
    default public ActionResultType onInteract(IModule<MODULE> module, PlayerEntity player, LivingEntity entity, Hand hand) {
        return ActionResultType.PASS;
    }

    @Nonnull
    default public ModuleDispenseResult onDispense(IModule<MODULE> module, IBlockSource source) {
        return ModuleDispenseResult.DEFAULT;
    }

    public static enum ModuleDispenseResult {
        HANDLED,
        DEFAULT,
        FAIL_PREVENT_DROP;

    }

    public static class ModuleDamageAbsorbInfo {
        private final FloatSupplier absorptionRatio;
        private final FloatingLongSupplier energyCost;

        public ModuleDamageAbsorbInfo(FloatSupplier absorptionRatio, FloatingLongSupplier energyCost) {
            this.absorptionRatio = Objects.requireNonNull(absorptionRatio, "Absorption ratio supplier cannot be null");
            this.energyCost = Objects.requireNonNull(energyCost, "Energy cost supplier cannot be null");
        }

        public FloatSupplier getAbsorptionRatio() {
            return this.absorptionRatio;
        }

        public FloatingLongSupplier getEnergyCost() {
            return this.energyCost;
        }
    }
}

