/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.inputs.ItemStackIngredient;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.inputs.chemical.InfusionStackIngredient;
import mekanism.api.recipes.inputs.chemical.PigmentStackIngredient;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemStackChemicalToItemStackRecipeBuilder<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>>
extends MekanismRecipeBuilder<ItemStackChemicalToItemStackRecipeBuilder<CHEMICAL, STACK, INGREDIENT>> {
    private final ItemStackIngredient itemInput;
    private final INGREDIENT chemicalInput;
    private final ItemStack output;
    private final String chemicalInputKey;

    protected ItemStackChemicalToItemStackRecipeBuilder(ResourceLocation serializerName, ItemStackIngredient itemInput, INGREDIENT chemicalInput, ItemStack output, String chemicalInputKey) {
        super(serializerName);
        this.itemInput = itemInput;
        this.chemicalInput = chemicalInput;
        this.output = output;
        this.chemicalInputKey = chemicalInputKey;
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, GasStackIngredient> compressing(ItemStackIngredient itemInput, GasStackIngredient gasInput, ItemStack output) {
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("This compressing recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, GasStackIngredient>(ItemStackChemicalToItemStackRecipeBuilder.mekSerializer("compressing"), itemInput, gasInput, output, "gasInput");
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, GasStackIngredient> purifying(ItemStackIngredient itemInput, GasStackIngredient gasInput, ItemStack output) {
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("This purifying recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, GasStackIngredient>(ItemStackChemicalToItemStackRecipeBuilder.mekSerializer("purifying"), itemInput, gasInput, output, "gasInput");
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, GasStackIngredient> injecting(ItemStackIngredient itemInput, GasStackIngredient gasInput, ItemStack output) {
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("This injecting recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, GasStackIngredient>(ItemStackChemicalToItemStackRecipeBuilder.mekSerializer("injecting"), itemInput, gasInput, output, "gasInput");
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<InfuseType, InfusionStack, InfusionStackIngredient> metallurgicInfusing(ItemStackIngredient itemInput, InfusionStackIngredient infusionInput, ItemStack output) {
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("This metallurgic infusing recipe requires a non empty output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<InfuseType, InfusionStack, InfusionStackIngredient>(ItemStackChemicalToItemStackRecipeBuilder.mekSerializer("metallurgic_infusing"), itemInput, infusionInput, output, "infusionInput");
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Pigment, PigmentStack, PigmentStackIngredient> painting(ItemStackIngredient itemInput, PigmentStackIngredient pigmentInput, ItemStack output) {
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("This painting recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Pigment, PigmentStack, PigmentStackIngredient>(ItemStackChemicalToItemStackRecipeBuilder.mekSerializer("painting"), itemInput, pigmentInput, output, "chemicalInput");
    }

    @Override
    protected ItemStackChemicalToItemStackRecipeResult getResult(ResourceLocation id) {
        return new ItemStackChemicalToItemStackRecipeResult(id);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, this.output.func_77973_b().getRegistryName());
    }

    public class ItemStackChemicalToItemStackRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected ItemStackChemicalToItemStackRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void func_218610_a(@Nonnull JsonObject json) {
            json.add("itemInput", ItemStackChemicalToItemStackRecipeBuilder.this.itemInput.serialize());
            json.add(ItemStackChemicalToItemStackRecipeBuilder.this.chemicalInputKey, ItemStackChemicalToItemStackRecipeBuilder.this.chemicalInput.serialize());
            json.add("output", SerializerHelper.serializeItemStack(ItemStackChemicalToItemStackRecipeBuilder.this.output));
        }
    }
}

