/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.util;

import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import top.theillusivec4.curios.api.CuriosApi;

public class UtilInventory {
    public static Triple<String, Integer, ItemStack> getCurioRemote(PlayerEntity player, Item remote) {
        ItemStack temp;
        int i;
        ImmutableTriple equipped;
        Triple stackFound = Triple.of((Object)"", (Object)-1, (Object)ItemStack.field_190927_a);
        if (ModList.get().isLoaded("curios") && (equipped = (ImmutableTriple)CuriosApi.getCuriosHelper().findEquippedCurio(remote, (LivingEntity)player).orElse(null)) != null && UtilInventory.isRemote((ItemStack)equipped.right, remote)) {
            return Triple.of((Object)"curios", (Object)equipped.middle, (Object)equipped.right);
        }
        for (i = 0; i < player.func_71005_bN().func_70302_i_(); ++i) {
            temp = player.func_71005_bN().func_70301_a(i);
            if (!UtilInventory.isRemote(temp, remote)) continue;
            return Triple.of((Object)"ender", (Object)i, (Object)temp);
        }
        for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            temp = player.field_71071_by.func_70301_a(i);
            if (!UtilInventory.isRemote(temp, remote)) continue;
            return Triple.of((Object)"player", (Object)i, (Object)temp);
        }
        if (UtilInventory.isRemote(player.func_184592_cb(), remote)) {
            return Triple.of((Object)"offhand", (Object)-1, (Object)player.func_184592_cb());
        }
        if (UtilInventory.isRemote(player.func_184614_ca(), remote)) {
            return Triple.of((Object)"hand", (Object)-1, (Object)player.func_184614_ca());
        }
        return stackFound;
    }

    private static boolean isRemote(ItemStack temp, Item remote) {
        return temp.func_77973_b() == remote;
    }

    public static String formatLargeNumber(int size) {
        if ((double)size < Math.pow(10.0, 3.0)) {
            return size + "";
        }
        if ((double)size < Math.pow(10.0, 6.0)) {
            int rounded = Math.round((float)size / 1000.0f);
            return rounded + "K";
        }
        if ((double)size < Math.pow(10.0, 9.0)) {
            int rounded = Math.round((float)size / (float)Math.pow(10.0, 6.0));
            return rounded + "M";
        }
        if ((double)size < Math.pow(10.0, 12.0)) {
            int rounded = Math.round((float)size / (float)Math.pow(10.0, 9.0));
            return rounded + "B";
        }
        return size + "";
    }

    public static int containsAtLeastHowManyNeeded(IItemHandler inv, ItemStack stack, int minimumCount) {
        int found = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)inv.getStackInSlot(i), (ItemStack)stack)) continue;
            found += inv.getStackInSlot(i).func_190916_E();
        }
        if (found >= minimumCount) {
            return 0;
        }
        return minimumCount - found;
    }

    public static ItemStack extractItem(IItemHandler inv, ItemStackMatcher fil, int num, boolean simulate) {
        if (inv == null || fil == null) {
            return ItemStack.field_190927_a;
        }
        int extracted = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack ex;
            ItemStack slot = inv.getStackInSlot(i);
            if (!fil.match(slot) || (ex = inv.extractItem(i, 1, simulate)).func_190926_b()) continue;
            if (++extracted == num) {
                return ItemHandlerHelper.copyStackWithSize((ItemStack)slot, (int)num);
            }
            --i;
        }
        return ItemStack.field_190927_a;
    }

    public static void dropItem(World world, BlockPos pos, ItemStack stack) {
        if (pos == null || world.field_72995_K || stack.func_190926_b()) {
            return;
        }
        world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
    }
}

