/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.api.ITileNetworkSync;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkCraftingRemote;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkRemote;
import com.lothrazar.storagenetwork.item.remote.ItemStorageCraftingRemote;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class SettingsSyncMessage {
    private BlockPos pos;
    private boolean direction;
    private EnumSortType sort;
    private boolean targetTileEntity;
    private boolean jeiSync;

    private SettingsSyncMessage() {
    }

    public SettingsSyncMessage(BlockPos pos, boolean direction, EnumSortType sort, boolean jeiSync) {
        this.pos = pos;
        this.direction = direction;
        this.sort = sort;
        this.jeiSync = jeiSync;
    }

    public static void handle(SettingsSyncMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stackPlayerHeld;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (message.targetTileEntity) {
                TileEntity tileEntity = player.field_70170_p.func_175625_s(message.pos);
                if (tileEntity instanceof ITileNetworkSync) {
                    ITileNetworkSync tile = (ITileNetworkSync)tileEntity;
                    tile.setSort(message.sort);
                    tile.setDownwards(message.direction);
                    tile.setJeiSearchSynced(message.jeiSync);
                    tileEntity.func_70296_d();
                }
            } else if (player.field_71070_bA instanceof ContainerNetworkCraftingRemote) {
                ItemStack stackPlayerHeld2 = ((ContainerNetworkCraftingRemote)player.field_71070_bA).getRemote();
                if (stackPlayerHeld2.func_77973_b() instanceof ItemStorageCraftingRemote) {
                    ItemStorageCraftingRemote.setSort(stackPlayerHeld2, message.sort);
                    ItemStorageCraftingRemote.setDownwards(stackPlayerHeld2, message.direction);
                    ItemStorageCraftingRemote.setJeiSearchSynced(stackPlayerHeld2, message.jeiSync);
                }
            } else if (player.field_71070_bA instanceof ContainerNetworkRemote && (stackPlayerHeld = ((ContainerNetworkRemote)player.field_71070_bA).getRemote()).func_77973_b() instanceof ItemStorageCraftingRemote) {
                ItemStorageCraftingRemote.setSort(stackPlayerHeld, message.sort);
                ItemStorageCraftingRemote.setDownwards(stackPlayerHeld, message.direction);
                ItemStorageCraftingRemote.setJeiSearchSynced(stackPlayerHeld, message.jeiSync);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static SettingsSyncMessage decode(PacketBuffer buf) {
        SettingsSyncMessage message = new SettingsSyncMessage();
        message.direction = buf.readBoolean();
        int sort = buf.readInt();
        message.sort = EnumSortType.values()[sort];
        message.targetTileEntity = buf.readBoolean();
        message.pos = buf.func_179259_c();
        message.jeiSync = buf.readBoolean();
        return message;
    }

    public static void encode(SettingsSyncMessage msg, PacketBuffer buf) {
        buf.writeBoolean(msg.direction);
        buf.writeInt(msg.sort.ordinal());
        if (msg.pos != null) {
            buf.writeBoolean(true);
            buf.func_179255_a(msg.pos);
        } else {
            buf.writeBoolean(false);
            buf.func_179255_a(BlockPos.field_177992_a);
        }
        buf.writeBoolean(msg.jeiSync);
    }
}

