/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item.remote;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.api.EnumSortType;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkCraftingRemote;
import com.lothrazar.storagenetwork.item.remote.ContainerNetworkRemote;
import com.lothrazar.storagenetwork.registry.ConfigRegistry;
import com.lothrazar.storagenetwork.registry.SsnRegistry;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemStorageCraftingRemote
extends Item
implements INamedContainerProvider {
    public static final String NBT_JEI = "storagenetworkjei";
    public static final String NBT_BOUND = "bound";
    public static final String NBT_SORT = "sort";
    public static final String NBT_DOWN = "down";

    public ItemStorageCraftingRemote(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public static boolean isJeiSearchSynced(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b(NBT_JEI)) {
            return tag.func_74767_n(NBT_JEI);
        }
        return false;
    }

    public static void setJeiSearchSynced(ItemStack stack, boolean val) {
        stack.func_196082_o().func_74757_a(NBT_JEI, val);
    }

    public static boolean getDownwards(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b(NBT_DOWN)) {
            return tag.func_74767_n(NBT_DOWN);
        }
        return false;
    }

    public static void setDownwards(ItemStack stack, boolean val) {
        stack.func_196082_o().func_74757_a(NBT_DOWN, val);
    }

    public static EnumSortType getSort(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b(NBT_SORT)) {
            int sort = tag.func_74762_e(NBT_SORT);
            return EnumSortType.values()[sort];
        }
        return EnumSortType.NAME;
    }

    public static void setSort(ItemStack stack, EnumSortType val) {
        stack.func_196082_o().func_74768_a(NBT_SORT, val.ordinal());
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (world.func_175625_s(pos) instanceof TileMain) {
            ItemStack stack = player.func_184586_b(hand);
            DimPos.putPos(stack, pos, world);
            UtilTileEntity.statusMessage(player, "item.remote.connected");
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip");
        t.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)t);
        if (stack.func_77942_o()) {
            DimPos dp = DimPos.getPosStored(stack);
            tooltip.add(dp.makeTooltip());
        }
    }

    public static boolean openRemote(World world, PlayerEntity player, ItemStack itemStackIn, ItemStorageCraftingRemote thiss) {
        double distance;
        int dist;
        DimPos dp = DimPos.getPosStored(itemStackIn);
        if (dp == null || dp.getBlockPos() == null) {
            UtilTileEntity.statusMessage(player, "item.remote.notconnected");
            StorageNetwork.log("Remote not connected " + itemStackIn.func_77978_p());
            return false;
        }
        BlockPos posTarget = dp.getBlockPos();
        if ((Integer)ConfigRegistry.REMOTE_MAX_RANGE.get() != -1 && (dist = (int)Math.sqrt(distance = player.func_70092_e((double)posTarget.func_177958_n() + 0.5, (double)posTarget.func_177956_o() + 0.5, (double)posTarget.func_177952_p() + 0.5))) >= (Integer)ConfigRegistry.REMOTE_MAX_RANGE.get()) {
            UtilTileEntity.statusMessage(player, UtilTileEntity.lang("item.remote.outofrange"));
            return false;
        }
        if (world.field_72995_K) {
            return false;
        }
        ServerWorld serverTargetWorld = null;
        try {
            serverTargetWorld = DimPos.stringDimensionLookup(dp.getDimension(), world.func_73046_m());
            if (serverTargetWorld == null) {
                StorageNetwork.LOGGER.error("Missing dimension key " + dp.getDimension());
            }
        }
        catch (Exception e) {
            StorageNetwork.LOGGER.error("unknown exception on dim " + dp.getDimension(), (Throwable)e);
            return false;
        }
        if (!serverTargetWorld.isAreaLoaded(posTarget, 1)) {
            UtilTileEntity.chatMessage(player, "item.remote.notloaded");
            StorageNetwork.LOGGER.info(UtilTileEntity.lang("item.remote.notloaded") + posTarget);
            return false;
        }
        TileEntity tile = serverTargetWorld.func_175625_s(posTarget);
        if (tile instanceof TileMain) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)thiss);
            return true;
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("item.remote.notfound"), true);
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (hand != Hand.MAIN_HAND) {
            return super.func_77659_a(world, player, hand);
        }
        ItemStack itemStackIn = player.func_184586_b(hand);
        if (ItemStorageCraftingRemote.openRemote(world, player, itemStackIn, this)) {
            return ActionResult.func_226248_a_((Object)itemStackIn);
        }
        return super.func_77659_a(world, player, hand);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.func_77658_a());
    }

    public Container createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        boolean crafting;
        boolean bl = crafting = this == SsnRegistry.CRAFTING_REMOTE;
        if (crafting) {
            return new ContainerNetworkCraftingRemote(id, inv);
        }
        return new ContainerNetworkRemote(id, inv);
    }
}

