/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.item;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.api.DimPos;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.util.UtilInventory;
import com.lothrazar.storagenetwork.util.UtilTileEntity;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import org.apache.commons.lang3.tuple.Triple;

public class ItemCollector
extends Item {
    public static final String NBT_BOUND = "bound";

    public ItemCollector(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    protected ItemStack findAmmo(PlayerEntity player, Item item) {
        Triple<String, Integer, ItemStack> remote = UtilInventory.getCurioRemote(player, item);
        return (ItemStack)remote.getRight();
    }

    public void onEntityItemPickupEvent(EntityItemPickupEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && event.getItem() != null && !event.getItem().func_92059_d().func_190926_b()) {
            ItemStack item = event.getItem().func_92059_d();
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            World world = player.field_70170_p;
            DimPos dp = DimPos.getPosStored(this.findAmmo(player, this));
            if (dp != null && !world.field_72995_K) {
                ServerWorld serverTargetWorld = DimPos.stringDimensionLookup(dp.getDimension(), world.func_73046_m());
                if (serverTargetWorld == null) {
                    StorageNetwork.LOGGER.error("Missing dimension key " + dp.getDimension());
                    return;
                }
                TileEntity tile = serverTargetWorld.func_175625_s(dp.getBlockPos());
                if (tile instanceof TileMain) {
                    TileMain network = (TileMain)tile;
                    int countUnmoved = network.insertStack(item.func_77946_l(), false);
                    if (countUnmoved == 0) {
                        item.func_190920_e(0);
                        event.getItem().func_92058_a(item);
                        event.getItem().func_70106_y();
                        UtilTileEntity.playSoundFromServer((ServerPlayerEntity)player, SoundEvents.field_187638_cR, 0.2f);
                    } else {
                        StorageNetwork.log("info: unmoved items from collector " + countUnmoved + " " + item);
                    }
                } else {
                    StorageNetwork.LOGGER.error("item.remote.notfound");
                }
            }
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (world.func_175625_s(pos) instanceof TileMain) {
            ItemStack stack = player.func_184586_b(hand);
            DimPos.putPos(stack, pos, world);
            UtilTileEntity.statusMessage(player, "item.remote.connected");
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent t = new TranslationTextComponent(this.func_77658_a() + ".tooltip");
        t.func_240699_a_(TextFormatting.GRAY);
        tooltip.add((ITextComponent)t);
        if (stack.func_77942_o()) {
            DimPos dp = DimPos.getPosStored(stack);
            tooltip.add(dp.makeTooltip());
        }
    }
}

