/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.api;

import com.google.common.base.Objects;
import com.lothrazar.storagenetwork.StorageNetwork;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;

public class DimPos
implements INBTSerializable<CompoundNBT> {
    private String dimension;
    private BlockPos pos = new BlockPos(0, 0, 0);
    private World world;
    public static final String NBT_Z = "Z";
    public static final String NBT_Y = "Y";
    public static final String NBT_X = "X";
    public static final String NBT_DIM = "dimension";
    public static final String NBT_BOUND = "bound";

    public DimPos(CompoundNBT tag) {
        this.deserializeNBT(tag);
    }

    public DimPos(World world, BlockPos pos) {
        this.pos = pos;
        this.setWorld(world);
        if (world != null) {
            this.dimension = DimPos.dimensionToString(world);
        }
    }

    public static DimPos getPosStored(ItemStack itemStackIn) {
        if (itemStackIn.func_77978_p() == null || !itemStackIn.func_196082_o().func_74767_n(NBT_BOUND)) {
            return null;
        }
        return new DimPos(itemStackIn.func_196082_o());
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public BlockState getBlockState() {
        return this.getWorld().func_180495_p(this.getBlockPos());
    }

    public <V> V getTileEntity(Class<V> tileEntityClassOrInterface) {
        return this.getTileEntity(tileEntityClassOrInterface, this.getWorld());
    }

    public static String dimensionToString(World w) {
        return w.func_234923_W_().func_240901_a_().toString();
    }

    public static void putPos(ItemStack stack, BlockPos pos, World world) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74768_a(NBT_X, pos.func_177958_n());
        tag.func_74768_a(NBT_Y, pos.func_177956_o());
        tag.func_74768_a(NBT_Z, pos.func_177952_p());
        tag.func_74778_a(NBT_DIM, DimPos.dimensionToString(world));
        tag.func_74757_a(NBT_BOUND, true);
    }

    public static String getDim(ItemStack stack) {
        return stack.func_196082_o().func_74779_i(NBT_DIM);
    }

    public static void putDim(ItemStack stack, World world) {
        stack.func_196082_o().func_74778_a(NBT_DIM, DimPos.dimensionToString(world));
    }

    public static ServerWorld stringDimensionLookup(String s, MinecraftServer serv) {
        return DimPos.stringDimensionLookup(ResourceLocation.func_208304_a((String)s), serv);
    }

    public static ServerWorld stringDimensionLookup(ResourceLocation s, MinecraftServer serv) {
        RegistryKey worldKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)s);
        if (worldKey == null) {
            return null;
        }
        return serv.func_71218_a(worldKey);
    }

    @Nullable
    public <V> V getTileEntity(Class<V> tileEntityClassOrInterface, World world) {
        BlockPos tilePos;
        if (world == null || this.getBlockPos() == null) {
            return null;
        }
        if (this.dimension != null && world.func_73046_m() != null && !this.dimension.isEmpty()) {
            ServerWorld dimWorld = DimPos.stringDimensionLookup(this.dimension, world.func_73046_m());
            if (dimWorld != null) {
                world = dimWorld.func_201672_e();
            } else {
                StorageNetwork.LOGGER.error(" Dimworld NOT FOUND for " + this.dimension);
            }
        }
        if ((tilePos = this.getBlockPos()) == null) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(tilePos);
        if (tileEntity == null) {
            return null;
        }
        if (!tileEntityClassOrInterface.isAssignableFrom(tileEntity.getClass())) {
            return null;
        }
        return (V)tileEntity;
    }

    public <V> V getCapability(Capability<V> capability, Direction side) {
        World world = this.getWorld();
        if (world == null || this.getBlockPos() == null) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(this.getBlockPos());
        if (tileEntity == null) {
            return null;
        }
        return (V)tileEntity.getCapability(capability, side).orElse(null);
    }

    public boolean isLoaded() {
        if (this.world == null) {
            return false;
        }
        return this.world.func_175667_e(this.pos);
    }

    public boolean equals(World world, BlockPos pos) {
        return pos.equals((Object)this.pos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimPos dimPos = (DimPos)o;
        return this.dimension.equals(dimPos.dimension) && Objects.equal((Object)this.pos, (Object)dimPos.pos);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dimension, this.pos});
    }

    public String toString() {
        return "[dimension=" + this.dimension + ", pos=" + this.pos + ", world=" + this.getWorld() + ']';
    }

    public CompoundNBT serializeNBT() {
        if (this.pos == null) {
            this.pos = new BlockPos(0, 0, 0);
        }
        CompoundNBT result = NBTUtil.func_186859_a((BlockPos)this.pos);
        result.func_74778_a(NBT_DIM, this.dimension);
        return result;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.pos = NBTUtil.func_186861_c((CompoundNBT)nbt);
        this.dimension = nbt.func_74779_i(NBT_DIM);
    }

    public DimPos offset(Direction direction) {
        if (this.pos == null || direction == null) {
            StorageNetwork.LOGGER.info("Error: null offset in DimPos " + direction);
            return null;
        }
        return new DimPos(this.getWorld(), this.pos.func_177972_a(direction));
    }

    public IChunk getChunk() {
        return this.getWorld().func_217349_x(this.pos);
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public String getDimension() {
        return this.dimension;
    }

    public ITextComponent makeTooltip() {
        TranslationTextComponent t = new TranslationTextComponent("[" + this.pos.func_177958_n() + ", " + this.pos.func_177956_o() + ", " + this.pos.func_177952_p() + ", " + this.dimension + "]");
        t.func_240699_a_(TextFormatting.DARK_GRAY);
        return t;
    }
}

