/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.event;

import cofh.ensorcellation.enchantment.AnglerEnchantment;
import cofh.ensorcellation.enchantment.CavalierEnchantment;
import cofh.ensorcellation.enchantment.DamageEnderEnchantment;
import cofh.ensorcellation.enchantment.DamageIllagerEnchantment;
import cofh.ensorcellation.enchantment.DamageVillagerEnchantment;
import cofh.ensorcellation.enchantment.FireRebukeEnchantment;
import cofh.ensorcellation.enchantment.FrostAspectEnchantment;
import cofh.ensorcellation.enchantment.HunterEnchantment;
import cofh.ensorcellation.enchantment.MagicEdgeEnchantment;
import cofh.ensorcellation.enchantment.PilferingEnchantment;
import cofh.ensorcellation.enchantment.VitalityEnchantment;
import cofh.ensorcellation.enchantment.VorpalEnchantment;
import cofh.ensorcellation.enchantment.XpBoostEnchantment;
import cofh.ensorcellation.enchantment.override.FrostWalkerEnchantmentImp;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.references.EnsorcReferences;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.FrostWalkerEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTables;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class CommonEvents {
    private CommonEvents() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        int encMagicEdge;
        if (event.isCanceled()) {
            return;
        }
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        if (attacker instanceof LivingEntity && (encMagicEdge = Utils.getHeldEnchantmentLevel((LivingEntity)((LivingEntity)attacker), (Enchantment)EnsorcReferences.MAGIC_EDGE)) > 0 && !source.func_82725_o()) {
            source.func_76348_h().func_82726_p();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleLivingDamageEvent(LivingDamageEvent event) {
        LivingEntity living;
        int encMercy;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        if (attacker instanceof LivingEntity && (encMercy = Utils.getHeldEnchantmentLevel((LivingEntity)(living = (LivingEntity)attacker), (Enchantment)EnsorcReferences.CURSE_MERCY)) > 0 && event.getAmount() > entity.func_110143_aJ()) {
            event.setAmount(Math.max(0.0f, entity.func_110143_aJ() - 1.0f));
        }
    }

    @SubscribeEvent
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity living;
        int encLeech;
        if (event.isCanceled()) {
            return;
        }
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        if (attacker instanceof LivingEntity && (encLeech = Utils.getHeldEnchantmentLevel((LivingEntity)(living = (LivingEntity)attacker), (Enchantment)EnsorcReferences.LEECH)) > 0) {
            living.func_70691_i((float)encLeech);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingDropsEvent(LivingDropsEvent event) {
        int encVorpal;
        ItemEntity drop;
        int emeraldDrop;
        int encDamageVillager;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        if (!(attacker instanceof PlayerEntity) || !event.isRecentlyHit()) {
            return;
        }
        PlayerEntity player = (PlayerEntity)attacker;
        int encHunter = Utils.getHeldEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.HUNTER);
        if (encHunter > 0 && entity instanceof AnimalEntity) {
            LootTable table = entity.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(entity.func_213346_cF());
            LootContext.Builder contextBuilder = new LootContext.Builder((ServerWorld)entity.field_70170_p).func_216023_a(entity.field_70170_p.field_73012_v).func_216015_a(LootParameters.field_216281_a, (Object)entity).func_216015_a(LootParameters.field_237457_g_, (Object)entity.func_213303_ch()).func_216015_a(LootParameters.field_216283_c, (Object)source).func_216021_b(LootParameters.field_216284_d, (Object)source.func_76346_g()).func_216021_b(LootParameters.field_216285_e, (Object)source.func_76364_f());
            contextBuilder = contextBuilder.func_216015_a(LootParameters.field_216282_b, (Object)player).func_186469_a(player.func_184817_da());
            for (int i = 0; i < encHunter; ++i) {
                if (player.func_70681_au().nextInt(100) >= HunterEnchantment.chance) continue;
                for (ItemStack stack : table.func_216113_a(contextBuilder.func_216022_a(LootParameterSets.field_216263_d))) {
                    ItemEntity drop2 = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack);
                    event.getDrops().add(drop2);
                }
            }
        }
        if ((encDamageVillager = Utils.getHeldEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.DAMAGE_VILLAGER)) > 0 && DamageVillagerEnchantment.validTarget((Entity)entity) && (emeraldDrop = MathHelper.nextInt((int)0, (int)encDamageVillager)) > 0) {
            ItemStack stack = new ItemStack((IItemProvider)Items.field_151166_bC, emeraldDrop);
            drop = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack);
            event.getDrops().add(drop);
        }
        if ((encVorpal = Utils.getHeldEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.VORPAL)) > 0) {
            ItemStack itemSkull = ItemStack.field_190927_a;
            if (entity.field_70170_p.field_73012_v.nextInt(100) < VorpalEnchantment.headBase + VorpalEnchantment.headLevel * encVorpal) {
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity target = (ServerPlayerEntity)event.getEntity();
                    itemSkull = new ItemStack((IItemProvider)Items.field_196184_dx);
                    CompoundNBT tag = new CompoundNBT();
                    tag.func_74778_a("SkullOwner", target.func_200200_C_().getString());
                    itemSkull.func_77982_d(tag);
                } else if (entity instanceof SkeletonEntity) {
                    itemSkull = new ItemStack((IItemProvider)Items.field_196182_dv);
                } else if (entity instanceof WitherSkeletonEntity) {
                    itemSkull = new ItemStack((IItemProvider)Items.field_196183_dw);
                } else if (entity instanceof ZombieEntity) {
                    itemSkull = new ItemStack((IItemProvider)Items.field_196186_dz);
                } else if (entity instanceof CreeperEntity) {
                    itemSkull = new ItemStack((IItemProvider)Items.field_196185_dy);
                }
            }
            if (itemSkull.func_190926_b()) {
                return;
            }
            drop = new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), itemSkull);
            drop.func_174867_a(10);
            event.getDrops().add(drop);
        }
    }

    @SubscribeEvent
    public static void handleLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity entity = event.getEntityLiving();
        int encReach = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)entity, (Enchantment)EnsorcReferences.REACH);
        ModifiableAttributeInstance reachAttr = entity.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (reachAttr != null) {
            reachAttr.func_188479_b(Constants.UUID_ENCH_REACH_DISTANCE);
            if (encReach > 0) {
                reachAttr.func_233767_b_(new AttributeModifier(Constants.UUID_ENCH_REACH_DISTANCE, "reach", (double)encReach, AttributeModifier.Operation.ADDITION));
            }
        }
        int encVitality = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)entity, (Enchantment)EnsorcReferences.VITALITY);
        ModifiableAttributeInstance healthAttr = entity.func_110148_a(Attributes.field_233818_a_);
        if (healthAttr != null) {
            healthAttr.func_188479_b(Constants.UUID_ENCH_VITALITY_HEALTH);
            if (encVitality > 0) {
                healthAttr.func_233767_b_(new AttributeModifier(Constants.UUID_ENCH_VITALITY_HEALTH, "vitality", (double)(encVitality * VitalityEnchantment.health), AttributeModifier.Operation.ADDITION));
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingExperienceDropEvent(LivingExperienceDropEvent event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getAttackingPlayer();
        if (player != null) {
            int encFool = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.CURSE_FOOL);
            if (encFool > 0) {
                event.setDroppedExperience(0);
                event.setCanceled(true);
                return;
            }
            int encExpBoost = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.XP_BOOST);
            if (encExpBoost > 0) {
                event.setDroppedExperience(XpBoostEnchantment.getExp(event.getDroppedExperience(), encExpBoost, player.field_70170_p.field_73012_v));
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        int encInstigating;
        int encVorpal;
        int encMagicEdge;
        int encFrostAspect;
        int encCavalier;
        int encDamageVillager;
        int encDamageIllager;
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)attacker;
        int encDamageEnder = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)EnsorcReferences.DAMAGE_ENDER);
        if (encDamageEnder > 0 && DamageEnderEnchantment.validTarget((Entity)entity)) {
            event.setAmount(event.getAmount() + DamageEnderEnchantment.getExtraDamage((int)encDamageEnder));
        }
        if ((encDamageIllager = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)EnsorcReferences.DAMAGE_ILLAGER)) > 0 && DamageIllagerEnchantment.validTarget((Entity)entity)) {
            event.setAmount(event.getAmount() + DamageIllagerEnchantment.getExtraDamage((int)encDamageIllager));
        }
        if ((encDamageVillager = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)EnsorcReferences.DAMAGE_VILLAGER)) > 0 && DamageVillagerEnchantment.validTarget((Entity)entity)) {
            event.setAmount(event.getAmount() + DamageVillagerEnchantment.getExtraDamage((int)encDamageVillager));
        }
        if ((encCavalier = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)EnsorcReferences.CAVALIER)) > 0 && living.func_184187_bx() != null) {
            event.setAmount(event.getAmount() * (1.0f + CavalierEnchantment.damageMult * (float)MathHelper.nextInt((int)1, (int)encCavalier)));
        }
        if ((encFrostAspect = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)EnsorcReferences.FROST_ASPECT)) > 0) {
            FrostAspectEnchantment.onHit(entity, encFrostAspect);
            if (FrostAspectEnchantment.validTarget((Entity)entity)) {
                event.setAmount(event.getAmount() + FrostAspectEnchantment.getExtraDamage(encFrostAspect));
            }
        }
        if ((encMagicEdge = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)EnsorcReferences.MAGIC_EDGE)) > 0 && source.func_82725_o()) {
            event.setAmount(event.getAmount() + MagicEdgeEnchantment.getExtraDamage(encMagicEdge));
            MagicEdgeEnchantment.onHit(entity, encMagicEdge);
        }
        if ((encVorpal = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)EnsorcReferences.VORPAL)) > 0 && entity.field_70170_p.field_73012_v.nextInt(100) < VorpalEnchantment.critBase + VorpalEnchantment.critLevel * encVorpal) {
            event.setAmount(event.getAmount() * (float)VorpalEnchantment.critDamage);
            VorpalEnchantment.onHit(entity, encVorpal);
        }
        if ((encInstigating = Utils.getHeldEnchantmentLevel((LivingEntity)living, (Enchantment)EnsorcReferences.INSTIGATING)) > 0 && entity.func_110143_aJ() >= entity.func_110138_aP()) {
            event.setAmount(event.getAmount() * (float)(1 + encInstigating));
        }
    }

    @SubscribeEvent
    public static void handleLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        int encFrostWalker = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)entity, (Enchantment)Enchantments.field_185301_j);
        if (encFrostWalker > 0) {
            FrostWalkerEnchantment.func_185266_a((LivingEntity)entity, (World)entity.field_70170_p, (BlockPos)entity.func_233580_cy_(), (int)encFrostWalker);
            FrostWalkerEnchantmentImp.freezeNearby(entity, entity.field_70170_p, entity.func_233580_cy_(), encFrostWalker);
        }
    }

    @SubscribeEvent
    public static void handleItemUseFinish(LivingEntityUseItemEvent.Finish event) {
        int encGourmand;
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof PlayerEntity) || entity instanceof FakePlayer) {
            return;
        }
        Food food = event.getItem().func_77973_b().func_219967_s();
        if (food != null && (encGourmand = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)entity, (Enchantment)EnsorcReferences.GOURMAND)) > 0 && food != null) {
            int foodLevel = food.func_221466_a();
            float foodSaturation = food.func_221469_b();
            FoodStats playerStats = ((PlayerEntity)entity).func_71024_bL();
            int playerFood = playerStats.func_75116_a();
            playerStats.func_75122_a(foodLevel + encGourmand, foodSaturation + (float)encGourmand * 0.1f);
            playerStats.func_75114_a(Math.min(playerFood + encGourmand, 20));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleItemFishedEvent(ItemFishedEvent event) {
        int encExpBoost;
        if (event.isCanceled()) {
            return;
        }
        FishingBobberEntity hook = event.getHookEntity();
        Entity angler = hook.func_234616_v_();
        if (!(angler instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)angler;
        int encAngler = Utils.getHeldEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.ANGLER);
        if (encAngler > 0) {
            ItemStack fishingRod = player.func_184614_ca();
            LootContext.Builder contextBuilder = new LootContext.Builder((ServerWorld)hook.field_70170_p).func_216015_a(LootParameters.field_237457_g_, (Object)hook.func_213303_ch()).func_216015_a(LootParameters.field_216289_i, (Object)fishingRod).func_216023_a(hook.field_70170_p.field_73012_v).func_186469_a((float)hook.field_191518_aw + player.func_184817_da());
            contextBuilder.func_216015_a(LootParameters.field_216284_d, (Object)player).func_216015_a(LootParameters.field_216281_a, (Object)hook);
            LootTable table = hook.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
            ArrayList list = new ArrayList();
            for (int i = 0; i < encAngler; ++i) {
                if (player.func_70681_au().nextInt(100) >= AnglerEnchantment.chance) continue;
                list.addAll(table.func_216113_a(contextBuilder.func_216022_a(LootParameterSets.field_216262_c)));
            }
            for (ItemStack stack : list) {
                ItemEntity drop = new ItemEntity(hook.field_70170_p, hook.func_226277_ct_(), hook.func_226278_cu_(), hook.func_226281_cx_(), stack);
                double d0 = player.func_226277_ct_() - hook.func_226277_ct_();
                double d1 = player.func_226278_cu_() - hook.func_226278_cu_();
                double d2 = player.func_226281_cx_() - hook.func_226281_cx_();
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                drop.func_213293_j(d0 * 0.1, d1 * 0.1 + Math.sqrt(d3) * 0.08, d2 * 0.1);
                hook.field_70170_p.func_217376_c((Entity)drop);
                if (!stack.func_77973_b().func_206844_a((ITag)ItemTags.field_206964_G)) continue;
                player.func_195067_a(Stats.field_188071_E, 1);
            }
        }
        if ((encExpBoost = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.XP_BOOST)) > 0) {
            hook.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_() + 0.5, XpBoostEnchantment.getExp(0, encExpBoost, player.field_70170_p.field_73012_v)));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void handlePickupXpEvent(PlayerXpEvent.PickupXp event) {
        PlayerEntity player = event.getPlayer();
        ExperienceOrbEntity orb = event.getOrb();
        int encFool = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.CURSE_FOOL);
        if (encFool > 0) {
            orb.field_70530_e = 0;
            orb.func_70106_y();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void handlePlayerRightClickEvent(PlayerInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event instanceof PlayerInteractEvent.RightClickItem || event instanceof PlayerInteractEvent.RightClickBlock || event instanceof PlayerInteractEvent.RightClickEmpty)) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player.field_71104_cf == null || Utils.isClientWorld((World)player.field_70170_p)) {
            return;
        }
        FishingBobberEntity hook = player.field_71104_cf;
        Entity entity = hook.func_234607_k_();
        if (entity instanceof PlayerEntity && !PilferingEnchantment.allowPlayerStealing) {
            return;
        }
        int encPilfer = Utils.getHeldEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.PILFERING);
        if (encPilfer > 0 && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ItemStack armor = CommonEvents.stealArmor(living);
            if (armor.func_190926_b()) {
                return;
            }
            ItemEntity armorEntity = new ItemEntity(living.field_70170_p, living.func_226277_ct_(), living.func_226278_cu_() + 0.5, living.func_226281_cx_(), armor);
            armorEntity.func_200217_b(player.func_110124_au());
            armorEntity.func_174867_a(5);
            armorEntity.field_70170_p.func_217376_c((Entity)armorEntity);
            armorEntity.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        }
    }

    @SubscribeEvent
    public static void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (event.getExpToDrop() > 0) {
            int encFool = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.CURSE_FOOL);
            if (encFool > 0) {
                event.setExpToDrop(0);
                return;
            }
            int encExpBoost = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.XP_BOOST);
            if (encExpBoost > 0) {
                event.setExpToDrop(XpBoostEnchantment.getExp(event.getExpToDrop(), encExpBoost, player.field_70170_p.field_73012_v));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        int encAirAffinity = Utils.getMaxEquippedEnchantmentLevel((LivingEntity)player, (Enchantment)EnsorcReferences.AIR_AFFINITY);
        if (encAirAffinity > 0 && !player.func_233570_aj_()) {
            event.setNewSpeed(Math.max(event.getNewSpeed(), event.getOriginalSpeed() * 5.0f));
        }
    }

    @SubscribeEvent
    public static void handleTickEndEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            FireRebukeEnchantment.setFireToMobs();
        }
    }

    private static ItemStack stealArmor(LivingEntity living) {
        ItemStack stack = ItemStack.field_190927_a;
        for (EquipmentSlotType slot : Constants.ARMOR_SLOTS) {
            if (living.func_184582_a(slot).func_190926_b()) continue;
            stack = living.func_184582_a(slot);
            living.func_184201_a(slot, ItemStack.field_190927_a);
            break;
        }
        return stack;
    }
}

