/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.patreon;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import javax.crypto.Cipher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderPlayerEvent;
import xaero.common.MinimapLogs;
import xaero.common.patreon.PatreonMod;
import xaero.common.patreon.decrypt.DecryptInputStream;

public class Patreon {
    private static HashMap<Integer, ArrayList<String>> patrons = new HashMap();
    private static boolean notificationDisplayed;
    private static boolean loaded;
    private static boolean showCapes;
    private static int patronPledge;
    private static String updateLocation;
    private static HashMap<String, Object> mods;
    private static ArrayList<Object> outdatedMods;
    private static Cipher cipher;
    private static int KEY_VERSION;
    private static String publicKeyString;
    private static File optionsFile;
    private static String rendersCapes;
    private static ResourceLocation cape1;
    private static ResourceLocation cape2;
    private static ResourceLocation cape3;
    private static ResourceLocation cape4;
    private static boolean pauseCapes;
    private static String oldPublicKeyString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkPatreon() {
        HashMap<Integer, ArrayList<String>> hashMap = patrons;
        synchronized (hashMap) {
            if (loaded) {
                return;
            }
            Patreon.loadSettings();
            String s = "http://data.chocolateminecraft.com/Versions_" + KEY_VERSION + "/Patreon.dat";
            s = s.replaceAll(" ", "%20");
            try {
                String[] args;
                String line;
                URL url = new URL(s);
                URLConnection conn = url.openConnection();
                conn.setReadTimeout(900);
                conn.setConnectTimeout(900);
                if (conn.getContentLengthLong() > 524288L) {
                    throw new IOException("Input too long to trust!");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(new DecryptInputStream(conn.getInputStream(), cipher)));
                int pledge = -1;
                while ((line = reader.readLine()) != null && !line.equals("LAYOUTS")) {
                    if (line.startsWith("PATREON")) {
                        pledge = Integer.parseInt(line.substring(7));
                        patrons.put(pledge, new ArrayList());
                        continue;
                    }
                    if (pledge == -1) continue;
                    args = line.split("\\t");
                    patrons.get(pledge).add(args[0]);
                    if (!args[0].equalsIgnoreCase(Minecraft.func_71410_x().func_110432_I().func_148256_e().getName())) continue;
                    Patreon.setPatronPledge(pledge);
                }
                updateLocation = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    args = line.split("\\t");
                    Patreon.getMods().put(args[0], new PatreonMod(args[0], args[1], args[2], args[3]));
                }
                reader.close();
            }
            catch (Throwable e) {
                MinimapLogs.LOGGER.error("suppressed exception", e);
                patrons.clear();
                Patreon.getMods().clear();
            }
            finally {
                loaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOutdatedMod(Object mod) {
        ArrayList<Object> arrayList = Patreon.getOutdatedMods();
        synchronized (arrayList) {
            Patreon.getOutdatedMods().add(mod);
        }
    }

    public static int getPatronPledge(String name) {
        Integer[] keys = patrons.keySet().toArray(new Integer[0]);
        for (int i = 0; i < keys.length; ++i) {
            if (!patrons.get(keys[i]).contains(name)) continue;
            return keys[i];
        }
        return -1;
    }

    public static void saveSettings() {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(optionsFile));
            writer.println("showCapes:" + Patreon.isShowCapes());
            writer.close();
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public static void loadSettings() {
        try {
            String line;
            if (!optionsFile.exists()) {
                Patreon.saveSettings();
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(optionsFile));
            while ((line = reader.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equalsIgnoreCase("showCapes")) continue;
                Patreon.setShowCapes(args[1].equals("true"));
            }
            reader.close();
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public static ResourceLocation getPlayerCape(String modID, AbstractClientPlayerEntity playerEntity) {
        if (!pauseCapes && Patreon.isShowCapes() && modID.equals(Patreon.getRendersCapes())) {
            ResourceLocation cape = null;
            int pledge = Patreon.getPatronPledge(playerEntity.func_200200_C_().getString());
            if (pledge == 2) {
                cape = cape1;
            } else if (pledge == 5) {
                cape = cape2;
            } else if (pledge == 10) {
                cape = cape3;
            } else if (pledge == 50) {
                cape = cape4;
            }
            if (cape == null) {
                return null;
            }
            pauseCapes = true;
            ResourceLocation realCape = playerEntity.func_110303_q();
            boolean realIsWearing = playerEntity.func_175148_a(PlayerModelPart.CAPE);
            pauseCapes = false;
            if (realCape != null && realIsWearing) {
                return realCape;
            }
            return cape;
        }
        return null;
    }

    public static Boolean isWearingCape(String modID, AbstractClientPlayerEntity playerEntity) {
        if (!pauseCapes && Patreon.isShowCapes() && modID.equals(Patreon.getRendersCapes())) {
            pauseCapes = true;
            ResourceLocation realCape = playerEntity.func_110303_q();
            boolean realIsWearing = playerEntity.func_175148_a(PlayerModelPart.CAPE);
            pauseCapes = false;
            if (realIsWearing || realCape == null) {
                return realIsWearing;
            }
            int pledge = Patreon.getPatronPledge(playerEntity.func_200200_C_().getString());
            return pledge >= 2;
        }
        return null;
    }

    public static void renderCapeFallback(String modID, RenderPlayerEvent.Post event) {
        if (!event.getPlayer().func_70089_S() || event.getPlayer().func_70608_bn() || event.getPlayer().func_203007_ba()) {
            return;
        }
        pauseCapes = true;
        ResourceLocation realCape = ((AbstractClientPlayerEntity)event.getPlayer()).func_110303_q();
        boolean realIsWearing = event.getPlayer().func_175148_a(PlayerModelPart.CAPE);
        pauseCapes = false;
        if (realCape != null && realIsWearing || realCape == null && !realIsWearing) {
            return;
        }
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)event.getPlayer();
        ResourceLocation cape = Patreon.getPlayerCape(modID, player);
        if (cape == null) {
            return;
        }
        ItemStack itemstack = event.getPlayer().func_184582_a(EquipmentSlotType.CHEST);
        if (itemstack == null || itemstack.func_77973_b() != Items.field_185160_cR) {
            MatrixStack matrixStack = event.getMatrixStack();
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
            matrixStack.func_227861_a_(0.0, -1.35, 0.0);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * event.getPartialRenderTick()));
            GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.func_227861_a_(0.0, 0.0, 0.125);
            double d0 = player.field_71091_bM + (player.field_71094_bP - player.field_71091_bM) * (double)event.getPartialRenderTick() - (player.field_70169_q + (player.func_226277_ct_() - player.field_70169_q) * (double)event.getPartialRenderTick());
            double d1 = player.field_71096_bN + (player.field_71095_bQ - player.field_71096_bN) * (double)event.getPartialRenderTick() - (player.field_70167_r + (player.func_226278_cu_() - player.field_70167_r) * (double)event.getPartialRenderTick());
            double d2 = player.field_71097_bO + (player.field_71085_bR - player.field_71097_bO) * (double)event.getPartialRenderTick() - (player.field_70166_s + (player.func_226281_cx_() - player.field_70166_s) * (double)event.getPartialRenderTick());
            float f = player.field_70760_ar + (player.field_70761_aq - player.field_70760_ar) * event.getPartialRenderTick();
            double d3 = MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
            double d4 = -MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)150.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = MathHelper.func_76131_a((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = player.field_71107_bF + (player.field_71109_bG - player.field_71107_bF) * event.getPartialRenderTick();
            f1 += MathHelper.func_76126_a((float)((player.field_70141_P + (player.field_70140_Q - player.field_70141_P) * event.getPartialRenderTick()) * 6.0f)) * 32.0f * f4;
            if (event.getPlayer().func_225608_bj_()) {
                f1 += 25.0f;
            }
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(6.0f + Math.min(90.0f, f2 / 2.0f) + f1));
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(f3 / 2.0f));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f - f3 / 2.0f));
            IVertexBuilder ivertexbuilder = event.getBuffers().getBuffer(RenderType.func_228634_a_((ResourceLocation)cape));
            ((PlayerModel)event.getRenderer().func_217764_d()).func_228289_b_(matrixStack, ivertexbuilder, event.getLight(), OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
    }

    public static ArrayList<Object> getOutdatedMods() {
        return outdatedMods;
    }

    public static boolean needsNotification() {
        return !Patreon.isNotificationDisplayed() && !outdatedMods.isEmpty();
    }

    public static int getPatronPledge() {
        return patronPledge;
    }

    public static void setPatronPledge(int patronPledge) {
        Patreon.patronPledge = patronPledge;
    }

    public static String getPublicKeyString2() {
        return publicKeyString;
    }

    public static boolean isNotificationDisplayed() {
        return notificationDisplayed;
    }

    public static void setNotificationDisplayed(boolean notificationDisplayed) {
        Patreon.notificationDisplayed = notificationDisplayed;
    }

    public static HashMap<String, Object> getMods() {
        return mods;
    }

    public static String getUpdateLocation() {
        return updateLocation;
    }

    public static boolean isShowCapes() {
        return showCapes;
    }

    public static void setShowCapes(boolean showCapes) {
        Patreon.showCapes = showCapes;
    }

    public static int getKEY_VERSION2() {
        return KEY_VERSION;
    }

    public static String getRendersCapes() {
        return rendersCapes;
    }

    public static void setRendersCapes(String rendersCapes) {
        Patreon.rendersCapes = rendersCapes;
    }

    @Deprecated
    public static int getKEY_VERSION() {
        return 3;
    }

    @Deprecated
    public static String getPublicKeyString() {
        return oldPublicKeyString;
    }

    static {
        loaded = false;
        showCapes = true;
        patronPledge = -1;
        mods = new HashMap();
        outdatedMods = new ArrayList();
        cipher = null;
        KEY_VERSION = 4;
        publicKeyString = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoBeELcruvAEIeLF/UsWF/v5rxyRXIpCs+eORLCbDw5cz9jHsnoypQKx0RTk5rcXIeA0HbEfY0eREB25quHjhZKul7MnzotQT+F2Qb1bPfHa6+SPie+pj79GGGAFP3npki6RqoU/wyYkd1tOomuD8v5ytEkOPC4U42kxxvx23A7vH6w46dew/E/HvfbBvZF2KrqdJtwKAunk847C3FgyhVq8/vzQc6mqAW6Mmn4zlwFvyCnTOWjIRw/I93WIM/uvhE3lt6pmtrWA2yIbKIj1z4pgG/K72EqHfYLGkBFTh7fV1wwCbpNTXZX2JnTfmvMGqzHjq7FijwVfCpFB/dWR3wQIDAQAB";
        try {
            cipher = Cipher.getInstance("RSA");
            KeyFactory factory = KeyFactory.getInstance("RSA");
            byte[] byteKey = Base64.getDecoder().decode(Patreon.getPublicKeyString2().getBytes());
            X509EncodedKeySpec X509publicKey = new X509EncodedKeySpec(byteKey);
            PublicKey publicKey = factory.generatePublic(X509publicKey);
            cipher.init(2, publicKey);
        }
        catch (Exception e) {
            cipher = null;
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        optionsFile = new File("./config/xaeropatreon.txt");
        rendersCapes = null;
        cape1 = new ResourceLocation("xaeropatreon", "capes/cape1.png");
        cape2 = new ResourceLocation("xaeropatreon", "capes/cape2.png");
        cape3 = new ResourceLocation("xaeropatreon", "capes/cape3.png");
        cape4 = new ResourceLocation("xaeropatreon", "capes/cape4.png");
        pauseCapes = false;
        oldPublicKeyString = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAgtweVog3N8aN7gUJrnVz1yoWLjmzWxltoVt+WDHbD/mOa8+P/m6+JK0ferlJ4a9hm97muj5JCQugFy3ATc/ZojNXiLzsmZgjgZbVvBvRbgyCr5/XQOaf0aRYgYuADcs4H6garVmLwaHaie+uLRdu0oytn1uBdOogbV+YGzJjnZq2ddtelz9vhD8tLflKaEbJVmopnNVI/2OKQAnwuHQYxDwArzLvMmyiOoLvnvrBC85+BuYOaHV9lDma2mz+h2VLCm5DywxmU1GyuMbqjFhgybR5hp5V+D6qBtDTsTv2YlG6bdmR+eszXyLO4qPdwfklMc0ae9sMG+Ygo3mGr94+XwIDAQAB";
    }
}

