/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.misc;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.chunk.Chunk;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.gui.IScreenBase;

public class Misc {
    public static double getMouseX(Minecraft mc) {
        return mc.field_71417_B.func_198024_e() * (double)mc.func_228018_at_().func_198109_k() / (double)mc.func_228018_at_().func_198105_m();
    }

    public static double getMouseY(Minecraft mc) {
        return mc.field_71417_B.func_198026_f() * (double)mc.func_228018_at_().func_198091_l() / (double)mc.func_228018_at_().func_198083_n();
    }

    public static void drawNormalText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_228079_a_(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, false, 0, 0xF000F0);
    }

    public static void drawPiercingText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_228079_a_(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawPiercingText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Minecraft.func_71410_x().field_71466_p.func_243247_a(name, x, y, color, shadow, matrices.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)renderTypeBuffer, true, 0, 0xF000F0);
    }

    public static void drawCenteredPiercingText(MatrixStack matrices, String name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.func_71410_x().field_71466_p.func_78256_a(name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void drawCenteredPiercingText(MatrixStack matrices, ITextComponent name, float x, float y, int color, boolean shadow, IRenderTypeBuffer.Impl renderTypeBuffer) {
        Misc.drawPiercingText(matrices, name, x - (float)(Minecraft.func_71410_x().field_71466_p.func_238414_a_((ITextProperties)name) / 2), y, color, shadow, renderTypeBuffer);
    }

    public static void minecraftOrtho(Minecraft mc) {
        MainWindow mainwindow = mc.func_228018_at_();
        RenderSystem.loadIdentity();
        RenderSystem.ortho((double)0.0, (double)((double)mainwindow.func_198109_k() / mainwindow.func_198100_s()), (double)((double)mainwindow.func_198091_l() / mainwindow.func_198100_s()), (double)0.0, (double)1000.0, (double)3000.0);
    }

    public static Path quickFileBackupMove(Path file) throws IOException {
        Path backupPath = null;
        int backupNumber = 0;
        while (Files.exists(backupPath = file.resolveSibling(file.getFileName().toString() + ".backup" + backupNumber), new LinkOption[0])) {
            ++backupNumber;
        }
        Files.move(file, backupPath, new CopyOption[0]);
        return backupPath;
    }

    public static void safeMoveAndReplace(Path from, Path to, boolean backupFrom) throws IOException {
        Path fromBackupPath;
        Path backupPath;
        block8: {
            backupPath = null;
            fromBackupPath = null;
            if (backupFrom) {
                while (true) {
                    try {
                        fromBackupPath = Misc.quickFileBackupMove(from);
                        break block8;
                    }
                    catch (IOException ioe2) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    break;
                }
            }
            fromBackupPath = from;
        }
        if (Files.exists(to, new LinkOption[0])) {
            backupPath = Misc.quickFileBackupMove(to);
        }
        Files.move(fromBackupPath, to, new CopyOption[0]);
        if (backupPath != null) {
            Files.delete(backupPath);
        }
    }

    public static void deleteFile(Path file, int attempts) throws IOException {
        --attempts;
        try {
            Files.walkFileTree(file, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
                    if (iOException != null) {
                        throw iOException;
                    }
                    Files.delete(path);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            if (attempts > 0) {
                MinimapLogs.LOGGER.info("Failed to delete file/folder! Retrying... " + attempts);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Misc.deleteFile(file, attempts);
            }
            throw e;
        }
    }

    public static boolean inputMatchesKeyBinding(InputMappings.Type type, int code, KeyBinding kb) {
        return code != -1 && kb.getKey().func_197938_b() == type && kb.getKey().func_197937_c() == code;
    }

    public static boolean screenShouldSkipWorldRender(IXaeroMinimap modMain, Screen screen, boolean checkOtherMod) {
        return screen instanceof IScreenBase && ((IScreenBase)screen).shouldSkipWorldRender() || checkOtherMod && modMain.getSupportMods().worldmap() && modMain.getSupportMods().worldmapSupport.screenShouldSkipWorldRender(screen);
    }

    public static long getChunkPosAsLong(Chunk chunk) {
        return chunk.func_76632_l().func_201841_a();
    }

    public static Field getFieldReflection(Class<?> c, String name1, String name2, String name3, String name4) {
        Field field = null;
        try {
            field = c.getDeclaredField(name1);
        }
        catch (NoSuchFieldException e) {
            field = Misc.getFieldReflection(c, name2, name3, name4);
        }
        return field;
    }

    public static Field getFieldReflection(Class<?> c, String name1, String name2, String name3) {
        Field field = null;
        try {
            field = c.getDeclaredField(name1);
        }
        catch (NoSuchFieldException e) {
            field = Misc.getFieldReflection(c, name2, name3);
        }
        return field;
    }

    public static Field getFieldReflection(Class<?> c, String name1, String name2) {
        Field field = null;
        try {
            field = c.getDeclaredField(name1);
        }
        catch (NoSuchFieldException e) {
            try {
                field = c.getDeclaredField(name2);
            }
            catch (NoSuchFieldException e1) {
                throw new RuntimeException(e1);
            }
        }
        return field;
    }

    public static <A, B> B getReflectFieldValue(A parentObject, Field field) {
        boolean accessibleBU = field.isAccessible();
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(parentObject);
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        field.setAccessible(accessibleBU);
        return (B)result;
    }

    public static Method getMethodReflection(Class<?> c, String obfuscatedName, String shortObfuscatedName, String name, Class<?> ... parameters) {
        Method method = null;
        try {
            method = c.getDeclaredMethod(obfuscatedName, parameters);
        }
        catch (NoSuchMethodException e) {
            method = Misc.getMethodReflection(c, shortObfuscatedName, name, parameters);
        }
        return method;
    }

    public static Method getMethodReflection(Class<?> c, String obfuscatedName, String name, Class<?> ... parameters) {
        Method method = null;
        try {
            method = c.getDeclaredMethod(obfuscatedName, parameters);
        }
        catch (NoSuchMethodException e) {
            try {
                method = c.getDeclaredMethod(name, parameters);
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException(e1);
            }
        }
        return method;
    }

    public static <A, B> B getReflectMethodValue(A parentObject, Method method, Object ... arguments) {
        boolean accessibleBU = method.isAccessible();
        method.setAccessible(true);
        Object result = null;
        try {
            result = method.invoke(parentObject, arguments);
        }
        catch (Exception e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        method.setAccessible(accessibleBU);
        return (B)result;
    }

    public static void download(BufferedOutputStream output, InputStream input) throws IOException {
        int read;
        byte[] buffer = new byte[256];
        while ((read = input.read(buffer, 0, buffer.length)) >= 0) {
            output.write(buffer, 0, read);
        }
        output.flush();
        input.close();
        output.close();
    }

    public static boolean hasItem(PlayerEntity player, Item item) {
        return Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, 9, item);
    }

    public static boolean hasItem(NonNullList<ItemStack> inventory, int limit, Item item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((ItemStack)inventory.get(i)).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static void setFieldText(TextFieldWidget field, String text) {
        Misc.setFieldText(field, text, -1);
    }

    public static void setFieldText(TextFieldWidget field, String text, int color) {
        field.func_146193_g(color);
        if (field.func_146179_b().equals(text)) {
            return;
        }
        field.func_146180_a(text);
    }

    public static ITextComponent getFixedDisplayName(Entity e) {
        ITextComponent baseName = e.func_200200_C_();
        if (baseName == null) {
            return null;
        }
        return e.func_96124_cp() == null ? baseName.func_230532_e_() : e.func_96124_cp().func_230427_d_((ITextComponent)baseName.func_230532_e_());
    }
}

