/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.gui.IScreenBase;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.minimap.MinimapInterface;

public class MinimapInterfaceInstance
extends InterfaceInstance {
    private XaeroMinimapSession minimapSession;
    private IXaeroMinimap modMain;

    public MinimapInterfaceInstance(MinimapInterface inter, IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        super(inter);
        this.minimapSession = minimapSession;
        this.modMain = modMain;
    }

    @Override
    public void render(MatrixStack matrixStack, int width, int height, double scale, float partial, CustomVertexConsumers cvc) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g.func_70644_a(Effects.NO_MINIMAP) || mc.field_71439_g.func_70644_a(Effects.NO_MINIMAP_BENEFICIAL) || mc.field_71439_g.func_70644_a(Effects.NO_MINIMAP_HARMFUL)) {
            return;
        }
        if (this.modMain.getSettings().hideMinimapUnderScreen && mc.field_71462_r != null && !(mc.field_71462_r instanceof IScreenBase) && !(mc.field_71462_r instanceof ChatScreen) && !(mc.field_71462_r instanceof DeathScreen) || this.modMain.getSettings().hideMinimapUnderF3 && mc.field_71474_y.field_74330_P) {
            return;
        }
        this.minimapSession.getMinimapProcessor().onRender(matrixStack, this.inter.getX(), this.inter.getY(), width, height, scale, this.getInterfaceWidth(), this.getW(scale), partial, cvc);
        super.render(matrixStack, width, height, scale, partial, cvc);
    }

    @Override
    public int getW(double scale) {
        return (int)((double)((float)this.getInterfaceWidth() * this.modMain.getSettings().getMinimapScale()) / scale);
    }

    @Override
    public int getH(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getWC(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getHC(double scale) {
        return this.getH(scale);
    }

    @Override
    public int getW0(double scale) {
        return this.getW(scale);
    }

    @Override
    public int getH0(double scale) {
        return this.getH(scale);
    }

    public int getInterfaceWidth() {
        return this.minimapSession.getMinimapProcessor().getMinimapSize() / 2 + 18;
    }

    @Override
    public int getSize() {
        int w = this.getInterfaceWidth();
        return w * w;
    }
}

