/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.scanning;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import li.cil.scannable.api.API;
import li.cil.scannable.api.scanning.ScanFilterEntity;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.api.scanning.ScannerModuleEntity;
import li.cil.scannable.client.scanning.filter.ScanFilterEntityList;
import li.cil.scannable.client.scanning.filter.ScanFilterEntityType;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.item.ItemScannerModuleEntityConfigurable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum ScannerModuleEntityConfigurable implements ScannerModuleEntity
{
    INSTANCE;


    @Override
    public int getEnergyCost(PlayerEntity player, ItemStack module) {
        return Settings.energyCostModuleEntity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScanResultProvider getResultProvider() {
        return (ScanResultProvider)GameRegistry.findRegistry(ScanResultProvider.class).getValue(API.SCAN_RESULT_PROVIDER_ENTITIES);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<ScanFilterEntity> getFilter(ItemStack module) {
        List<EntityType<?>> entityType = ItemScannerModuleEntityConfigurable.getEntityTypes(module);
        return Optional.of(new ScanFilterEntityList(entityType.stream().map(ScanFilterEntityType::new).collect(Collectors.toList())));
    }
}

