/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.network.message;

import com.google.common.collect.BiMap;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.function.Supplier;
import li.cil.scannable.client.scanning.ScanResultProviderStructure;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.network.Network;
import li.cil.scannable.common.network.message.MessageStructureResponse;
import li.cil.scannable.util.Migration;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.GameData;

public final class MessageStructureRequest {
    private ResourceLocation dimension;
    private BlockPos center;
    private int radius;
    private boolean skipExistingChunks;

    public MessageStructureRequest(World world, BlockPos center, float radius, boolean skipExistingChunks) {
        this.dimension = Migration.RegistryKey.getResourceLocation(Migration.World.getDimension(world));
        this.center = center;
        this.radius = (int)Math.ceil(radius);
        this.skipExistingChunks = skipExistingChunks;
    }

    public MessageStructureRequest(ByteBuf buffer) {
        this.fromBytes(buffer);
    }

    public static boolean handle(MessageStructureRequest message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity sender = context.getSender();
            if (sender == null) {
                return;
            }
            MinecraftServer server = sender.func_184102_h();
            if (server == null) {
                return;
            }
            ServerWorld world = server.func_71218_a(Migration.RegistryKey.getKey(Registry.field_239699_ae_, message.dimension));
            if (world == null) {
                return;
            }
            BlockPos center = message.center;
            int radius = message.radius;
            boolean skipExistingChunks = message.skipExistingChunks;
            BiMap structureMap = GameData.getStructureMap();
            ArrayList<ScanResultProviderStructure.StructureLocation> structures = new ArrayList<ScanResultProviderStructure.StructureLocation>();
            float sqRadius = radius * radius;
            for (String name : Settings.structures) {
                BlockPos pos;
                Structure structure = (Structure)structureMap.get((Object)name);
                if (structure == null || (pos = Migration.World.findNearestStructure(world, structure, center, radius, skipExistingChunks)) == null || !(center.func_177951_i((Vector3i)pos) <= (double)sqRadius)) continue;
                TranslationTextComponent localizedName = new TranslationTextComponent("structure." + name);
                structures.add(new ScanResultProviderStructure.StructureLocation((ITextComponent)localizedName, pos));
            }
            if (structures.isEmpty()) {
                return;
            }
            Network.INSTANCE.reply((Object)new MessageStructureResponse(structures.toArray(new ScanResultProviderStructure.StructureLocation[0])), context);
        });
        return true;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        this.dimension = new ResourceLocation(packet.func_150789_c(1024));
        this.center = packet.func_179259_c();
        this.radius = packet.func_150792_a();
        this.skipExistingChunks = packet.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packet = new PacketBuffer(buf);
        packet.func_180714_a(this.dimension.toString());
        packet.func_179255_a(this.center);
        packet.func_150787_b(this.radius);
        packet.writeBoolean(this.skipExistingChunks);
    }
}

