/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.scannable.common.Scannable;
import li.cil.scannable.common.config.Constants;
import li.cil.scannable.common.container.BlockModuleContainerProvider;
import li.cil.scannable.common.item.AbstractItemScannerModuleBlock;
import li.cil.scannable.common.scanning.ScannerModuleBlockConfigurable;
import li.cil.scannable.common.scanning.filter.ScanFilterIgnoredBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemScannerModuleBlockConfigurable
extends AbstractItemScannerModuleBlock {
    private static final String TAG_BLOCK_DEPRECATED = "block";
    private static final String TAG_BLOCKS = "blocks";
    private static final String TAG_IS_LOCKED = "isLocked";

    public static boolean isLocked(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74767_n(TAG_IS_LOCKED);
    }

    public static List<Block> getBlocks(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b(TAG_BLOCK_DEPRECATED, 8) && !nbt.func_150297_b(TAG_BLOCKS, 9)) {
            return Collections.emptyList();
        }
        ItemScannerModuleBlockConfigurable.upgradeData(nbt);
        ListNBT list = nbt.func_150295_c(TAG_BLOCKS, 8);
        ArrayList<Block> result = new ArrayList<Block>();
        list.forEach(tag -> {
            try {
                ResourceLocation registryName = new ResourceLocation(tag.func_150285_a_());
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(registryName);
                if (block != null && block != Blocks.field_150350_a) {
                    result.add(block);
                }
            }
            catch (ResourceLocationException e) {
                Scannable.getLog().error((Object)e);
            }
        });
        return result;
    }

    public static boolean addBlock(ItemStack stack, Block block) {
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            return false;
        }
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n(TAG_IS_LOCKED)) {
            return false;
        }
        StringNBT itemNbt = StringNBT.func_229705_a_((String)registryName.toString());
        ListNBT list = nbt.func_150295_c(TAG_BLOCKS, 8);
        if (list.contains((Object)itemNbt)) {
            return true;
        }
        if (list.size() >= 5) {
            return false;
        }
        nbt.func_218657_a(TAG_BLOCKS, (INBT)list);
        list.add((Object)itemNbt);
        return true;
    }

    public static boolean setBlockAt(ItemStack stack, int index, Block block) {
        if (index < 0 || index >= 5) {
            return false;
        }
        ResourceLocation registryName = block.getRegistryName();
        if (registryName == null) {
            return false;
        }
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n(TAG_IS_LOCKED)) {
            return false;
        }
        StringNBT itemNbt = StringNBT.func_229705_a_((String)registryName.toString());
        ListNBT list = nbt.func_150295_c(TAG_BLOCKS, 8);
        int oldIndex = list.indexOf((Object)itemNbt);
        if (oldIndex == index) {
            return true;
        }
        if (index >= list.size()) {
            list.add((Object)itemNbt);
        } else {
            list.set(index, (INBT)itemNbt);
        }
        if (oldIndex >= 0) {
            list.remove(oldIndex);
        }
        return true;
    }

    public static void removeBlockAt(ItemStack stack, int index) {
        if (index < 0 || index >= 5) {
            return;
        }
        CompoundNBT nbt = stack.func_196082_o();
        if (nbt.func_74767_n(TAG_IS_LOCKED)) {
            return;
        }
        ListNBT list = nbt.func_150295_c(TAG_BLOCKS, 8);
        if (index < list.size()) {
            list.remove(index);
        }
    }

    private static void upgradeData(CompoundNBT nbt) {
        if (nbt.func_150297_b(TAG_BLOCK_DEPRECATED, 8)) {
            ListNBT list = new ListNBT();
            list.add((Object)nbt.func_74781_a(TAG_BLOCK_DEPRECATED));
            nbt.func_218657_a(TAG_BLOCKS, (INBT)list);
            nbt.func_82580_o(TAG_BLOCK_DEPRECATED);
        }
    }

    public ItemScannerModuleBlockConfigurable() {
        super(ScannerModuleBlockConfigurable.INSTANCE);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        List<Block> blocks = ItemScannerModuleBlockConfigurable.getBlocks(stack);
        if (blocks.size() == 0) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.module_block"));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.module_block.list"));
            blocks.forEach(b -> tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.list_item", new Object[]{b.func_235333_g_()})));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                BlockModuleContainerProvider containerProvider = new BlockModuleContainerProvider(player, hand);
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerProvider, buffer -> buffer.func_179249_a((Enum)hand));
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        if (world.func_175623_d(context.func_195995_a())) {
            return ActionResultType.PASS;
        }
        PlayerEntity player = context.func_195999_j();
        if (player == null) {
            return ActionResultType.PASS;
        }
        ItemStack stack = context.func_195996_i();
        BlockState state = world.func_180495_p(context.func_195995_a());
        if (ScanFilterIgnoredBlocks.shouldIgnore(state)) {
            if (world.field_72995_K) {
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TranslationTextComponent("message.scannable.block_blacklisted"), Constants.CHAT_LINE_ID);
            }
            player.func_184811_cZ().func_185145_a((Item)this, 10);
            return ActionResultType.SUCCESS;
        }
        if (ItemScannerModuleBlockConfigurable.addBlock(stack, state.func_177230_c())) {
            return ActionResultType.SUCCESS;
        }
        if (world.field_72995_K && !ItemScannerModuleBlockConfigurable.isLocked(stack)) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TranslationTextComponent("message.scannable.no_free_slots"), Constants.CHAT_LINE_ID);
        }
        return ActionResultType.SUCCESS;
    }
}

