/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.client.audio.SoundManager;
import li.cil.scannable.common.capabilities.CapabilityProviderScanner;
import li.cil.scannable.common.capabilities.CapabilityScannerModule;
import li.cil.scannable.common.config.Constants;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.container.ScannerContainerProvider;
import li.cil.scannable.common.inventory.ItemHandlerScanner;
import li.cil.scannable.common.item.AbstractItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="scannable")
public final class ItemScanner
extends AbstractItem {
    @ObjectHolder(value="scanner")
    public static final Item INSTANCE = null;

    public static boolean isScanner(ItemStack stack) {
        return stack.func_77973_b() == INSTANCE;
    }

    public ItemScanner() {
        super(new Item.Properties().func_200917_a(1));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CapabilityProviderScanner(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (!this.func_194125_a(group)) {
            return;
        }
        if (group == ItemGroup.field_78027_g) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)this);
        LazyOptional energyStorage = stack.getCapability(CapabilityEnergy.ENERGY);
        if (!energyStorage.isPresent()) {
            return;
        }
        energyStorage.ifPresent(storage -> storage.receiveEnergy(storage.getMaxEnergyStored(), false));
        items.add((Object)stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.scanner"));
        if (world == null) {
            return;
        }
        if (!Settings.useEnergy) {
            return;
        }
        LazyOptional energyStorage = stack.getCapability(CapabilityEnergy.ENERGY);
        if (!energyStorage.isPresent()) {
            return;
        }
        energyStorage.ifPresent(storage -> tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.scannable.scanner.energy", new Object[]{storage.getEnergyStored(), storage.getMaxEnergyStored()})));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return Settings.useEnergy;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (!Settings.useEnergy) {
            return 0.0;
        }
        LazyOptional energyStorage = stack.getCapability(CapabilityEnergy.ENERGY);
        if (energyStorage.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)energyStorage.orElseThrow(AssertionError::new);
            return 1.0f - (float)storage.getEnergyStored() / (float)storage.getMaxEnergyStored();
        }
        return 1.0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                ScannerContainerProvider containerProvider = new ScannerContainerProvider(player, hand);
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerProvider, buffer -> buffer.func_179249_a((Enum)hand));
            }
        } else {
            ArrayList<ItemStack> modules = new ArrayList<ItemStack>();
            if (!ItemScanner.collectModules(stack, modules)) {
                if (world.field_72995_K) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TranslationTextComponent("message.scannable.no_scan_modules"), Constants.CHAT_LINE_ID);
                }
                player.func_184811_cZ().func_185145_a((Item)this, 10);
                return ActionResult.func_226251_d_((Object)stack);
            }
            if (!ItemScanner.tryConsumeEnergy(player, stack, modules, true)) {
                if (world.field_72995_K) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146234_a((ITextComponent)new TranslationTextComponent("message.scannable.not_enough_energy"), Constants.CHAT_LINE_ID);
                }
                player.func_184811_cZ().func_185145_a((Item)this, 10);
                return ActionResult.func_226251_d_((Object)stack);
            }
            player.func_184598_c(hand);
            if (world.field_72995_K) {
                ScanManager.INSTANCE.beginScan(player, modules);
                SoundManager.INSTANCE.playChargingSound();
            }
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public void onUsingTick(ItemStack stack, LivingEntity entity, int count) {
        if (entity.func_130014_f_().field_72995_K) {
            ScanManager.INSTANCE.updateScan((Entity)entity, false);
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int timeLeft) {
        if (world.field_72995_K) {
            ScanManager.INSTANCE.cancelScan();
            SoundManager.INSTANCE.stopChargingSound();
        }
        super.func_77615_a(stack, world, entity, timeLeft);
    }

    public ItemStack func_77654_b(ItemStack stack, World world, LivingEntity entity) {
        ArrayList<ItemStack> modules;
        if (!(entity instanceof PlayerEntity)) {
            return stack;
        }
        if (world.field_72995_K) {
            SoundCanceler.cancelEquipSound();
        }
        if (!ItemScanner.collectModules(stack, modules = new ArrayList<ItemStack>())) {
            return stack;
        }
        boolean hasEnergy = ItemScanner.tryConsumeEnergy((PlayerEntity)entity, stack, modules, false);
        if (world.field_72995_K) {
            SoundManager.INSTANCE.stopChargingSound();
            if (hasEnergy) {
                ScanManager.INSTANCE.updateScan((Entity)entity, true);
                SoundManager.INSTANCE.playActivateSound();
            } else {
                ScanManager.INSTANCE.cancelScan();
            }
        }
        PlayerEntity player = (PlayerEntity)entity;
        player.func_184811_cZ().func_185145_a((Item)this, 40);
        return stack;
    }

    static int getModuleEnergyCost(PlayerEntity player, ItemStack stack) {
        LazyOptional module = stack.getCapability(CapabilityScannerModule.SCANNER_MODULE_CAPABILITY);
        return module.map(p -> p.getEnergyCost(player, stack)).orElse(0);
    }

    private static boolean tryConsumeEnergy(PlayerEntity player, ItemStack scanner, List<ItemStack> modules, boolean simulate) {
        if (!Settings.useEnergy) {
            return true;
        }
        if (player.func_184812_l_()) {
            return true;
        }
        LazyOptional energyStorage = scanner.getCapability(CapabilityEnergy.ENERGY);
        if (!energyStorage.isPresent()) {
            return false;
        }
        int totalCostAccumulator = 0;
        for (ItemStack module : modules) {
            totalCostAccumulator += ItemScanner.getModuleEnergyCost(player, module);
        }
        int totalCost = totalCostAccumulator;
        int extracted = energyStorage.map(storage -> storage.extractEnergy(totalCost, simulate)).orElse(0);
        return extracted >= totalCost;
    }

    private static boolean collectModules(ItemStack scanner, List<ItemStack> modules) {
        LazyOptional itemHandler = scanner.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        return itemHandler.filter(handler -> handler instanceof ItemHandlerScanner).map(handler -> {
            IItemHandler activeModules = ((ItemHandlerScanner)((Object)handler)).getActiveModules();
            boolean hasScannerModules = false;
            for (int slot = 0; slot < activeModules.getSlots(); ++slot) {
                ItemStack module = activeModules.getStackInSlot(slot);
                if (module.func_190926_b()) continue;
                modules.add(module);
                LazyOptional capability = module.getCapability(CapabilityScannerModule.SCANNER_MODULE_CAPABILITY);
                hasScannerModules |= capability.map(ScannerModule::hasResultProvider).orElse(false).booleanValue();
            }
            return hasScannerModules;
        }).orElse(false);
    }

    private static enum SoundCanceler {
        INSTANCE;


        public static void cancelEquipSound() {
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }

        @SubscribeEvent
        public void onPlaySoundAtEntityEvent(PlaySoundAtEntityEvent event) {
            if (event.getSound() == SoundEvents.field_187719_p) {
                event.setCanceled(true);
            }
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

