/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.inventory;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import li.cil.scannable.common.capabilities.CapabilityScannerModule;
import li.cil.scannable.common.item.AbstractItemScannerModule;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;

public final class ItemHandlerScanner
extends ItemStackHandler {
    private static final String TAG_ITEMS = "items";
    private final ItemStack container;

    public ItemHandlerScanner(ItemStack container) {
        super(9);
        this.container = container;
    }

    public void updateFromNBT() {
        CompoundNBT nbt = this.container.func_77978_p();
        if (nbt != null && nbt.func_150297_b(TAG_ITEMS, 10)) {
            this.deserializeNBT(nbt.func_74775_l(TAG_ITEMS));
            if (this.stacks.size() != 9) {
                ArrayList oldStacks = new ArrayList(this.stacks);
                this.setSize(9);
                int count = Math.min(9, oldStacks.size());
                for (int slot = 0; slot < count; ++slot) {
                    this.stacks.set(slot, oldStacks.get(slot));
                }
            }
        }
    }

    public IItemHandler getActiveModules() {
        return new RangedWrapper((IItemHandlerModifiable)this, 0, 3);
    }

    public IItemHandler getInactiveModules() {
        return new RangedWrapper((IItemHandlerModifiable)this, 3, 9);
    }

    protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        if (stack.func_77973_b() instanceof AbstractItemScannerModule) {
            return 64;
        }
        LazyOptional module = stack.getCapability(CapabilityScannerModule.SCANNER_MODULE_CAPABILITY);
        if (module.isPresent()) {
            return 64;
        }
        return 0;
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.container.func_77983_a(TAG_ITEMS, (INBT)this.serializeNBT());
    }
}

