/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import li.cil.scannable.api.scanning.ScanFilterBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public final class ScanFilterBlockCache
implements ScanFilterBlock {
    private final Collection<Block> blocks;

    public ScanFilterBlockCache(Collection<ScanFilterBlock> filters) {
        this.blocks = ScanFilterBlockCache.buildCache(filters);
    }

    public ScanFilterBlockCache(List<Block> blocks) {
        this.blocks = new HashSet<Block>(blocks);
    }

    @Override
    public boolean matches(BlockState state) {
        return this.blocks.contains(state.func_177230_c());
    }

    private static Collection<Block> buildCache(Collection<ScanFilterBlock> filters) {
        HashSet<Block> cache = new HashSet<Block>();
        for (Block block : ForgeRegistries.BLOCKS.getValues()) {
            BlockState blockState = block.func_176223_P();
            if (!filters.stream().anyMatch(f -> f.matches(blockState))) continue;
            cache.add(blockState.func_177230_c());
        }
        return cache;
    }
}

