/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.scanning;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import li.cil.scannable.api.API;
import li.cil.scannable.api.prefab.AbstractScanResultProvider;
import li.cil.scannable.api.scanning.ScanFilterBlock;
import li.cil.scannable.api.scanning.ScanResult;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.api.scanning.ScannerModuleBlock;
import li.cil.scannable.client.shader.ScanResultShader;
import li.cil.scannable.common.Scannable;
import li.cil.scannable.common.capabilities.CapabilityScannerModule;
import li.cil.scannable.common.config.Settings;
import li.cil.scannable.common.scanning.filter.ScanFilterIgnoredBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public final class ScanResultProviderBlock
extends AbstractScanResultProvider {
    public static final ScanResultProviderBlock INSTANCE = new ScanResultProviderBlock();
    private static final int MAX_RESULTS_PER_BLOCK = 8192;
    private static final int DEFAULT_COLOR = 0x4466CC;
    private final List<ScanFilterLayer> scanFilterLayers = new ArrayList<ScanFilterLayer>();
    private final List<ChunkSectionPos> pendingChunkSections = new ArrayList<ChunkSectionPos>();
    private int currentChunkSection;
    private int chunkSectionsPerTick;
    private final Map<Block, Map<BlockPos, BlockScanResult>> resultClusters = new HashMap<Block, Map<BlockPos, BlockScanResult>>();
    private final List<BlockScanResult> results = new ArrayList<BlockScanResult>();

    @Override
    public void initialize(PlayerEntity player, Collection<ItemStack> modules, Vector3d center, float radius, int scanTicks) {
        super.initialize(player, modules, center, radius, scanTicks);
        this.scanFilterLayers.clear();
        IntObjectHashMap filterByRadius = new IntObjectHashMap();
        for (ItemStack module : modules) {
            LazyOptional capability = module.getCapability(CapabilityScannerModule.SCANNER_MODULE_CAPABILITY);
            capability.filter(c -> c instanceof ScannerModuleBlock).ifPresent(arg_0 -> this.lambda$initialize$3(module, (IntObjectMap)filterByRadius, arg_0));
        }
        IntArrayList scanFilterKeys = new IntArrayList();
        scanFilterKeys.addAll((Collection)filterByRadius.keySet());
        scanFilterKeys.sort((a, b) -> -Integer.compare(a, b));
        if (scanFilterKeys.size() > 0) {
            ItemStack module;
            this.radius = scanFilterKeys.getInt(0);
            module = scanFilterKeys.iterator();
            while (module.hasNext()) {
                int r = (Integer)module.next();
                this.scanFilterLayers.add(new ScanFilterLayer(r, (List)filterByRadius.get(r)));
            }
            BlockPos minBlockPos = new BlockPos(center).func_177963_a((double)(-this.radius), (double)(-this.radius), (double)(-this.radius));
            BlockPos maxBlockPos = new BlockPos(center).func_177963_a((double)this.radius, (double)this.radius, (double)this.radius);
            ChunkPos minChunkPos = new ChunkPos(minBlockPos);
            ChunkPos maxChunkPos = new ChunkPos(maxBlockPos);
            int minChunkSectionIndex = Math.max(minBlockPos.func_177956_o() >> 4, 0);
            int maxChunkSectionIndex = Math.min(maxBlockPos.func_177956_o() >> 4, 15);
            for (int chunkSectionIndex = minChunkSectionIndex; chunkSectionIndex <= maxChunkSectionIndex; ++chunkSectionIndex) {
                for (int chunkZ = minChunkPos.field_77275_b; chunkZ <= maxChunkPos.field_77275_b; ++chunkZ) {
                    for (int chunkX = minChunkPos.field_77276_a; chunkX <= maxChunkPos.field_77276_a; ++chunkX) {
                        double dx = Math.min(Math.abs((double)(chunkX << 4) - center.field_72450_a), Math.abs((double)((chunkX << 4) + 15) - center.field_72450_a));
                        double dz = Math.min(Math.abs((double)(chunkZ << 4) - center.field_72449_c), Math.abs((double)((chunkZ << 4) + 15) - center.field_72449_c));
                        double dy = Math.min(Math.abs((double)(chunkSectionIndex << 4) - center.field_72448_b), Math.abs((double)((chunkSectionIndex << 4) + 15) - center.field_72448_b));
                        double squareDistToCenter = dx * dx + dy * dy + dz * dz;
                        if (squareDistToCenter > (double)(radius * radius)) continue;
                        this.pendingChunkSections.add(new ChunkSectionPos(chunkX, chunkZ, chunkSectionIndex, squareDistToCenter));
                    }
                }
            }
            this.pendingChunkSections.sort(Comparator.comparingDouble(p -> p.squareDistToCenter));
            this.chunkSectionsPerTick = MathHelper.func_76123_f((float)((float)this.pendingChunkSections.size() / (float)scanTicks));
            this.currentChunkSection = 0;
        }
    }

    @Override
    public void computeScanResults() {
        World world = this.player.func_130014_f_();
        for (int i = 0; i < this.chunkSectionsPerTick; ++i) {
            if (this.currentChunkSection >= this.pendingChunkSections.size()) {
                return;
            }
            ChunkSectionPos chunkSectionPos = this.pendingChunkSections.get(this.currentChunkSection);
            ++this.currentChunkSection;
            int chunkX = chunkSectionPos.chunkX;
            int chunkZ = chunkSectionPos.chunkZ;
            int chunkSectionIndex = chunkSectionPos.chunkSectionIndex;
            IChunk chunk = world.func_217353_a(chunkX, chunkZ, ChunkStatus.field_222617_m, false);
            if (chunk == null) continue;
            ChunkSection[] sections = chunk.func_76587_i();
            assert (sections.length == 16);
            ChunkSection section = sections[chunkSectionIndex];
            if (section == null || section.func_76663_a()) continue;
            PalettedContainer palette = section.func_186049_g();
            BlockPos origin = chunk.func_76632_l().func_206849_h().func_177982_a(0, section.func_222632_g(), 0);
            int originX = origin.func_177958_n();
            int originY = origin.func_177956_o();
            int originZ = origin.func_177952_p();
            block1: for (int index = 0; index < 4096; ++index) {
                BlockState state = (BlockState)palette.func_186015_a(index);
                Block block = state.func_177230_c();
                Map clusters = this.resultClusters.computeIfAbsent(block, b -> new HashMap());
                if (clusters.size() > 8192 || ScanFilterIgnoredBlocks.shouldIgnore(state)) continue;
                int x = index & 0xF;
                int z = index >> 4 & 0xF;
                int y = index >> 8 & 0xF;
                int globalX = originX + x;
                int globalY = originY + y;
                int globalZ = originZ + z;
                double squaredDistance = this.center.func_186679_c((double)globalX + 0.5, (double)globalY + 0.5, (double)globalZ + 0.5);
                for (ScanFilterLayer layer : this.scanFilterLayers) {
                    if (squaredDistance > (double)(layer.radius * layer.radius)) continue block1;
                    for (ScanFilterBlock filter : layer.filters) {
                        if (!filter.matches(state)) continue;
                        BlockPos pos = new BlockPos(globalX, globalY, globalZ);
                        if (this.tryAddToCluster(clusters, pos)) continue block1;
                        BlockScanResult result = new BlockScanResult(state.func_177230_c(), pos);
                        clusters.put(pos, result);
                        this.results.add(result);
                        continue block1;
                    }
                }
            }
        }
    }

    @Override
    public void collectScanResults(IBlockReader world, Consumer<ScanResult> callback) {
        for (BlockScanResult result : this.results) {
            if (!result.isRoot()) continue;
            result.bake(world);
            callback.accept(result);
        }
    }

    @Override
    public void render(IRenderTypeBuffer renderTypeBuffer, MatrixStack matrixStack, Matrix4f projectionMatrix, ActiveRenderInfo renderInfo, float partialTicks, List<ScanResult> results) {
        if (Minecraft.func_71410_x().field_71460_t.field_175074_C) {
            RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            matrixStack.func_227860_a_();
            try {
                Minecraft.func_71410_x().field_71460_t.func_228381_a_(matrixStack, renderInfo, partialTicks);
            }
            catch (Throwable e) {
                Scannable.getLog().catching(e);
            }
            matrixStack.func_227865_b_();
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
        ScanResultShader.setProjectionMatrix(projectionMatrix);
        ScanResultShader.setViewMatrix(matrixStack.func_227866_c_().func_227870_a_());
        RenderType renderType = ScanResultProviderBlock.getBlockScanResultRenderLayer();
        renderType.func_228547_a_();
        for (ScanResult result2 : results) {
            BlockScanResult blockResult = (BlockScanResult)result2;
            VertexBuffer vbo = blockResult.vbo;
            vbo.func_177359_a();
            DefaultVertexFormats.field_227851_o_.func_227892_a_(0L);
            vbo.func_227874_a_(matrixStack.func_227866_c_().func_227870_a_(), 7);
            VertexBuffer.func_177361_b();
            DefaultVertexFormats.field_227851_o_.func_227895_d_();
        }
        renderType.func_228549_b_();
        Vector3d lookVec = new Vector3d(renderInfo.func_227996_l_());
        Vector3d viewerEyes = renderInfo.func_216785_c();
        float yaw = renderInfo.func_216778_f();
        float pitch = renderInfo.func_216777_e();
        boolean showDistance = renderInfo.func_216773_g().func_225608_bj_();
        results.sort(Comparator.comparing(result -> {
            BlockScanResult blockResult = (BlockScanResult)result;
            Vector3d resultPos = blockResult.getPosition();
            Vector3d toResult = resultPos.func_178788_d(viewerEyes);
            return lookVec.func_72430_b(toResult.func_72432_b());
        }));
        for (ScanResult result3 : results) {
            BlockScanResult blockResult = (BlockScanResult)result3;
            Vector3d resultPos = result3.getPosition();
            Vector3d toResult = resultPos.func_178788_d(viewerEyes);
            float lookDirDot = (float)lookVec.func_72430_b(toResult.func_72432_b());
            Block block = blockResult.block;
            IFormattableTextComponent label = block.func_235333_g_();
            if (!(lookDirDot > 0.98f) || Strings.isNullOrEmpty((String)label.getString())) continue;
            float distance = showDistance ? (float)resultPos.func_178788_d(viewerEyes).func_72433_c() : 0.0f;
            ScanResultProviderBlock.renderIconLabel(renderTypeBuffer, matrixStack, yaw, pitch, lookVec, viewerEyes, distance, resultPos, API.ICON_INFO, (ITextComponent)label);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.scanFilterLayers.clear();
        this.chunkSectionsPerTick = 0;
        this.currentChunkSection = 0;
        this.pendingChunkSections.clear();
        this.resultClusters.clear();
        this.results.clear();
    }

    private static RenderType getBlockScanResultRenderLayer() {
        return RenderType.func_228632_a_((String)"scan_result", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)65536, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderState.field_228512_d_).func_228727_a_(RenderState.field_228496_F_).func_228714_a_(RenderState.field_228491_A_).func_228725_a_(new RenderState.TexturingState("shader", ScanResultShader.INSTANCE::bind, ScanResultShader.INSTANCE::unbind)).func_228728_a_(false));
    }

    private boolean tryAddToCluster(Map<BlockPos, BlockScanResult> clusters, BlockPos pos) {
        BlockScanResult root = null;
        root = this.tryAddToCluster(clusters, pos, pos.func_177974_f(), root);
        root = this.tryAddToCluster(clusters, pos, pos.func_177976_e(), root);
        root = this.tryAddToCluster(clusters, pos, pos.func_177978_c(), root);
        root = this.tryAddToCluster(clusters, pos, pos.func_177968_d(), root);
        root = this.tryAddToCluster(clusters, pos, pos.func_177984_a(), root);
        root = this.tryAddToCluster(clusters, pos, pos.func_177977_b(), root);
        return root != null;
    }

    @Nullable
    private BlockScanResult tryAddToCluster(Map<BlockPos, BlockScanResult> clusters, BlockPos pos, BlockPos clusterPos, @Nullable BlockScanResult root) {
        BlockScanResult cluster = clusters.get(clusterPos);
        if (cluster == null) {
            return root;
        }
        if (root == null) {
            root = cluster.getRoot();
            root.add(pos);
            clusters.put(pos, root);
        } else {
            cluster.getRoot().setRoot(root);
        }
        return root;
    }

    private ScanResultProviderBlock() {
    }

    private /* synthetic */ void lambda$initialize$3(ItemStack module, IntObjectMap filterByRadius, ScannerModule c) {
        ScannerModuleBlock m = (ScannerModuleBlock)c;
        Optional<ScanFilterBlock> filter = m.getFilter(module);
        filter.ifPresent(f -> {
            int localRadius = (int)Math.ceil(m.adjustLocalRange(this.radius));
            ((List)filterByRadius.computeIfAbsent((Object)localRadius, r -> new ArrayList())).add(f);
        });
    }

    private static final class BlockScanResult
    implements ScanResult {
        private final Block block;
        private AxisAlignedBB bounds;
        @Nullable
        private BlockScanResult parent;
        private final Set<BlockPos> blocks;
        private int color;
        private VertexBuffer vbo;

        BlockScanResult(Block block, BlockPos pos) {
            this.block = block;
            this.bounds = new AxisAlignedBB(pos);
            this.blocks = new HashSet<BlockPos>();
            this.blocks.add(pos);
        }

        void bake(IBlockReader world) {
            FluidState fluidState;
            BlockState blockState = this.block.func_176223_P();
            this.color = blockState.func_185909_g((IBlockReader)world, (BlockPos)new BlockPos((Vector3d)this.bounds.func_189972_c())).field_76291_p;
            if (this.color == 0) {
                this.color = 0x4466CC;
            }
            if (!(fluidState = blockState.func_204520_s()).func_206888_e()) {
                if (Settings.fluidColors.containsKey((Object)fluidState.func_206886_c().getRegistryName())) {
                    this.color = Settings.fluidColors.getInt((Object)fluidState.func_206886_c());
                } else {
                    Settings.fluidTagColors.forEach((k, v) -> {
                        ITag tag = FluidTags.func_226157_a_().func_199910_a(k);
                        if (tag != null && tag.func_230235_a_((Object)fluidState.func_206886_c())) {
                            this.color = v;
                        }
                    });
                }
            } else if (Settings.blockColors.containsKey((Object)blockState.func_177230_c().getRegistryName())) {
                this.color = Settings.blockColors.getInt((Object)blockState.func_177230_c());
            } else {
                Settings.blockTagColors.forEach((k, v) -> {
                    ITag tag = BlockTags.func_199896_a().func_199910_a(k);
                    if (tag != null && tag.func_230235_a_((Object)blockState.func_177230_c())) {
                        this.color = v;
                    }
                });
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            MatrixStack matrixStack = new MatrixStack();
            this.render((IVertexBuilder)buffer, matrixStack);
            buffer.func_178977_d();
            this.vbo = new VertexBuffer(DefaultVertexFormats.field_227851_o_);
            this.vbo.func_227875_a_(buffer);
        }

        boolean isRoot() {
            return this.parent == null;
        }

        BlockScanResult getRoot() {
            if (this.parent != null) {
                return this.parent.getRoot();
            }
            return this;
        }

        void setRoot(BlockScanResult root) {
            if (root == this) {
                return;
            }
            assert (this.parent == null);
            root.bounds = root.bounds.func_111270_a(this.bounds);
            root.blocks.addAll(this.blocks);
            this.blocks.clear();
            this.parent = root;
        }

        void add(BlockPos pos) {
            assert (this.parent == null) : "Trying to add to non-root node.";
            this.bounds = this.bounds.func_111270_a(new AxisAlignedBB(pos));
            this.blocks.add(pos);
        }

        void render(IVertexBuilder buffer, MatrixStack matrixStack) {
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            float colorNormalizer = 0.003921569f;
            float r = (float)(this.color >> 16 & 0xFF) * 0.003921569f;
            float g = (float)(this.color >> 8 & 0xFF) * 0.003921569f;
            float b = (float)(this.color & 0xFF) * 0.003921569f;
            float sizeUvX = (float)(1.0 / this.bounds.func_216364_b());
            float sizeUvY = (float)(1.0 / this.bounds.func_216360_c());
            float sizeUvZ = (float)(1.0 / this.bounds.func_216362_d());
            for (BlockPos cell : this.blocks) {
                float maxY;
                float minY;
                float z;
                float maxX;
                float minX;
                float y;
                float v1;
                float v0;
                float u1;
                float u0;
                float maxZ;
                float minZ;
                float maxY2;
                float minY2;
                float x;
                if (!this.blocks.contains(cell.func_177982_a(-1, 0, 0))) {
                    x = cell.func_177958_n();
                    minY2 = cell.func_177956_o();
                    maxY2 = cell.func_177956_o() + 1;
                    minZ = cell.func_177952_p();
                    maxZ = cell.func_177952_p() + 1;
                    u0 = (minY2 - (float)this.bounds.field_72338_b) * sizeUvY;
                    u1 = u0 + sizeUvY;
                    v0 = (minZ - (float)this.bounds.field_72339_c) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.func_227888_a_(matrix, x, minY2, minZ).func_227885_a_(r, g, b, 0.8f).func_225583_a_(u0, v0).func_181675_d();
                    buffer.func_227888_a_(matrix, x, minY2, maxZ).func_227885_a_(r, g, b, 0.8f).func_225583_a_(u0, v1).func_181675_d();
                    buffer.func_227888_a_(matrix, x, maxY2, maxZ).func_227885_a_(r, g, b, 0.8f).func_225583_a_(u1, v1).func_181675_d();
                    buffer.func_227888_a_(matrix, x, maxY2, minZ).func_227885_a_(r, g, b, 0.8f).func_225583_a_(u1, v0).func_181675_d();
                }
                if (!this.blocks.contains(cell.func_177982_a(1, 0, 0))) {
                    x = cell.func_177958_n() + 1;
                    minY2 = cell.func_177956_o();
                    maxY2 = cell.func_177956_o() + 1;
                    minZ = cell.func_177952_p();
                    maxZ = cell.func_177952_p() + 1;
                    u0 = (minY2 - (float)this.bounds.field_72338_b) * sizeUvY;
                    u1 = u0 + sizeUvY;
                    v0 = (minZ - (float)this.bounds.field_72339_c) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.func_227888_a_(matrix, x, minY2, minZ).func_227885_a_(r, g, b, 0.8f).func_225583_a_(u0, v0).func_181675_d();
                    buffer.func_227888_a_(matrix, x, maxY2, minZ).func_227885_a_(r, g, b, 0.8f).func_225583_a_(u1, v0).func_181675_d();
                    buffer.func_227888_a_(matrix, x, maxY2, maxZ).func_227885_a_(r, g, b, 0.8f).func_225583_a_(u1, v1).func_181675_d();
                    buffer.func_227888_a_(matrix, x, minY2, maxZ).func_227885_a_(r, g, b, 0.8f).func_225583_a_(u0, v1).func_181675_d();
                }
                if (!this.blocks.contains(cell.func_177982_a(0, -1, 0))) {
                    y = cell.func_177956_o();
                    minX = cell.func_177958_n();
                    maxX = cell.func_177958_n() + 1;
                    minZ = cell.func_177952_p();
                    maxZ = cell.func_177952_p() + 1;
                    u0 = (minX - (float)this.bounds.field_72340_a) * sizeUvX;
                    u1 = u0 + sizeUvX;
                    v0 = (minZ - (float)this.bounds.field_72339_c) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.func_227888_a_(matrix, minX, y, minZ).func_227885_a_(r, g, b, 0.7f).func_225583_a_(u0, v0).func_181675_d();
                    buffer.func_227888_a_(matrix, maxX, y, minZ).func_227885_a_(r, g, b, 0.7f).func_225583_a_(u1, v0).func_181675_d();
                    buffer.func_227888_a_(matrix, maxX, y, maxZ).func_227885_a_(r, g, b, 0.7f).func_225583_a_(u1, v1).func_181675_d();
                    buffer.func_227888_a_(matrix, minX, y, maxZ).func_227885_a_(r, g, b, 0.7f).func_225583_a_(u0, v1).func_181675_d();
                }
                if (!this.blocks.contains(cell.func_177982_a(0, 1, 0))) {
                    y = cell.func_177956_o() + 1;
                    minX = cell.func_177958_n();
                    maxX = cell.func_177958_n() + 1;
                    minZ = cell.func_177952_p();
                    maxZ = cell.func_177952_p() + 1;
                    u0 = (minX - (float)this.bounds.field_72340_a) * sizeUvX;
                    u1 = u0 + sizeUvX;
                    v0 = (minZ - (float)this.bounds.field_72339_c) * sizeUvZ;
                    v1 = v0 + sizeUvZ;
                    buffer.func_227888_a_(matrix, minX, y, minZ).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u0, v0).func_181675_d();
                    buffer.func_227888_a_(matrix, minX, y, maxZ).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u0, v1).func_181675_d();
                    buffer.func_227888_a_(matrix, maxX, y, maxZ).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u1, v1).func_181675_d();
                    buffer.func_227888_a_(matrix, maxX, y, minZ).func_227885_a_(r, g, b, 1.0f).func_225583_a_(u1, v0).func_181675_d();
                }
                if (!this.blocks.contains(cell.func_177982_a(0, 0, -1))) {
                    z = cell.func_177952_p();
                    minX = cell.func_177958_n();
                    maxX = cell.func_177958_n() + 1;
                    minY = cell.func_177956_o();
                    maxY = cell.func_177956_o() + 1;
                    u0 = (minX - (float)this.bounds.field_72340_a) * sizeUvX;
                    u1 = u0 + sizeUvX;
                    v0 = (minY - (float)this.bounds.field_72338_b) * sizeUvY;
                    v1 = v0 + sizeUvY;
                    buffer.func_227888_a_(matrix, minX, minY, z).func_227885_a_(r, g, b, 0.9f).func_225583_a_(u0, v0).func_181675_d();
                    buffer.func_227888_a_(matrix, minX, maxY, z).func_227885_a_(r, g, b, 0.9f).func_225583_a_(u0, v1).func_181675_d();
                    buffer.func_227888_a_(matrix, maxX, maxY, z).func_227885_a_(r, g, b, 0.9f).func_225583_a_(u1, v1).func_181675_d();
                    buffer.func_227888_a_(matrix, maxX, minY, z).func_227885_a_(r, g, b, 0.9f).func_225583_a_(u1, v0).func_181675_d();
                }
                if (this.blocks.contains(cell.func_177982_a(0, 0, 1))) continue;
                z = cell.func_177952_p() + 1;
                minX = cell.func_177958_n();
                maxX = cell.func_177958_n() + 1;
                minY = cell.func_177956_o();
                maxY = cell.func_177956_o() + 1;
                u0 = (minX - (float)this.bounds.field_72340_a) * sizeUvX;
                u1 = u0 + sizeUvX;
                v0 = (minY - (float)this.bounds.field_72338_b) * sizeUvY;
                v1 = v0 + sizeUvY;
                buffer.func_227888_a_(matrix, minX, minY, z).func_227885_a_(r, g, b, 0.9f).func_225583_a_(u0, v0).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, minY, z).func_227885_a_(r, g, b, 0.9f).func_225583_a_(u1, v0).func_181675_d();
                buffer.func_227888_a_(matrix, maxX, maxY, z).func_227885_a_(r, g, b, 0.9f).func_225583_a_(u1, v1).func_181675_d();
                buffer.func_227888_a_(matrix, minX, maxY, z).func_227885_a_(r, g, b, 0.9f).func_225583_a_(u0, v1).func_181675_d();
            }
        }

        @Override
        @Nullable
        public AxisAlignedBB getRenderBounds() {
            return this.bounds;
        }

        @Override
        public Vector3d getPosition() {
            return this.bounds.func_189972_c();
        }

        @Override
        public void close() {
            if (this.vbo != null) {
                this.vbo.close();
                this.vbo = null;
            }
        }
    }

    private static final class ChunkSectionPos {
        public final int chunkX;
        public final int chunkZ;
        public final int chunkSectionIndex;
        public double squareDistToCenter;

        private ChunkSectionPos(int chunkX, int chunkZ, int chunkSectionIndex, double squareDistToCenter) {
            this.chunkX = chunkX;
            this.chunkZ = chunkZ;
            this.chunkSectionIndex = chunkSectionIndex;
            this.squareDistToCenter = squareDistToCenter;
        }
    }

    private static final class ScanFilterLayer {
        public final int radius;
        public final List<ScanFilterBlock> filters;

        public ScanFilterLayer(int radius, List<ScanFilterBlock> filters) {
            this.radius = radius;
            this.filters = filters;
        }
    }
}

