/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import li.cil.scannable.common.item.ItemScanner;
import li.cil.scannable.util.Migration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public enum OverlayRenderer {
    INSTANCE;

    private static final ResourceLocation PROGRESS;

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack stack = player.func_184607_cu();
        if (stack.func_190926_b()) {
            return;
        }
        if (!ItemScanner.isScanner(stack)) {
            return;
        }
        int total = stack.func_77988_m();
        int remaining = player.func_184605_cv();
        float progress = MathHelper.func_76131_a((float)(1.0f - ((float)remaining - event.getPartialTicks()) / (float)total), (float)0.0f, (float)1.0f);
        int screenWidth = mc.func_228018_at_().func_198107_o();
        int screenHeight = mc.func_228018_at_().func_198087_p();
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)0.66f, (float)0.8f, (float)0.93f, (float)0.66f);
        mc.func_110434_K().func_110577_a(PROGRESS);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(4, DefaultVertexFormats.field_181707_g);
        int width = 64;
        int height = 64;
        int midX = screenWidth / 2;
        int midY = screenHeight / 2;
        int left = midX - 32;
        int right = midX + 32;
        int top = midY - 32;
        int bottom = midY + 32;
        float angle = (float)((double)progress * Math.PI * 2.0);
        float tx = MathHelper.func_76126_a((float)angle);
        float ty = MathHelper.func_76134_b((float)angle);
        buffer.func_225582_a_((double)midX, (double)top, 0.0).func_225583_a_(0.5f, 1.0f).func_181675_d();
        if ((double)progress < 0.125) {
            buffer.func_225582_a_((double)midX, (double)midY, 0.0).func_225583_a_(0.5f, 0.5f).func_181675_d();
            float x = tx / ty * 0.5f;
            buffer.func_225582_a_((double)((float)midX + x * 64.0f), (double)top, 0.0).func_225583_a_(0.5f + x, 1.0f).func_181675_d();
        } else {
            buffer.func_225582_a_((double)midX, (double)midY, 0.0).func_225583_a_(0.5f, 0.5f).func_181675_d();
            buffer.func_225582_a_((double)right, (double)top, 0.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buffer.func_225582_a_((double)right, (double)top, 0.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
            if ((double)progress < 0.375) {
                buffer.func_225582_a_((double)midX, (double)midY, 0.0).func_225583_a_(0.5f, 0.5f).func_181675_d();
                float y = Math.abs(ty / tx - 1.0f) * 0.5f;
                buffer.func_225582_a_((double)right, (double)((float)top + y * 64.0f), 0.0).func_225583_a_(1.0f, 1.0f - y).func_181675_d();
            } else {
                buffer.func_225582_a_((double)midX, (double)midY, 0.0).func_225583_a_(0.5f, 0.5f).func_181675_d();
                buffer.func_225582_a_((double)right, (double)bottom, 0.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
                buffer.func_225582_a_((double)right, (double)bottom, 0.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
                if ((double)progress < 0.625) {
                    buffer.func_225582_a_((double)midX, (double)midY, 0.0).func_225583_a_(0.5f, 0.5f).func_181675_d();
                    float x = Math.abs(tx / ty - 1.0f) * 0.5f;
                    buffer.func_225582_a_((double)((float)left + x * 64.0f), (double)bottom, 0.0).func_225583_a_(x, 0.0f).func_181675_d();
                } else {
                    buffer.func_225582_a_((double)midX, (double)midY, 0.0).func_225583_a_(0.5f, 0.5f).func_181675_d();
                    buffer.func_225582_a_((double)left, (double)bottom, 0.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
                    buffer.func_225582_a_((double)left, (double)bottom, 0.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
                    if ((double)progress < 0.875) {
                        buffer.func_225582_a_((double)midX, (double)midY, 0.0).func_225583_a_(0.5f, 0.5f).func_181675_d();
                        float y = (ty / tx + 1.0f) * 0.5f;
                        buffer.func_225582_a_((double)left, (double)((float)top + y * 64.0f), 0.0).func_225583_a_(0.0f, 1.0f - y).func_181675_d();
                    } else {
                        buffer.func_225582_a_((double)midX, (double)midY, 0.0).func_225583_a_(0.5f, 0.5f).func_181675_d();
                        buffer.func_225582_a_((double)left, (double)top, 0.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
                        buffer.func_225582_a_((double)left, (double)top, 0.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
                        if (progress < 1.0f) {
                            buffer.func_225582_a_((double)midX, (double)midY, 0.0).func_225583_a_(0.5f, 0.5f).func_181675_d();
                            float x = Math.abs(tx / ty) * 0.5f;
                            buffer.func_225582_a_((double)((float)midX - x * 64.0f), (double)top, 0.0).func_225583_a_(0.5f - x, 1.0f).func_181675_d();
                        } else {
                            buffer.func_225582_a_((double)midX, (double)midY, 0.0).func_225583_a_(0.5f, 0.5f).func_181675_d();
                            buffer.func_225582_a_((double)midX, (double)top, 0.0).func_225583_a_(0.5f, 1.0f).func_181675_d();
                        }
                    }
                }
            }
        }
        tessellator.func_78381_a();
        FontRenderer fontRenderer = mc.field_71466_p;
        MatrixStack matrixStack = event.getMatrixStack();
        TranslationTextComponent translationTextComponent = new TranslationTextComponent("gui.scannable.scanner.progress", new Object[]{MathHelper.func_76141_d((float)(progress * 100.0f))});
        float f = right + 12;
        mc.field_71466_p.getClass();
        Migration.FontRenderer.drawStringWithShadow(fontRenderer, matrixStack, (ITextComponent)translationTextComponent, f, midY - 9 / 2, -861221650);
        RenderSystem.bindTexture((int)0);
    }

    static {
        PROGRESS = new ResourceLocation("scannable", "textures/gui/overlay/scanner_progress.png");
    }
}

