/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.api.prefab;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collection;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScanResultProvider;
import li.cil.scannable.util.Migration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistryEntry;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractScanResultProvider
extends ForgeRegistryEntry<ScanResultProvider>
implements ScanResultProvider {
    protected PlayerEntity player;
    protected Vector3d center;
    protected float radius;

    @Override
    public void initialize(PlayerEntity player, Collection<ItemStack> modules, Vector3d center, float radius, int scanTicks) {
        this.player = player;
        this.center = center;
        this.radius = radius;
    }

    @Override
    public void reset() {
        this.player = null;
        this.center = null;
        this.radius = 0.0f;
    }

    protected static void renderIconLabel(IRenderTypeBuffer renderTypeBuffer, MatrixStack matrixStack, float yaw, float pitch, Vector3d lookVec, Vector3d viewerEyes, float displayDistance, Vector3d resultPos, ResourceLocation icon, @Nullable ITextComponent label) {
        Vector3d toResult = resultPos.func_178788_d(viewerEyes);
        float distance = (float)toResult.func_72433_c();
        float lookDirDot = (float)lookVec.func_72430_b(toResult.func_72432_b());
        float sqLookDirDot = lookDirDot * lookDirDot;
        float sq2LookDirDot = sqLookDirDot * sqLookDirDot;
        float focusScale = MathHelper.func_76131_a((float)(sq2LookDirDot * sq2LookDirDot + 0.005f), (float)0.5f, (float)1.0f);
        float scale = distance * focusScale * 0.005f;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(resultPos.field_72450_a, resultPos.field_72448_b, resultPos.field_72449_c);
        matrixStack.func_227863_a_(Vector3f.field_229180_c_.func_229187_a_(yaw));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(pitch));
        matrixStack.func_227862_a_(-scale, -scale, scale);
        if (lookDirDot > 0.999f && label != null && !Strings.isNullOrEmpty((String)label.getString())) {
            Object text = displayDistance > 0.0f ? new TranslationTextComponent("gui.scannable.overlay.entity_details", new Object[]{label, MathHelper.func_76123_f((float)displayDistance)}) : label;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int width = Migration.FontRenderer.getStringWidth(fontRenderer, (ITextProperties)text) + 16;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)((float)width / 2.0f), 0.0, 0.0);
            IVertexBuilder iVertexBuilder = renderTypeBuffer.getBuffer(AbstractScanResultProvider.getRenderLayer());
            float f = width;
            fontRenderer.getClass();
            AbstractScanResultProvider.drawQuad(iVertexBuilder, matrixStack, f, 9 + 5, 0.0f, 0.0f, 0.0f, 0.6f);
            matrixStack.func_227865_b_();
            Migration.FontRenderer.renderString(fontRenderer, text, 12.0f, -4.0f, -1, true, matrixStack.func_227866_c_().func_227870_a_(), renderTypeBuffer, true, 0, 0xF000F0);
        }
        AbstractScanResultProvider.drawQuad(renderTypeBuffer.getBuffer(AbstractScanResultProvider.getRenderLayer(icon)), matrixStack, 16.0f, 16.0f);
        matrixStack.func_227865_b_();
    }

    protected static void drawQuad(IVertexBuilder buffer, MatrixStack matrixStack, float width, float height) {
        AbstractScanResultProvider.drawQuad(buffer, matrixStack, width, height, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected static void drawQuad(IVertexBuilder buffer, MatrixStack matrixStack, float width, float height, float r, float g, float b, float a) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(matrix, -width / 2.0f, height / 2.0f, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, width / 2.0f, height / 2.0f, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, width / 2.0f, -height / 2.0f, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, -width / 2.0f, -height / 2.0f, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_181675_d();
    }

    protected static void drawCube(IVertexBuilder buffer, Matrix4f matrix, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, float r, float g, float b, float a) {
        AbstractScanResultProvider.drawPlaneNegX(buffer, matrix, minX, minY, maxY, minZ, maxZ, r, g, b, a * 0.9f);
        AbstractScanResultProvider.drawPlanePosX(buffer, matrix, maxX, minY, maxY, minZ, maxZ, r, g, b, a * 0.9f);
        AbstractScanResultProvider.drawPlaneNegY(buffer, matrix, minY, minX, maxX, minZ, maxZ, r, g, b, a * 0.8f);
        AbstractScanResultProvider.drawPlanePosY(buffer, matrix, maxY, minX, maxX, minZ, maxZ, r, g, b, a * 1.1f);
        AbstractScanResultProvider.drawPlaneNegZ(buffer, matrix, minZ, minX, maxX, minY, maxY, r, g, b, a);
        AbstractScanResultProvider.drawPlanePosZ(buffer, matrix, maxZ, minX, maxX, minY, maxY, r, g, b, a);
    }

    protected static void drawPlaneNegX(IVertexBuilder buffer, Matrix4f matrix, float x, float minY, float maxY, float minZ, float maxZ, float r, float g, float b, float a) {
        buffer.func_227888_a_(matrix, x, minY, minZ).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, minY, maxZ).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, maxY, maxZ).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, maxY, minZ).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_181675_d();
    }

    protected static void drawPlanePosX(IVertexBuilder buffer, Matrix4f matrix, float x, float minY, float maxY, float minZ, float maxZ, float r, float g, float b, float a) {
        buffer.func_227888_a_(matrix, x, minY, minZ).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, maxY, minZ).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, maxY, maxZ).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, x, minY, maxZ).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_181675_d();
    }

    protected static void drawPlaneNegY(IVertexBuilder buffer, Matrix4f matrix, float y, float minX, float maxX, float minZ, float maxZ, float r, float g, float b, float a) {
        buffer.func_227888_a_(matrix, minX, y, minZ).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, maxX, y, minZ).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, maxX, y, maxZ).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, minX, y, maxZ).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_181675_d();
    }

    protected static void drawPlanePosY(IVertexBuilder buffer, Matrix4f matrix, float y, float minX, float maxX, float minZ, float maxZ, float r, float g, float b, float a) {
        buffer.func_227888_a_(matrix, minX, y, minZ).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, minX, y, maxZ).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, maxX, y, maxZ).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, maxX, y, minZ).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_181675_d();
    }

    protected static void drawPlaneNegZ(IVertexBuilder buffer, Matrix4f matrix, float z, float minX, float maxX, float minY, float maxY, float r, float g, float b, float a) {
        buffer.func_227888_a_(matrix, minX, minY, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, minX, maxY, z).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, maxX, maxY, z).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, maxX, minY, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_181675_d();
    }

    protected static void drawPlanePosZ(IVertexBuilder buffer, Matrix4f matrix, float z, float minX, float maxX, float minY, float maxY, float r, float g, float b, float a) {
        buffer.func_227888_a_(matrix, minX, minY, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, maxX, minY, z).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(matrix, maxX, maxY, z).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(matrix, minX, maxY, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_181675_d();
    }

    protected static RenderType getRenderLayer() {
        return RenderType.func_228632_a_((String)"scan_result", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)65536, (RenderType.State)RenderType.State.func_228694_a_().func_228726_a_(RenderType.field_228515_g_).func_228715_a_(RenderState.field_228492_B_).func_228727_a_(RenderState.field_228496_F_).func_228728_a_(false));
    }

    protected static RenderType getRenderLayer(ResourceLocation textureLocation) {
        return RenderType.func_228632_a_((String)"scan_result", (VertexFormat)DefaultVertexFormats.field_227851_o_, (int)7, (int)65536, (RenderType.State)RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(textureLocation, false, false)).func_228726_a_(RenderType.field_228515_g_).func_228715_a_(RenderState.field_228492_B_).func_228727_a_(RenderState.field_228496_F_).func_228728_a_(false));
    }
}

