/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.world.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.joefoxe.hexerei.world.structure.structures.DarkCovenStructure;
import net.joefoxe.hexerei.world.structure.structures.MangroveTreeStructure;
import net.joefoxe.hexerei.world.structure.structures.WitchHutStructure;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModStructures {
    public static final DeferredRegister<Structure<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"hexerei");
    public static final Set<ResourceLocation> HEXEREI_STRUCTURE_START_PIECES = new HashSet<ResourceLocation>();
    public static final RegistryObject<Structure<NoFeatureConfig>> WITCH_HUT = STRUCTURES.register("witch_hut", WitchHutStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> MANGROVE_TREE = STRUCTURES.register("mangrove_tree", MangroveTreeStructure::new);
    public static final RegistryObject<Structure<NoFeatureConfig>> DARK_COVEN = STRUCTURES.register("dark_coven", DarkCovenStructure::new);

    private static <T extends Structure<?>> RegistryObject<T> addToStructureMaps(String name, Supplier<T> structure) {
        return STRUCTURES.register(name, structure);
    }

    public static void setupStructures() {
        ModStructures.setupMapSpacingAndLand((Structure)WITCH_HUT.get(), new StructureSeparationSettings(20, 8, 1234567890), false);
        ModStructures.setupMapSpacingAndLand((Structure)MANGROVE_TREE.get(), new StructureSeparationSettings(3, 1, 1234567890), false);
        ModStructures.setupMapSpacingAndLand((Structure)DARK_COVEN.get(), new StructureSeparationSettings(29, 11, 1418987890), false);
    }

    public static <F extends Structure<?>> void setupMapSpacingAndLand(F structure, StructureSeparationSettings structureSeparationSettings, boolean transformSurroundingLand) {
        Structure.field_236365_a_.put((Object)structure.getRegistryName().toString(), structure);
        if (transformSurroundingLand) {
            Structure.field_236384_t_ = ImmutableList.builder().addAll((Iterable)Structure.field_236384_t_).add(structure).build();
        }
        DimensionStructuresSettings.field_236191_b_ = ImmutableMap.builder().putAll((Map)DimensionStructuresSettings.field_236191_b_).put(structure, (Object)structureSeparationSettings).build();
        WorldGenRegistries.field_243658_j.func_239659_c_().forEach(settings -> {
            Map structureMap = ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            if (structureMap instanceof ImmutableMap) {
                HashMap<Structure, StructureSeparationSettings> tempMap = new HashMap<Structure, StructureSeparationSettings>(structureMap);
                tempMap.put(structure, structureSeparationSettings);
                ((DimensionSettings)settings.getValue()).func_236108_a_().func_236195_a_();
            } else {
                structureMap.put(structure, structureSeparationSettings);
            }
        });
    }

    public static void register(IEventBus eventBus) {
        STRUCTURES.register(eventBus);
    }
}

