/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.util;

import java.util.function.Supplier;
import net.joefoxe.hexerei.client.renderer.entity.custom.PigeonEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.Skill;
import net.joefoxe.hexerei.util.BirdPacket;
import net.joefoxe.hexerei.util.PigeonRegistries;
import net.joefoxe.hexerei.util.PigeonSkillData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PigeonSkillPacket
extends BirdPacket<PigeonSkillData> {
    @Override
    public void encode(PigeonSkillData data, PacketBuffer buf) {
        super.encode(data, buf);
        buf.writeRegistryIdUnsafe(PigeonRegistries.SKILLS, (IForgeRegistryEntry)data.skill);
    }

    @Override
    public PigeonSkillData decode(PacketBuffer buf) {
        int entityId = buf.readInt();
        Skill skill = (Skill)buf.readRegistryIdUnsafe(PigeonRegistries.SKILLS);
        return new PigeonSkillData(entityId, skill);
    }

    @Override
    public void handleBird(PigeonEntity canisIn, PigeonSkillData data, Supplier<NetworkEvent.Context> ctx) {
        if (!canisIn.canInteract((LivingEntity)ctx.get().getSender())) {
            return;
        }
        int level = canisIn.getLevel(data.skill);
        if (level < data.skill.getMaxLevel() && canisIn.canSpendPoints(data.skill.getLevelCost(level + 1))) {
            canisIn.setSkillLevel(data.skill, level + 1);
        }
    }
}

