/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.tileentity;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.config.HexConfig;
import net.joefoxe.hexerei.container.HerbJarContainer;
import net.joefoxe.hexerei.items.JarHandler;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.message.MessageCountUpdate;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IClearable;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.server.management.PlayerList;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class HerbJarTile
extends LockableLootTileEntity
implements ITickableTileEntity,
IClearable,
INamedContainerProvider {
    public JarHandler itemHandler;
    private final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler).cast();
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private final IReorderingProcessor[] renderText = new IReorderingProcessor[1];
    private final ITextComponent[] signText = new ITextComponent[]{new StringTextComponent("Text")};
    public int degreesOpened;
    public ITextComponent field_213909_b;
    private long lastClickTime;
    private UUID lastClickUUID;

    public HerbJarTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
        this.itemHandler = this.createHandler();
    }

    public void readInventory(CompoundNBT compound) {
        this.itemHandler.deserializeNBT(compound);
    }

    protected NonNullList<ItemStack> func_190576_q() {
        return this.items;
    }

    protected void func_199721_a(NonNullList<ItemStack> itemsIn) {
        this.items = itemsIn;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.getTileEntity().func_174877_v()), this.field_145850_b.func_180495_p(this.getTileEntity().func_174877_v()), 2);
        }
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.hexerei.herb_jar");
    }

    public HerbJarTile() {
        this((TileEntityType)ModTileEntities.HERB_JAR_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        this.itemHandler.deserializeNBT(nbt.func_74775_l("inv"));
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        super.func_230337_a_(state, nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.field_213909_b = ITextComponent.Serializer.func_240643_a_((String)nbt.func_74779_i("CustomName"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("inv", (INBT)this.itemHandler.serializeNBT());
        if (this.field_213909_b != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.field_213909_b));
        }
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return super.func_189515_b(compound);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new HerbJarContainer(id, this.field_145850_b, this.field_174879_c, player, player.field_70458_d);
    }

    public void func_174888_l() {
        super.func_174888_l();
        this.items.clear();
    }

    public double func_145833_n() {
        return 4096.0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB aabb = super.getRenderBoundingBox().func_72314_b(5.0, 5.0, 5.0);
        return aabb;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        assert (this.field_145850_b != null);
        this.func_230337_a_(this.field_145850_b.func_180495_p(this.field_174879_c), pkt.func_148857_g());
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IReorderingProcessor reorderText(int row, Function<ITextComponent, IReorderingProcessor> textProcessorFunction) {
        if (this.renderText[row] == null && this.field_213909_b != null) {
            this.renderText[row] = textProcessorFunction.apply(this.field_213909_b);
        }
        return this.renderText[row];
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    private JarHandler createHandler() {
        return new JarHandler(1, 1024){

            protected void onContentsChanged(int slot) {
                HerbJarTile.this.func_70296_d();
            }

            @Override
            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                if (((Boolean)HexConfig.JARS_ONLY_HOLD_HERBS.get()).booleanValue()) {
                    return stack.func_77973_b().func_206844_a(HexereiTags.Items.HERB_ITEM);
                }
                return true;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public Item getItemInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot).func_77973_b();
    }

    public int getNumberOfItems() {
        int num = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i) == ItemStack.field_190927_a) continue;
            ++num;
        }
        return num;
    }

    public static double getDistanceToEntity(Entity entity, BlockPos pos) {
        double deltaX = entity.func_226277_ct_() - (double)pos.func_177958_n();
        double deltaY = entity.func_226278_cu_() - (double)pos.func_177956_o();
        double deltaZ = entity.func_226281_cx_() - (double)pos.func_177952_p();
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
    }

    public ITextComponent func_145748_c_() {
        return this.field_213909_b != null ? this.field_213909_b : new TranslationTextComponent("");
    }

    @Nonnull
    public ItemStack takeItems(int slot, int count) {
        ItemStack stack = this.itemHandler.getStackInSlot(slot).func_77946_l();
        stack.func_190920_e(Math.min(count, this.itemHandler.getStackInSlot(slot).func_77976_d()));
        this.itemHandler.getStackInSlot(slot).func_190920_e(this.itemHandler.getStackInSlot(slot).func_190916_E() - stack.func_190916_E());
        return stack;
    }

    public int putItems(int slot, @Nonnull ItemStack stack, int count) {
        if (((Boolean)HexConfig.JARS_ONLY_HOLD_HERBS.get()).booleanValue() && !stack.func_77973_b().func_206844_a(HexereiTags.Items.HERB_ITEM)) {
            return 0;
        }
        if (((ItemStack)this.itemHandler.getContents().get(0)).func_190926_b()) {
            this.itemHandler.insertItem(0, stack.func_77946_l(), false);
            this.func_70296_d();
            stack.func_190918_g(count);
            return count;
        }
        if (!((ItemStack)this.itemHandler.getContents().get(0)).func_77969_a(stack)) {
            return 0;
        }
        if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)this.itemHandler.getContents().get(0)))) {
            return 0;
        }
        int countAdded = Math.min(count, stack.func_190916_E());
        countAdded = Math.min(countAdded, 1024 - ((ItemStack)this.itemHandler.getContents().get(0)).func_190916_E());
        ((ItemStack)this.itemHandler.getContents().get(0)).func_190920_e(((ItemStack)this.itemHandler.getContents().get(0)).func_190916_E() + countAdded);
        stack.func_190918_g(countAdded);
        return countAdded;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientUpdateCount(int slot, int count) {
        if (!Objects.requireNonNull(this.func_145831_w()).field_72995_K) {
            return;
        }
        Minecraft.func_71410_x().func_212871_a_(() -> this.clientUpdateCountAsync(slot, count));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientUpdateCountAsync(int slot, int count) {
        if (this.itemHandler.getStackInSlot(0).func_190916_E() != count) {
            ItemStack newStack = this.itemHandler.getStackInSlot(0).func_77946_l();
            this.itemHandler.setStackInSlot(0, newStack);
        }
    }

    protected void syncClientCount(int slot, int count) {
        if (this.func_145831_w() != null && this.func_145831_w().field_72995_K) {
            return;
        }
        PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 500.0, this.func_145831_w().func_234923_W_());
        HexereiPacketHandler.instance.send(PacketDistributor.NEAR.with(() -> point), (Object)new MessageCountUpdate(this.func_174877_v(), slot, count));
    }

    public int interactPutItems(PlayerEntity player) {
        int count = Objects.requireNonNull(this.func_145831_w()).func_82737_E() - this.lastClickTime < 10L && player.func_110124_au().equals(this.lastClickUUID) ? this.interactPutCurrentInventory(0, player) : this.interactPutCurrentItem(0, player);
        this.lastClickTime = this.func_145831_w().func_82737_E();
        this.lastClickUUID = player.func_110124_au();
        if (count > 0) {
            this.func_70296_d();
        }
        return count;
    }

    public int interactPutCurrentItem(int slot, PlayerEntity player) {
        int count = 0;
        ItemStack playerStack = player.field_71071_by.func_70448_g();
        if (!playerStack.func_190926_b()) {
            count = this.putItems(slot, playerStack, playerStack.func_190916_E());
        }
        return count;
    }

    public int interactPutCurrentInventory(int slot, PlayerEntity player) {
        int count = 0;
        if (!((ItemStack)this.itemHandler.getContents().get(0)).func_190926_b()) {
            int n = player.field_71071_by.func_70302_i_();
            for (int i = 0; i < n; ++i) {
                ItemStack subStack = player.field_71071_by.func_70301_a(i);
                if (subStack.func_190926_b()) continue;
                int subCount = this.putItems(slot, subStack, subStack.func_190916_E());
                if (subCount > 0 && subStack.func_190916_E() == 0) {
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
                count += subCount;
            }
        }
        if (count > 0 && player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
        }
        return count;
    }

    public ITextComponent func_200201_e() {
        return this.field_213909_b;
    }

    public boolean func_145818_k_() {
        return this.field_213909_b != null;
    }

    public ITextComponent func_200200_C_() {
        return this.field_213909_b;
    }

    public int getDegreesOpened() {
        return this.degreesOpened;
    }

    public void setDegreesOpened(int degrees) {
        this.degreesOpened = degrees;
    }

    public CompoundNBT saveToNbt(CompoundNBT compound) {
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191281_a((CompoundNBT)compound, this.items, (boolean)false);
        }
        return compound;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean flag = false;
        PlayerList list = ServerLifecycleHooks.getCurrentServer().func_184103_al();
    }

    public int func_70302_i_() {
        return 0;
    }
}

