/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.particle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BloodParticle
extends SpriteTexturedParticle {
    public static final Vector3d[] CUBE = new Vector3d[]{new Vector3d(0.5, -0.1, -0.5), new Vector3d(0.5, -0.1, 0.5), new Vector3d(0.25, -0.1, 0.5), new Vector3d(0.25, -0.1, -0.5), new Vector3d(-0.25, -0.1, -0.5), new Vector3d(-0.25, -0.1, 0.5), new Vector3d(-0.5, -0.1, 0.5), new Vector3d(-0.5, -0.1, -0.5), new Vector3d(0.25, -0.1, -0.5), new Vector3d(0.25, -0.1, -0.25), new Vector3d(-0.25, -0.1, -0.25), new Vector3d(-0.25, -0.1, -0.5), new Vector3d(0.25, 0.1, 0.5), new Vector3d(0.25, 0.1, 0.25), new Vector3d(-0.25, 0.1, 0.25), new Vector3d(-0.25, 0.1, 0.5), new Vector3d(0.25, 0.1, -0.5), new Vector3d(0.25, 0.1, 0.5), new Vector3d(0.5, 0.1, 0.5), new Vector3d(0.5, 0.1, -0.5), new Vector3d(-0.5, 0.1, -0.5), new Vector3d(-0.5, 0.1, 0.5), new Vector3d(-0.25, 0.1, 0.5), new Vector3d(-0.25, 0.1, -0.5), new Vector3d(-0.25, 0.1, -0.5), new Vector3d(-0.25, 0.1, -0.25), new Vector3d(0.25, 0.1, -0.25), new Vector3d(0.25, 0.1, -0.5), new Vector3d(-0.25, -0.1, 0.5), new Vector3d(-0.25, -0.1, 0.25), new Vector3d(0.25, -0.1, 0.25), new Vector3d(0.25, -0.1, 0.5), new Vector3d(-0.5, -0.1, -0.5), new Vector3d(-0.5, 0.1, -0.5), new Vector3d(0.5, 0.1, -0.5), new Vector3d(0.5, -0.1, -0.5), new Vector3d(0.5, -0.1, 0.5), new Vector3d(0.5, 0.1, 0.5), new Vector3d(-0.5, 0.1, 0.5), new Vector3d(-0.5, -0.1, 0.5), new Vector3d(0.5, -0.1, -0.5), new Vector3d(0.5, 0.1, -0.5), new Vector3d(0.5, 0.1, 0.5), new Vector3d(0.5, -0.1, 0.5), new Vector3d(-0.5, -0.1, 0.5), new Vector3d(-0.5, 0.1, 0.5), new Vector3d(-0.5, 0.1, -0.5), new Vector3d(-0.5, -0.1, -0.5), new Vector3d(-0.25, -0.1, 0.25), new Vector3d(-0.25, 0.1, 0.25), new Vector3d(0.25, 0.1, 0.25), new Vector3d(0.25, -0.1, 0.25), new Vector3d(0.25, -0.1, -0.25), new Vector3d(0.25, 0.1, -0.25), new Vector3d(-0.25, 0.1, -0.25), new Vector3d(-0.25, -0.1, -0.25), new Vector3d(-0.25, -0.1, -0.25), new Vector3d(-0.25, 0.1, -0.25), new Vector3d(-0.25, 0.1, 0.25), new Vector3d(-0.25, -0.1, 0.25), new Vector3d(0.25, -0.1, 0.25), new Vector3d(0.25, 0.1, 0.25), new Vector3d(0.25, 0.1, -0.25), new Vector3d(0.25, -0.1, -0.25), new Vector3d(0.25, -0.01, -0.25), new Vector3d(0.25, -0.01, 0.25), new Vector3d(-0.25, -0.01, 0.25), new Vector3d(-0.25, -0.01, -0.25), new Vector3d(-0.25, 0.01, -0.25), new Vector3d(-0.25, 0.01, 0.25), new Vector3d(0.25, 0.01, 0.25), new Vector3d(0.25, 0.01, -0.25)};
    public static final Vector3d[] CUBE_NORMALS = new Vector3d[]{new Vector3d(0.0, 0.1, 0.0), new Vector3d(0.0, 0.1, 0.0), new Vector3d(0.0, 0.1, 0.0), new Vector3d(0.0, 0.1, 0.0), new Vector3d(0.0, -0.5, 0.0), new Vector3d(0.0, -0.5, 0.0), new Vector3d(0.0, -0.5, 0.0), new Vector3d(0.0, -0.5, 0.0), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5), new Vector3d(0.0, 0.0, 0.5)};
    private static final IParticleRenderType renderType = new IParticleRenderType(){

        public void func_217600_a(BufferBuilder bufferBuilder, TextureManager textureManager) {
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            RenderSystem.enableLighting();
            RenderSystem.enableColorMaterial();
            RenderSystem.depthMask((boolean)true);
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        }

        public void func_217599_a(Tessellator tesselator) {
            tesselator.func_78381_a();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.disableLighting();
            RenderSystem.enableTexture();
        }
    };
    protected float scale;
    protected boolean hot;
    protected float rotationDirection;
    protected float rotation;
    protected float rotationOffsetYaw;
    protected float rotationOffsetPitch;
    protected float rotationOffsetRoll;
    protected float colorOffset;
    private boolean billowing = false;

    public BloodParticle(ClientWorld world, double x, double y, double z, double motionX, double motionY, double motionZ) {
        super(world, x, y, z);
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
        this.rotation = 0.0f;
        this.averageAge(80);
        Random random = new Random();
        this.colorOffset = this.field_187136_p.nextFloat() * 0.25f;
        this.rotationOffsetYaw = random.nextFloat();
        this.rotationOffsetPitch = random.nextFloat();
        this.rotationOffsetRoll = random.nextFloat();
        this.setScale(0.2f);
        this.setRotationDirection(random.nextFloat() - 0.5f);
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.func_187115_a(scale * 0.5f, scale * 0.5f);
    }

    public void averageAge(int age) {
        Random random = new Random();
        this.field_70547_e = (int)((double)age + (random.nextDouble() * 2.0 - 1.0) * 8.0);
    }

    public void setHot(boolean hot) {
        this.hot = hot;
    }

    public void setRotationDirection(float rotationDirection) {
        this.rotationDirection = rotationDirection;
    }

    public void func_189213_a() {
        if (this.hot && this.field_70546_d > 0) {
            if (this.field_187124_d == this.field_187127_g) {
                this.billowing = true;
                this.field_190017_n = false;
                if (this.field_187129_i == 0.0 && this.field_187131_k == 0.0) {
                    Vector3d diff = Vector3d.func_237492_c_((Vector3i)new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h)).func_72441_c(0.5, 0.5, 0.5).func_178786_a(this.field_187126_f, this.field_187127_g, this.field_187128_h);
                    this.field_187129_i = -diff.field_72450_a * 0.1;
                    this.field_187131_k = -diff.field_72449_c * 0.1;
                }
                this.field_187129_i *= 1.1;
                this.field_187130_j *= 0.9;
                this.field_187131_k *= 1.1;
            } else if (this.billowing) {
                this.field_187130_j *= 1.2;
            }
        }
        this.rotation = this.rotationDirection * 0.1f + this.rotation;
        super.func_189213_a();
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Vector3d projectedView = renderInfo.func_216785_c();
        float lerpedX = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - projectedView.func_82615_a());
        float lerpedY = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - projectedView.func_82617_b());
        float lerpedZ = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - projectedView.func_82616_c());
        int light = 0xF000F0;
        double ageMultiplier = 1.0 - Math.pow(this.field_70546_d, 3.0) / Math.pow(this.field_70547_e, 3.0);
        for (int i = 0; i < CUBE.length / 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                Vector3d vec = CUBE[i * 4 + j];
                vec = vec.func_178785_b(this.rotation + this.rotationOffsetYaw).func_178789_a(this.rotation + this.rotationOffsetPitch).func_242988_c(this.rotation + this.rotationOffsetRoll).func_186678_a((double)this.scale * ageMultiplier).func_72441_c((double)lerpedX, (double)lerpedY, (double)lerpedZ);
                Vector3d normal = CUBE_NORMALS[i];
                buffer.func_225588_a_((float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c, this.field_70552_h + this.colorOffset, this.field_70553_i, this.field_70551_j, this.field_82339_as, 0.0f, 0.0f, 0, light, (float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c);
            }
        }
    }

    public IParticleRenderType func_217558_b() {
        return renderType;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite sprite) {
            this.spriteSet = sprite;
        }

        @Nullable
        public Particle makeParticle(BasicParticleType typeIn, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            BloodParticle cauldronParticle = new BloodParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed);
            Random random = new Random();
            float colorOffset = random.nextFloat() * 0.2f;
            cauldronParticle.func_70538_b(0.05f + colorOffset, 0.0f, 0.0f);
            cauldronParticle.func_82338_g(2.0f);
            cauldronParticle.func_217568_a(this.spriteSet);
            return cauldronParticle;
        }
    }
}

