/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.items;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class JarHandler
extends ItemStackHandler {
    public final int stacklimit;

    public JarHandler(int size, int stacklimit) {
        super(size);
        this.stacklimit = stacklimit;
    }

    public boolean isEmpty() {
        return IntStream.range(0, this.getSlots()).allMatch(i -> this.getStackInSlot(i).func_190926_b());
    }

    public boolean noValidSlots() {
        return IntStream.range(0, this.getSlots()).mapToObj(arg_0 -> ((JarHandler)this).getStackInSlot(arg_0)).allMatch(stack -> stack.func_190926_b());
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.stacks.set(slot, (Object)stack);
    }

    public int getSlotLimit(int slot) {
        return this.stacklimit;
    }

    public int getStackLimit(int slot, @Nonnull ItemStack stack) {
        return this.stacklimit;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = (ItemStack)this.stacks.get(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, this.stacklimit);
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.field_190927_a);
                this.onContentsChanged(slot);
            }
            return existing;
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public NonNullList<ItemStack> getContents() {
        return this.stacks;
    }

    public CompoundNBT serializeNBT() {
        ListNBT nbtTagList = new ListNBT();
        for (int i = 0; i < this.getContents().size(); ++i) {
            if (((ItemStack)this.getContents().get(i)).func_190926_b()) continue;
            int realCount = Math.min(this.stacklimit, ((ItemStack)this.getContents().get(i)).func_190916_E());
            CompoundNBT itemTag = new CompoundNBT();
            itemTag.func_74768_a("Slot", i);
            ((ItemStack)this.getContents().get(i)).func_77955_b(itemTag);
            itemTag.func_74768_a("ExtendedCount", realCount);
            nbtTagList.add((Object)itemTag);
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Items", (INBT)nbtTagList);
        nbt.func_74768_a("Size", this.getContents().size());
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setSize(nbt.func_150297_b("Size", 3) ? nbt.func_74762_e("Size") : this.getContents().size());
        ListNBT tagList = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            ItemStack stack;
            CompoundNBT itemTags = tagList.func_150305_b(i);
            int slot = itemTags.func_74762_e("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            if (itemTags.func_150297_b("StackList", 9)) {
                stack = ItemStack.field_190927_a;
                ListNBT stackTagList = itemTags.func_150295_c("StackList", 10);
                for (int j = 0; j < stackTagList.size(); ++j) {
                    CompoundNBT itemTag = stackTagList.func_150305_b(j);
                    ItemStack temp = ItemStack.func_199557_a((CompoundNBT)itemTag);
                    if (temp.func_190926_b()) continue;
                    if (stack.func_190926_b()) {
                        stack = temp;
                        continue;
                    }
                    stack.func_190917_f(temp.func_190916_E());
                }
                if (stack.func_190926_b()) continue;
                int count = stack.func_190916_E();
                count = Math.min(count, this.getStackLimit(slot, stack));
                stack.func_190920_e(count);
                this.stacks.set(slot, (Object)stack);
                continue;
            }
            stack = ItemStack.func_199557_a((CompoundNBT)itemTags);
            if (itemTags.func_150297_b("ExtendedCount", 3)) {
                stack.func_190920_e(itemTags.func_74762_e("ExtendedCount"));
            }
            this.stacks.set(slot, (Object)stack);
        }
        this.onLoad();
    }
}

