/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.events;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AnimalFatAdditionModifier
extends LootModifier {
    private final Item addition;

    protected AnimalFatAdditionModifier(ILootCondition[] conditionsIn, Item addition) {
        super(conditionsIn);
        this.addition = addition;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (context.func_216032_b().nextDouble() / (double)Math.min(context.getLootingModifier() + 1, 4) < 0.45) {
            generatedLoot.add(new ItemStack((IItemProvider)this.addition, context.func_216032_b().nextInt(Math.min(context.getLootingModifier() + 1, 4)) + 1));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AnimalFatAdditionModifier> {
        public AnimalFatAdditionModifier read(ResourceLocation name, JsonObject object, ILootCondition[] conditionsIn) {
            Item addition = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"addition")));
            return new AnimalFatAdditionModifier(conditionsIn, addition);
        }

        public JsonObject write(AnimalFatAdditionModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("addition", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.addition).toString());
            return json;
        }
    }
}

