/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom.ai;

import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.EntityAttributeRegistry;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.SkillInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Skill
extends ForgeRegistryEntry<Skill> {
    @Nullable
    private String translationKey;
    @Nullable
    private String translationInfoKey;
    @Nullable
    private final BiFunction<Skill, Integer, SkillInstance> create;

    public Skill(BiFunction<Skill, Integer, SkillInstance> sup) {
        this.create = sup;
    }

    public int getMaxLevel() {
        return 4;
    }

    public int getLevelCost(int toGoToLevel) {
        return toGoToLevel;
    }

    public int getCummulativeCost(int level) {
        return level * (level + 1) / 2;
    }

    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"skill", (ResourceLocation)EntityAttributeRegistry.SKILLS.getKey((IForgeRegistryEntry)this));
        }
        return this.translationKey;
    }

    public String getInfoTranslationKey() {
        if (this.translationInfoKey == null) {
            this.translationInfoKey = this.getTranslationKey() + ".description";
        }
        return this.translationInfoKey;
    }

    public SkillInstance getDefault(int level) {
        if (this.create == null) {
            return new SkillInstance(this, level);
        }
        return this.create.apply(this, level);
    }

    public SkillInstance getDefault() {
        return this.getDefault(1);
    }

    public boolean hasRenderer() {
        return false;
    }
}

