/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom.ai;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.client.renderer.entity.custom.PigeonEntity;
import net.joefoxe.hexerei.client.renderer.entity.custom.ai.PigeonLocationData;
import net.joefoxe.hexerei.util.NBTUtilities;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class PigeonLocationStorage
extends WorldSavedData {
    private Map<UUID, PigeonLocationData> locationDataMap = Maps.newConcurrentMap();

    public PigeonLocationStorage() {
        super("pigeon_locations");
    }

    public static PigeonLocationStorage get(World world) {
        if (!(world instanceof ServerWorld)) {
            throw new RuntimeException("Tried to access canis location data from the client. This should not happen...");
        }
        ServerWorld overworld = world.func_73046_m().func_71218_a(World.field_234918_g_);
        DimensionSavedDataManager storage = overworld.func_217481_x();
        return (PigeonLocationStorage)storage.func_215752_a(PigeonLocationStorage::new, "pigeon_locations");
    }

    public Stream<PigeonLocationData> getCani(LivingEntity owner) {
        UUID ownerId = owner.func_110124_au();
        return this.locationDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId()));
    }

    public Stream<PigeonLocationData> getCani(LivingEntity owner, RegistryKey<World> key) {
        UUID ownerId = owner.func_110124_au();
        return this.locationDataMap.values().stream().filter(data -> ownerId.equals(data.getOwnerId())).filter(data -> key.equals(data.getDimension()));
    }

    @Nullable
    public PigeonLocationData getData(PigeonEntity pigeonIn) {
        return this.getData(pigeonIn.func_110124_au());
    }

    @Nullable
    public PigeonLocationData getData(UUID uuid) {
        if (this.locationDataMap.containsKey(uuid)) {
            return this.locationDataMap.get(uuid);
        }
        return null;
    }

    @Nullable
    public PigeonLocationData remove(PigeonEntity pigeonIn) {
        return this.remove(pigeonIn.func_110124_au());
    }

    @Nullable
    public PigeonLocationData getOrCreateData(PigeonEntity pigeonIn) {
        UUID uuid = pigeonIn.func_110124_au();
        return this.locationDataMap.computeIfAbsent(uuid, $ -> {
            this.func_76185_a();
            return PigeonLocationData.from(this, pigeonIn);
        });
    }

    @Nullable
    public PigeonLocationData remove(UUID uuid) {
        if (this.locationDataMap.containsKey(uuid)) {
            PigeonLocationData storage = this.locationDataMap.remove(uuid);
            this.func_76185_a();
            return storage;
        }
        return null;
    }

    @Nullable
    public PigeonLocationData putData(PigeonEntity pigeonIn) {
        UUID uuid = pigeonIn.func_110124_au();
        PigeonLocationData storage = new PigeonLocationData(this, uuid);
        this.locationDataMap.put(uuid, storage);
        this.func_76185_a();
        return storage;
    }

    public Set<UUID> getAllUUID() {
        return Collections.unmodifiableSet(this.locationDataMap.keySet());
    }

    public Collection<PigeonLocationData> getAll() {
        return Collections.unmodifiableCollection(this.locationDataMap.values());
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.locationDataMap.clear();
        ListNBT list = nbt.func_150295_c("locationData", 10);
        if (list.isEmpty()) {
            list = nbt.func_150295_c("canis_locations", 10);
        }
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT locationCompound = list.func_150305_b(i);
            UUID uuid = NBTUtilities.getUniqueId(locationCompound, "uuid");
            if (uuid == null) {
                uuid = NBTUtilities.getUniqueId(locationCompound, "entityId");
            }
            PigeonLocationData locationData = new PigeonLocationData(this, uuid);
            locationData.read(locationCompound);
            if (uuid == null) {
                Hexerei.LOGGER.info("Failed to load canis location data. Please report to mod author...");
                Hexerei.LOGGER.info((Object)locationData);
                continue;
            }
            this.locationDataMap.put(uuid, locationData);
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (Map.Entry<UUID, PigeonLocationData> entry : this.locationDataMap.entrySet()) {
            CompoundNBT locationCompound = new CompoundNBT();
            PigeonLocationData locationData = entry.getValue();
            NBTUtilities.putUniqueId(locationCompound, "uuid", entry.getKey());
            locationData.write(locationCompound);
            list.add((Object)locationCompound);
        }
        compound.func_218657_a("locationData", (INBT)list);
        return compound;
    }
}

