/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom.ai;

import java.util.EnumSet;
import net.joefoxe.hexerei.client.renderer.entity.custom.PigeonEntity;
import net.joefoxe.hexerei.util.EnumMode;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class PigeonFollowMasterGoal
extends Goal {
    private final PigeonEntity pigeon;
    private final PathNavigator navigator;
    private final World world;
    private final double followSpeed;
    private final float stopDist;
    private final float startDist;
    private LivingEntity owner;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public static int getRandomNumber(LivingEntity entityIn, int minIn, int maxIn) {
        return entityIn.func_70681_au().nextInt(maxIn - minIn + 1) + minIn;
    }

    public PigeonFollowMasterGoal(PigeonEntity pigeonIn, double speedIn, float minDistIn, float maxDistIn) {
        this.pigeon = pigeonIn;
        this.world = pigeonIn.field_70170_p;
        this.followSpeed = speedIn;
        this.navigator = pigeonIn.func_70661_as();
        this.startDist = minDistIn;
        this.stopDist = maxDistIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean func_75250_a() {
        LivingEntity owner = this.pigeon.func_70902_q();
        if (owner == null) {
            return false;
        }
        if (this.pigeon.getMode() == EnumMode.PATROL) {
            return false;
        }
        if (owner.func_175149_v()) {
            return false;
        }
        this.owner = owner;
        return true;
    }

    public boolean func_75253_b() {
        if (this.navigator.func_75500_f()) {
            return false;
        }
        return this.pigeon.func_70068_e((Entity)this.owner) > (double)(this.stopDist * this.stopDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.pigeon.func_184643_a(PathNodeType.WATER);
        this.pigeon.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.owner = null;
        this.navigator.func_75499_g();
        this.pigeon.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    public void func_75246_d() {
        this.pigeon.func_70671_ap().func_75651_a((Entity)this.owner, 10.0f, (float)this.pigeon.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (this.pigeon.func_70068_e((Entity)this.owner) >= 144.0) {
                PigeonFollowMasterGoal.tryToTeleportNearEntity((LivingEntity)this.pigeon, this.navigator, this.owner, 4);
            } else {
                this.navigator.func_75497_a((Entity)this.owner, this.followSpeed);
            }
        }
    }

    public static boolean tryToTeleportNearEntity(LivingEntity entityIn, PathNavigator navigator, LivingEntity target, int radius) {
        return PigeonFollowMasterGoal.tryToTeleportNearEntity(entityIn, navigator, target.func_233580_cy_(), radius);
    }

    public static boolean tryToTeleportNearEntity(LivingEntity entityIn, PathNavigator navigator, BlockPos targetPos, int radius) {
        for (int i = 0; i < 10; ++i) {
            int j = PigeonFollowMasterGoal.getRandomNumber(entityIn, -radius, radius);
            int k = PigeonFollowMasterGoal.getRandomNumber(entityIn, -1, 1);
            int l = PigeonFollowMasterGoal.getRandomNumber(entityIn, -radius, radius);
            boolean flag = PigeonFollowMasterGoal.tryToTeleportToLocation(entityIn, navigator, targetPos, targetPos.func_177958_n() + j, targetPos.func_177956_o() + k, targetPos.func_177952_p() + l);
            if (!flag) continue;
            return true;
        }
        return false;
    }

    public static boolean tryToTeleportToLocation(LivingEntity entityIn, PathNavigator navigator, BlockPos targetPos, int x, int y, int z) {
        if ((double)Math.abs(x - targetPos.func_177958_n()) < 2.0 && (double)Math.abs(z - targetPos.func_177952_p()) < 2.0) {
            return false;
        }
        if (!PigeonFollowMasterGoal.isTeleportFriendlyBlock(entityIn, new BlockPos(x, y, z), false)) {
            return false;
        }
        entityIn.func_174828_a(new BlockPos((double)((float)x + 0.5f), (double)y, (double)((float)z + 0.5f)), entityIn.field_70177_z, entityIn.field_70125_A);
        navigator.func_75499_g();
        return true;
    }

    private static boolean isTeleportFriendlyBlock(LivingEntity entityIn, BlockPos pos, boolean teleportToLeaves) {
        PathNodeType pathnodetype = WalkNodeProcessor.func_237231_a_((IBlockReader)entityIn.field_70170_p, (BlockPos.Mutable)pos.func_239590_i_());
        if (pathnodetype != PathNodeType.WALKABLE) {
            return false;
        }
        BlockState blockstate = entityIn.field_70170_p.func_180495_p(pos.func_177977_b());
        if (!teleportToLeaves && blockstate.func_177230_c() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = pos.func_177973_b((Vector3i)entityIn.func_233580_cy_());
        return entityIn.field_70170_p.func_226665_a__((Entity)entityIn, entityIn.func_174813_aQ().func_186670_a(blockpos));
    }

    public float getMinStartDistanceSq() {
        return this.startDist * this.startDist;
    }
}

