/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.container.HerbJarContainer;
import net.joefoxe.hexerei.tileentity.HerbJarTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fml.network.NetworkHooks;

public class HerbJar
extends Block
implements ITileEntity<HerbJarTile>,
IWaterLoggable {
    public static final BooleanProperty HANGING = BlockStateProperties.field_222514_j;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final VoxelShape SHAPE = Stream.of(Block.func_208617_a((double)5.0, (double)-0.5, (double)5.0, (double)11.0, (double)0.0, (double)11.0), Block.func_208617_a((double)5.5, (double)13.0, (double)5.5, (double)10.5, (double)15.0, (double)10.5), Block.func_208617_a((double)4.5, (double)12.0, (double)10.5, (double)11.5, (double)14.0, (double)11.5), Block.func_208617_a((double)4.5, (double)12.0, (double)4.5, (double)11.5, (double)14.0, (double)5.5), Block.func_208617_a((double)4.5, (double)12.0, (double)5.5, (double)5.5, (double)14.0, (double)10.5), Block.func_208617_a((double)10.5, (double)12.0, (double)5.5, (double)11.5, (double)14.0, (double)10.5), Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0), Block.func_208617_a((double)5.0, (double)11.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public BlockRenderType func_149645_b(BlockState iBlockState) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        FluidState fluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate;
            if (direction.func_176740_k() != Direction.Axis.Y || !(blockstate = (BlockState)this.func_176223_P().func_206870_a((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return (BlockState)((BlockState)blockstate.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a))).func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)context.func_195992_f());
        }
        return null;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        if (itemstack.func_190926_b() && player.func_225608_bj_() || ((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176734_d() != hit.func_216354_b()) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (!worldIn.func_201670_d()) {
                if (tileEntity instanceof HerbJarTile) {
                    INamedContainerProvider containerProvider = this.createContainerProvider(worldIn, pos);
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)containerProvider, (BlockPos)tileEntity.func_174877_v());
                } else {
                    throw new IllegalStateException("Our Container provider is missing!");
                }
            }
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof HerbJarTile) {
            ((HerbJarTile)tileEntity).interactPutItems(player);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_176208_a(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        ItemStack cloneItemStack = this.func_185473_a((IBlockReader)world, pos, state);
        if (!world.func_201670_d()) {
            HerbJar.func_180635_a((World)((ServerWorld)world), (BlockPos)pos, (ItemStack)cloneItemStack);
        }
        super.func_176208_a(world, pos, state, player);
    }

    protected BlockRayTraceResult rayTraceEyes(World world, PlayerEntity player, double length) {
        Vector3d eyePos = player.func_174824_e(1.0f);
        Vector3d lookPos = player.func_70676_i(1.0f);
        Vector3d endPos = eyePos.func_72441_c(lookPos.field_72450_a * length, lookPos.field_72448_b * length, lookPos.field_72449_c * length);
        RayTraceContext context = new RayTraceContext(eyePos, endPos, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.NONE, (Entity)player);
        return world.func_217299_a(context);
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn) {
        BlockRayTraceResult rayResult = this.rayTraceEyes(worldIn, playerIn, playerIn.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e() + 1.0);
        if (rayResult.func_216346_c() == RayTraceResult.Type.MISS) {
            return;
        }
        Direction side = rayResult.func_216354_b();
        TileEntity tile = worldIn.func_175625_s(pos);
        HerbJarTile herbJarTile = null;
        if (tile instanceof HerbJarTile) {
            herbJarTile = (HerbJarTile)tile;
        }
        if (((Direction)state.func_177229_b((Property)HorizontalBlock.field_185512_D)).func_176734_d() != rayResult.func_216354_b()) {
            return;
        }
        ItemStack item = playerIn.func_225608_bj_() ? herbJarTile.takeItems(0, herbJarTile.itemHandler.getStackInSlot(0).func_190916_E()) : herbJarTile.takeItems(0, 1);
        if (!item.func_190926_b()) {
            if (!playerIn.field_71071_by.func_70441_a(item)) {
                this.dropItemStack(worldIn, pos.func_177972_a(side), playerIn, item);
                worldIn.func_184138_a(pos, state, state, 3);
            } else {
                worldIn.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        super.func_196270_a(state, worldIn, pos, playerIn);
    }

    private void dropItemStack(World world, BlockPos pos, PlayerEntity player, @Nonnull ItemStack stack) {
        ItemEntity entity = new ItemEntity(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.3f), (double)((float)pos.func_177952_p() + 0.5f), stack);
        Vector3d motion = entity.func_213322_ci();
        entity.func_70024_g(-motion.field_72450_a, -motion.field_72448_b, -motion.field_72449_c);
        world.func_217376_c((Entity)entity);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public HerbJar(AbstractBlock.Properties properties) {
        super(properties.func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HANGING, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{HorizontalBlock.field_185512_D, HANGING, WATERLOGGED});
    }

    public void onBlockExploded(BlockState state, World world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(state, world, pos, explosion);
        if (world instanceof ServerWorld) {
            ItemStack cloneItemStack = this.func_185473_a((IBlockReader)world, pos, state);
            if (world.func_180495_p(pos) != state && !world.func_201670_d()) {
                world.func_217376_c((Entity)new ItemEntity(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() - 0.5f), (double)((float)pos.func_177952_p() + 0.5f), cloneItemStack));
            }
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        CompoundNBT inv = stack.func_196082_o().func_74775_l("Inventory");
        ListNBT tagList = inv.func_150295_c("Items", 10);
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("\u00a7e--------------\u00a7r"));
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT itemTags = tagList.func_150305_b(i);
                itemTags.func_74768_a("Count", 1);
                TranslationTextComponent itemText = new TranslationTextComponent(ItemStack.func_199557_a((CompoundNBT)itemTags).func_77977_a());
                int countText = Integer.parseInt(String.valueOf(itemTags.func_74781_a("ExtendedCount")));
                itemText.func_240702_b_(" x" + countText);
                tooltip.add((ITextComponent)itemText);
            }
            if (tagList.size() < 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("Can be placed in the world."));
                tooltip.add((ITextComponent)new TranslationTextComponent("Can store items and be moved like a shulker box."));
                tooltip.add((ITextComponent)new TranslationTextComponent("Can be renamed."));
                tooltip.add((ITextComponent)new TranslationTextComponent("Only holds one type of item, but can hold up to 1024."));
            }
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("\u00a7e--------------\u00a7r"));
            for (int i = 0; i < Math.min(tagList.size(), 1); ++i) {
                CompoundNBT itemTags = tagList.func_150305_b(i);
                itemTags.func_74768_a("Count", 1);
                TranslationTextComponent itemText = new TranslationTextComponent(ItemStack.func_199557_a((CompoundNBT)itemTags).func_77977_a());
                int countText = Integer.parseInt(String.valueOf(itemTags.func_74781_a("ExtendedCount")));
                itemText.func_240702_b_(" x" + countText);
                tooltip.add((ITextComponent)itemText);
            }
            if (tagList.size() < 1) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.hexerei.herb_jar"));
            }
        }
        super.func_190948_a(stack, world, tooltip, flagIn);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        ItemStack item = new ItemStack((IItemProvider)this);
        Optional<TileEntity> tileEntityOptional = Optional.ofNullable(this.getTileEntity(worldIn, pos));
        CompoundNBT tag = item.func_196082_o();
        CompoundNBT inv = tileEntityOptional.map(herb_jar -> herb_jar.itemHandler.serializeNBT()).orElse(new CompoundNBT());
        tag.func_218657_a("Inventory", (INBT)inv);
        ITextComponent customName = tileEntityOptional.map(HerbJarTile::func_200201_e).orElse(null);
        if (customName != null) {
            item.func_200302_a(customName);
        }
        return item;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        if (stack.func_82837_s()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            ((HerbJarTile)tileentity).field_213909_b = stack.func_200301_q();
        }
        if (worldIn.func_201670_d()) {
            return;
        }
        if (stack == null) {
            return;
        }
        this.withTileEntityDo((IBlockReader)worldIn, pos, te -> te.readInventory(stack.func_196082_o().func_74775_l("Inventory")));
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos) && !worldIn.func_201670_d() && worldIn instanceof ServerWorld) {
            ItemStack cloneItemStack = this.func_185473_a((IBlockReader)worldIn, currentPos, stateIn);
            worldIn.func_217376_c((Entity)new ItemEntity((World)((ServerWorld)worldIn).func_201672_e(), (double)((float)currentPos.func_177958_n() + 0.5f), (double)((float)currentPos.func_177956_o() - 0.5f), (double)((float)currentPos.func_177952_p() + 0.5f), cloneItemStack));
        }
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = HerbJar.getBlockConnected(state).func_176734_d();
        return Block.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177972_a(direction), (Direction)direction.func_176734_d());
    }

    protected static Direction getBlockConnected(BlockState state) {
        return (Boolean)state.func_177229_b((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) == false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
    }

    private INamedContainerProvider createContainerProvider(final World worldIn, final BlockPos pos) {
        return new INamedContainerProvider(){

            public ITextComponent func_145748_c_() {
                if (((HerbJarTile)worldIn.func_175625_s((BlockPos)pos)).field_213909_b != null) {
                    return new TranslationTextComponent(((HerbJarTile)worldIn.func_175625_s((BlockPos)pos)).field_213909_b.getString());
                }
                return new TranslationTextComponent("screen.hexerei.herb_jar");
            }

            @Nullable
            public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
                return new HerbJarContainer(i, worldIn, pos, playerInventory, playerEntity);
            }
        };
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        TileEntity te = ((TileEntityType)ModTileEntities.HERB_JAR_TILE.get()).func_200968_a();
        return te;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public Class<HerbJarTile> getTileEntityClass() {
        return HerbJarTile.class;
    }
}

