/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.text.BreakIterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.client.MinecraftForgeClient;

public final class FontHelper {
    private FontHelper() {
    }

    public static List<String> cutString(FontRenderer font, String text, int maxWidthPerLine) {
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(MinecraftForgeClient.getLocale());
        iterator.setText(text);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = text.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.func_78256_a(word);
            if (width + newWidth > maxWidthPerLine) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public static void drawSplitString(MatrixStack ms, FontRenderer font, String text, int x, int y, int width, int color) {
        List<String> list = FontHelper.cutString(font, text, width);
        Matrix4f matrix4f = ms.func_227866_c_().func_227870_a_();
        for (String s : list) {
            float f = x;
            if (font.func_78260_a()) {
                int i = font.func_78256_a(font.func_147647_b(s));
                f += (float)(width - i);
            }
            FontHelper.draw(font, s, f, y, color, matrix4f, false);
            y += 9;
        }
    }

    private static int draw(FontRenderer font, String p_228078_1_, float p_228078_2_, float p_228078_3_, int p_228078_4_, Matrix4f p_228078_5_, boolean p_228078_6_) {
        if (p_228078_1_ == null) {
            return 0;
        }
        IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        int i = font.func_228079_a_(p_228078_1_, p_228078_2_, p_228078_3_, p_228078_4_, p_228078_6_, p_228078_5_, (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        return i;
    }
}

