/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.render;

import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionRenderInfo;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.ref.Reference;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class ContraptionRenderManager<C extends ContraptionRenderInfo> {
    protected final World world;
    private int removalTimer;
    protected final Int2ObjectMap<C> renderInfos = new Int2ObjectOpenHashMap();
    protected final List<C> visible = new ObjectArrayList();

    public ContraptionRenderManager(IWorld world) {
        this.world = (World)world;
    }

    public boolean invalidate(Contraption contraption) {
        int entityId = contraption.entity.func_145782_y();
        ContraptionRenderInfo removed = (ContraptionRenderInfo)this.renderInfos.remove(entityId);
        if (removed != null) {
            removed.invalidate();
            this.visible.remove(removed);
            return true;
        }
        return false;
    }

    public void renderLayer(RenderLayerEvent event) {
        for (ContraptionRenderInfo c : this.visible) {
            c.setupMatrices(event.stack, event.camX, event.camY, event.camZ);
        }
    }

    protected abstract C create(Contraption var1);

    public void tick() {
        ++this.removalTimer;
        if (this.removalTimer >= 20) {
            this.removeDeadRenderers();
            this.removalTimer = 0;
        }
        ContraptionHandler.loadedContraptions.get((IWorld)this.world).values().stream().map(Reference::get).filter(Objects::nonNull).map(AbstractContraptionEntity::getContraption).forEach(this::getRenderInfo);
    }

    public void beginFrame(BeginFrameEvent event) {
        this.renderInfos.int2ObjectEntrySet().stream().map(Map.Entry::getValue).forEach(renderInfo -> renderInfo.beginFrame(event));
        this.collectVisible();
    }

    protected void collectVisible() {
        this.visible.clear();
        this.renderInfos.int2ObjectEntrySet().stream().map(Map.Entry::getValue).filter(ContraptionRenderInfo::isVisible).forEach(this.visible::add);
    }

    public C getRenderInfo(Contraption c) {
        int entityId = c.entity.func_145782_y();
        ContraptionRenderInfo renderInfo = (ContraptionRenderInfo)this.renderInfos.get(entityId);
        if (renderInfo == null) {
            renderInfo = this.create(c);
            this.renderInfos.put(entityId, (Object)renderInfo);
        }
        return (C)renderInfo;
    }

    public void delete() {
        for (ContraptionRenderInfo renderer : this.renderInfos.values()) {
            renderer.invalidate();
        }
        this.renderInfos.clear();
    }

    public void removeDeadRenderers() {
        this.renderInfos.values().removeIf(ContraptionRenderInfo::isDead);
    }
}

