/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.render.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FrameableModel
implements IModelGeometry<FrameableModel> {
    public static final Logger LOGGER = LogManager.getLogger();
    public Multimap<MaterialSide, FramingCandidate> materials;
    public List<ResourceLocation> inherits = Collections.emptyList();

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.materials.values().stream().map(FramingCandidate::getRaw).map(arg_0 -> ((IModelConfiguration)owner).resolveTexture(arg_0)).collect(Collectors.toList());
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        ResourceLocation parentLoc;
        IBakedModel parent = null;
        IUnbakedModel ownerModel = owner.getOwnerModel();
        if (ownerModel instanceof BlockModel && (parentLoc = ((BlockModel)ownerModel).getParentLocation()) != null) {
            parent = bakery.getBakedModel(parentLoc, modelTransform, spriteGetter);
        }
        HashMultimap bakedSides = this.materials.entries().stream().collect(Collector.of(HashMultimap::create, (map, entry) -> map.put(entry.getKey(), (Object)((FramingCandidate)entry.getValue()).baked(owner, modelTransform, modelLocation)), (first, second) -> {
            first.putAll((Multimap)second);
            return first;
        }, Collector.Characteristics.UNORDERED));
        for (ResourceLocation rl : this.inherits) {
            IBakedModel baked = bakery.getBakedModel(rl, modelTransform, spriteGetter);
            if (baked instanceof Baked) {
                for (Map.Entry entry2 : ((Baked)baked).bakedSides.entries()) {
                    bakedSides.put(entry2.getKey(), entry2.getValue());
                }
                continue;
            }
            LOGGER.warn("Inherited model must be a frameable model! Got: " + (baked == null ? "null" : baked.getClass()));
        }
        return new Baked(parent, (Multimap<MaterialSide, FramingCandidate.Baked>)bakedSides);
    }

    private static class Baked
    implements IDynamicBakedModel {
        final Multimap<MaterialSide, FramingCandidate.Baked> bakedSides;
        @Nullable
        private final IBakedModel parent;
        private final ItemOverrideList overrides;

        public Baked(final @Nullable IBakedModel parent, final Multimap<MaterialSide, FramingCandidate.Baked> bakedSides) {
            this.bakedSides = bakedSides;
            this.parent = parent;
            this.overrides = new ItemOverrideList(){

                @Nonnull
                public IBakedModel func_239290_a_(IBakedModel model, final ItemStack stack, @Nullable ClientWorld world, @Nullable LivingEntity entity) {
                    return new Baked(parent, bakedSides){

                        @Override
                        @Nonnull
                        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
                            if (stack.func_77942_o()) {
                                CompoundNBT tag = Objects.requireNonNull(stack.func_77978_p());
                                ModelDataMap.Builder builder = new ModelDataMap.Builder();
                                for (MaterialSide material : MaterialSide.values()) {
                                    String key = material.getKey();
                                    if (key == null || !tag.func_74764_b(key)) continue;
                                    builder.withInitial(material.property, (Object)ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(key)));
                                }
                                extraData = builder.build();
                            }
                            return super.getQuads(state, side, rand, extraData);
                        }

                        @Override
                        public ItemOverrideList func_188617_f() {
                            return ItemOverrideList.field_188022_a;
                        }
                    };
                }
            };
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            RenderType layer = MinecraftForgeClient.getRenderLayer();
            for (MaterialSide material : MaterialSide.values()) {
                if (layer != null && material.type != layer) continue;
                for (FramingCandidate.Baked baked : this.bakedSides.get((Object)material)) {
                    if (baked.getEnclosing().face.field_178244_b != side || !baked.getEnclosing().condition.test(extraData)) continue;
                    quads.add(baked.getQuad(this.resolve(extraData, material)));
                }
            }
            return quads;
        }

        private ItemStack resolve(IModelData data, MaterialSide material) {
            if (material == MaterialSide.OVERLAY) {
                return null;
            }
            ItemStack stack = (ItemStack)data.getData(material.property);
            if (material != MaterialSide.SIDE && (stack == null || stack.func_190926_b())) {
                return this.resolve(data, MaterialSide.SIDE);
            }
            return stack;
        }

        public boolean func_177555_b() {
            return this.parent != null && this.parent.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.parent != null && this.parent.func_177556_c();
        }

        public boolean func_230044_c_() {
            return this.parent != null && this.parent.func_230044_c_();
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.bakedSides.get((Object)MaterialSide.SIDE).stream().findFirst().map(mat -> mat.rawMaterial.func_229314_c_()).orElseGet(() -> this.parent == null ? (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_).apply(MissingTextureSprite.func_195675_b()) : this.parent.getParticleTexture((IModelData)EmptyModelData.INSTANCE));
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            if (this.parent != null) {
                this.parent.handlePerspective(cameraTransformType, mat);
            }
            return this;
        }
    }

    public static class FramingCandidate {
        public static final FaceBakery FACE_BAKERY = new FaceBakery();
        public Vector3f start;
        public Vector3f end;
        public Direction direction;
        public BlockPartFace face;
        public Condition condition = Condition.ALWAYS;

        public String getRaw() {
            return this.face.field_178242_d;
        }

        public Baked baked(IModelConfiguration owner, IModelTransform transform, ResourceLocation modelLocation) {
            return new Baked(owner, transform, modelLocation);
        }

        public static enum Condition implements Predicate<IModelData>
        {
            LOCKED(data -> {
                IDrawerAttributes attr = (IDrawerAttributes)data.getData(TileEntityDrawers.ATTRIBUTES);
                return attr != null && (attr.isItemLocked(LockAttribute.LOCK_EMPTY) || attr.isItemLocked(LockAttribute.LOCK_POPULATED));
            }),
            ALWAYS(data -> true);

            private final Predicate<IModelData> predicate;

            private Condition(Predicate<IModelData> predicate) {
                this.predicate = predicate;
            }

            @Override
            public boolean test(IModelData data) {
                return this.predicate.test(data);
            }
        }

        public class Baked {
            private final Function<TextureAtlasSprite, BakedQuad> quadSupplier;
            private final Cache<TextureAtlasSprite, BakedQuad> quadCache = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build();
            public RenderMaterial rawMaterial;

            public FramingCandidate getEnclosing() {
                return FramingCandidate.this;
            }

            private Baked(IModelConfiguration owner, IModelTransform transform, ResourceLocation modelLocation) {
                this.rawMaterial = owner.resolveTexture(FramingCandidate.this.face.field_178242_d);
                FramingCandidate.this.face.field_178243_e.func_178349_a(this.getFaceUvs(FramingCandidate.this.direction));
                this.quadSupplier = sprite -> FACE_BAKERY.func_228824_a_(FramingCandidate.this.start, FramingCandidate.this.end, FramingCandidate.this.face, sprite, FramingCandidate.this.direction, transform, null, true, modelLocation);
            }

            public float[] getFaceUvs(Direction facing) {
                switch (facing) {
                    case DOWN: {
                        return new float[]{FramingCandidate.this.start.func_195899_a(), 16.0f - FramingCandidate.this.end.func_195902_c(), FramingCandidate.this.end.func_195899_a(), 16.0f - FramingCandidate.this.start.func_195902_c()};
                    }
                    case UP: {
                        return new float[]{FramingCandidate.this.start.func_195899_a(), FramingCandidate.this.start.func_195902_c(), FramingCandidate.this.end.func_195899_a(), FramingCandidate.this.end.func_195902_c()};
                    }
                    default: {
                        return new float[]{16.0f - FramingCandidate.this.end.func_195899_a(), 16.0f - FramingCandidate.this.end.func_195900_b(), 16.0f - FramingCandidate.this.start.func_195899_a(), 16.0f - FramingCandidate.this.start.func_195900_b()};
                    }
                    case SOUTH: {
                        return new float[]{FramingCandidate.this.start.func_195899_a(), 16.0f - FramingCandidate.this.end.func_195900_b(), FramingCandidate.this.end.func_195899_a(), 16.0f - FramingCandidate.this.start.func_195900_b()};
                    }
                    case WEST: {
                        return new float[]{FramingCandidate.this.start.func_195902_c(), 16.0f - FramingCandidate.this.end.func_195900_b(), FramingCandidate.this.end.func_195902_c(), 16.0f - FramingCandidate.this.start.func_195900_b()};
                    }
                    case EAST: 
                }
                return new float[]{16.0f - FramingCandidate.this.end.func_195902_c(), 16.0f - FramingCandidate.this.end.func_195900_b(), 16.0f - FramingCandidate.this.start.func_195902_c(), 16.0f - FramingCandidate.this.start.func_195900_b()};
            }

            public BakedQuad getQuad(ItemStack stack) {
                TextureAtlasSprite sprite = stack == null || stack.func_190926_b() ? this.rawMaterial.func_229314_c_() : this.getSprite(stack);
                try {
                    return (BakedQuad)this.quadCache.get((Object)sprite, () -> this.quadSupplier.apply(sprite));
                }
                catch (ExecutionException e) {
                    return this.quadSupplier.apply(sprite);
                }
            }

            private TextureAtlasSprite getSprite(ItemStack stack) {
                return Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null).getParticleTexture((IModelData)EmptyModelData.INSTANCE);
            }
        }
    }

    public static enum MaterialSide {
        SIDE(RenderType.func_228643_e_()),
        FRONT(RenderType.func_228643_e_()),
        TRIM(RenderType.func_228643_e_()),
        OVERLAY(RenderType.func_228645_f_());

        public final ModelProperty<ItemStack> property = new ModelProperty();
        private final RenderType type;

        private MaterialSide(RenderType type) {
            this.type = type;
        }

        @Nullable
        public String getKey() {
            if (this != OVERLAY) {
                return "Mat" + this.name().charAt(0);
            }
            return null;
        }
    }
}

