/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.world.structures;

import com.mojang.serialization.Codec;
import mysticmods.mysticalworld.repack.noobutil.world.gen.structure.SimpleStructure;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class RuinedHutStructure
extends SimpleStructure {
    public RuinedHutStructure(Codec<NoFeatureConfig> codec) {
        super(codec);
    }

    @Override
    public Structure.IStartFactory<NoFeatureConfig> func_214557_a() {
        return Start::new;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeProvider, long seed, SharedSeedRandom sharedSeed, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, NoFeatureConfig config) {
        int startX = chunkX << 4;
        int startZ = chunkZ << 4;
        int min = Integer.MAX_VALUE;
        int max = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = chunkGenerator.func_222529_a(startX + x, startZ + z, Heightmap.Type.WORLD_SURFACE_WG);
                if (height < min) {
                    min = height;
                }
                if (height > max) {
                    max = height;
                }
                if (max - min <= 3) continue;
                return false;
            }
        }
        return true;
    }

    public static class Start
    extends SimpleStructure.SimpleStart {
        private static final ResourceLocation POOL = new ResourceLocation("mysticalworld", "hut_ruined_pool/start_pool");

        public Start(Structure<NoFeatureConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        @Override
        protected ResourceLocation getPoolLocation() {
            return POOL;
        }

        @Override
        protected int getPoolSize() {
            return 50;
        }

        @Override
        protected void modifyStructure(DynamicRegistries dynamicRegistries, ChunkGenerator chunkGenerator, TemplateManager templateManager, Biome biome, NoFeatureConfig noFeatureConfig, BlockPos blockPos) {
        }
    }
}

