/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.shoulders.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.repack.shoulders.Constants;
import mysticmods.mysticalworld.repack.shoulders.info.ShoulderData;
import net.minecraft.entity.player.PlayerEntity;
import org.apache.commons.io.IOUtils;

public class ShoulderList {
    private static final Map<UUID, ShoulderData> dataMap = Collections.synchronizedMap(new HashMap());
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        Map<UUID, ShoulderData> map = dataMap;
        synchronized (map) {
            JsonArray data;
            dataMap.clear();
            try {
                Constants.LOG.info("Fetching Patreon supporter information from GitHub...");
                String response = IOUtils.toString((URL)new URL("https://raw.githubusercontent.com/noobanidus/shoulders/1.16.5/src/generated/resources/data/info/shoulders.json"), (Charset)StandardCharsets.UTF_8);
                data = (JsonArray)GSON.fromJson(response, JsonArray.class);
            }
            catch (IOException e) {
                Constants.LOG.error("Unable to load Patreon information!");
                return;
            }
            for (JsonElement element : data) {
                JsonObject object = element.getAsJsonObject();
                ShoulderData entry = ShoulderData.fromJson(object);
                dataMap.put(entry.getPlayer(), entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static ShoulderData getData(PlayerEntity player) {
        Map<UUID, ShoulderData> map = dataMap;
        synchronized (map) {
            return dataMap.get(player.func_110124_au());
        }
    }
}

