/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.shoulders.client.transforms;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mysticmods.mysticalworld.repack.shoulders.client.transforms.ITransformer;
import mysticmods.mysticalworld.repack.shoulders.info.Shoulder;
import mysticmods.mysticalworld.repack.shoulders.info.ShoulderData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;

public class ModelTransformer {
    public static final ModelTransformer EMPTY = new ModelTransformer();
    private final Map<Shoulder, List<ITransformer>> translations = new HashMap<Shoulder, List<ITransformer>>();
    private final Map<Shoulder, List<ITransformer>> rotations = new HashMap<Shoulder, List<ITransformer>>();
    private final Map<Shoulder, List<ITransformer>> scales = new HashMap<Shoulder, List<ITransformer>>();
    private Shoulder shoulder;

    protected ModelTransformer() {
    }

    public ModelTransformer translate(ITransformer ... translations) {
        this.translations.computeIfAbsent(this.shoulder, s -> new ArrayList()).addAll(Arrays.asList(translations));
        return this;
    }

    public ModelTransformer t(ITransformer ... translations) {
        return this.translate(translations);
    }

    public ModelTransformer rotate(ITransformer ... rotations) {
        this.rotations.computeIfAbsent(this.shoulder, s -> new ArrayList()).addAll(Arrays.asList(rotations));
        return this;
    }

    public ModelTransformer r(ITransformer ... rotations) {
        return this.rotate(rotations);
    }

    public ModelTransformer scale(ITransformer ... scales) {
        this.scales.computeIfAbsent(this.shoulder, s -> new ArrayList()).addAll(Arrays.asList(scales));
        return this;
    }

    public ModelTransformer s(ITransformer ... scales) {
        return this.scale(scales);
    }

    public void transform(MatrixStack stack, ShoulderData data, PlayerEntity player, double armorOffset) {
        double ao = player.func_184582_a(EquipmentSlotType.CHEST).func_190926_b() ? 0.0 : armorOffset;
        this.scales.getOrDefault((Object)data.getShoulder(), Collections.emptyList()).forEach(s -> s.transform(stack, data, player, ao));
        this.rotations.getOrDefault((Object)data.getShoulder(), Collections.emptyList()).forEach(r -> r.transform(stack, data, player, ao));
        this.translations.getOrDefault((Object)data.getShoulder(), Collections.emptyList()).forEach(t -> t.transform(stack, data, player, ao));
    }

    public static ModelTransformer transformer() {
        return new ModelTransformer();
    }

    public ModelTransformer left() {
        this.shoulder = Shoulder.LEFT;
        return this;
    }

    public ModelTransformer right() {
        this.shoulder = Shoulder.RIGHT;
        return this;
    }

    public ModelTransformer head() {
        this.shoulder = Shoulder.HEAD;
        return this;
    }
}

