/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.shoulders.client.models;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.repack.shoulders.client.models.IShoulderRidingModel;
import mysticmods.mysticalworld.repack.shoulders.info.ShoulderData;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.TintedAgeableModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.util.ResourceLocation;

public class WolfModel
extends TintedAgeableModel<LivingEntity>
implements IShoulderRidingModel {
    private final ModelRenderer head;
    private final ModelRenderer realHead;
    private final ModelRenderer body;
    private final ModelRenderer leg0;
    private final ModelRenderer leg1;
    private final ModelRenderer leg2;
    private final ModelRenderer leg3;
    private final ModelRenderer tail;
    private final ModelRenderer realTail;
    private final ModelRenderer upperBody;
    private static final List<ResourceLocation> TEXTURES = Arrays.asList(new ResourceLocation("textures/entity/wolf/wolf.png"), new ResourceLocation("textures/entity/wolf/wolf_tame.png"), new ResourceLocation("textures/entity/wolf/wolf_angry.png"));
    private static final ResourceLocation WOLF_COLLAR = new ResourceLocation("textures/entity/wolf/wolf_collar.png");

    public WolfModel() {
        float f = 0.0f;
        float f1 = 13.5f;
        this.head = new ModelRenderer((Model)this, 0, 0);
        this.head.func_78793_a(-1.0f, 13.5f, -7.0f);
        this.realHead = new ModelRenderer((Model)this, 0, 0);
        this.realHead.func_228301_a_(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, 0.0f);
        this.head.func_78792_a(this.realHead);
        this.body = new ModelRenderer((Model)this, 18, 14);
        this.body.func_228301_a_(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, 0.0f);
        this.body.func_78793_a(0.0f, 14.0f, 2.0f);
        this.upperBody = new ModelRenderer((Model)this, 21, 0);
        this.upperBody.func_228301_a_(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, 0.0f);
        this.upperBody.func_78793_a(-1.0f, 14.0f, 2.0f);
        this.leg0 = new ModelRenderer((Model)this, 0, 18);
        this.leg0.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, 0.0f);
        this.leg0.func_78793_a(-2.5f, 16.0f, 7.0f);
        this.leg1 = new ModelRenderer((Model)this, 0, 18);
        this.leg1.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, 0.0f);
        this.leg1.func_78793_a(0.5f, 16.0f, 7.0f);
        this.leg2 = new ModelRenderer((Model)this, 0, 18);
        this.leg2.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, 0.0f);
        this.leg2.func_78793_a(-2.5f, 16.0f, -4.0f);
        this.leg3 = new ModelRenderer((Model)this, 0, 18);
        this.leg3.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, 0.0f);
        this.leg3.func_78793_a(0.5f, 16.0f, -4.0f);
        this.tail = new ModelRenderer((Model)this, 9, 18);
        this.tail.func_78793_a(-1.0f, 12.0f, 8.0f);
        this.realTail = new ModelRenderer((Model)this, 9, 18);
        this.realTail.func_228301_a_(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, 0.0f);
        this.tail.func_78792_a(this.realTail);
        this.realHead.func_78784_a(16, 14).func_228301_a_(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, 0.0f);
        this.realHead.func_78784_a(16, 14).func_228301_a_(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, 0.0f);
        this.realHead.func_78784_a(0, 10).func_228301_a_(-0.5f, 0.0f, -5.0f, 3.0f, 3.0f, 4.0f, 0.0f);
    }

    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableList.of((Object)this.body, (Object)this.leg0, (Object)this.leg1, (Object)this.leg2, (Object)this.leg3, (Object)this.tail, (Object)this.upperBody);
    }

    public void prepareMobModel(LivingEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
    }

    @Override
    public void prepare(ShoulderData data) {
        this.upperBody.func_78793_a(-1.0f, 16.0f, -3.0f);
        this.upperBody.field_78795_f = 1.2566371f;
        this.upperBody.field_78796_g = 0.0f;
        this.body.func_78793_a(0.0f, 18.0f, 0.0f);
        this.body.field_78795_f = 0.7853982f;
        this.tail.func_78793_a(-1.0f, 21.0f, 6.0f);
        this.leg0.func_78793_a(-2.5f, 22.7f, 2.0f);
        this.leg0.field_78795_f = 4.712389f;
        this.leg1.func_78793_a(0.5f, 22.7f, 2.0f);
        this.leg1.field_78795_f = 4.712389f;
        this.leg2.field_78795_f = 5.811947f;
        this.leg2.func_78793_a(-2.49f, 17.0f, -4.0f);
        this.leg3.field_78795_f = 5.811947f;
        this.leg3.func_78793_a(0.51f, 17.0f, -4.0f);
    }

    @Override
    public RenderType getRenderType(ShoulderData data) {
        return this.func_228282_a_(this.getTexture(data));
    }

    @Nullable
    private float[] getCollarColor(ShoulderData data) {
        int color = data.getVariant() & 0x1F;
        if (color == 0) {
            return null;
        }
        return DyeColor.func_196056_a((int)(color - 1)).func_193349_f();
    }

    @Override
    public ResourceLocation getTexture(ShoulderData data) {
        int var = data.getVariant() >> 5;
        if (var < TEXTURES.size()) {
            return TEXTURES.get(var);
        }
        return TEXTURES.get(0);
    }

    @Override
    public EntityModel<LivingEntity> getModel() {
        return this;
    }

    @Override
    public Iterable<ModelRenderer> getParts() {
        return Iterables.concat(this.func_225602_a_(), this.func_225600_b_());
    }

    public void setupAnim(LivingEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
    }

    @Override
    public void setupAnim(ShoulderData data, int ticks, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.field_78795_f = pHeadPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = pNetHeadYaw * ((float)Math.PI / 180);
        this.tail.field_78795_f = pAgeInTicks;
    }

    @Override
    public void renderExtra(ShoulderData data, @Nonnull MatrixStack pMatrixStack, @Nonnull IRenderTypeBuffer pBuffer, int pPackedLight, @Nonnull PlayerEntity pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        IVertexBuilder vertex = pBuffer.getBuffer(RenderType.func_228640_c_((ResourceLocation)WOLF_COLLAR));
        float[] color = this.getCollarColor(data);
        if (color != null) {
            this.prepare(data);
            this.setupAnim(data, pLivingEntity.field_70173_aa, pLimbSwing, pLimbSwingAmount, 0.0f, pNetHeadYaw, pHeadPitch);
            this.getParts().forEach(part -> part.func_228309_a_(pMatrixStack, vertex, pPackedLight, OverlayTexture.field_229196_a_, color[0], color[1], color[2], 1.0f));
        }
    }
}

