/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.shoulders.client.models;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mysticmods.mysticalworld.repack.shoulders.Constants;
import mysticmods.mysticalworld.repack.shoulders.client.bootstrap.Bootstrap;
import mysticmods.mysticalworld.repack.shoulders.client.models.IShoulderRidingModel;
import mysticmods.mysticalworld.repack.shoulders.info.ShoulderData;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class SilverFoxModel
extends AgeableModel<LivingEntity>
implements IShoulderRidingModel {
    private final ModelRenderer body1;
    private final ModelRenderer frontL;
    private final ModelRenderer frontR;
    private final ModelRenderer body2;
    private final ModelRenderer neck;
    private final ModelRenderer backL;
    private final ModelRenderer backR;
    private final ModelRenderer tail1;
    private final ModelRenderer tail2;
    private final ModelRenderer tail3;
    private final ModelRenderer tail4;
    private final ModelRenderer head;
    private final ModelRenderer snout;
    private final ModelRenderer earR;
    private final ModelRenderer earL;
    private static final List<ResourceLocation> TEXTURES = Arrays.asList(Constants.rl("textures/entity/red_fox.png"), Constants.rl("textures/entity/silver_fox.png"), Constants.rl("textures/entity/aqua_fox.png"));

    public SilverFoxModel() {
        super(true, 5.0f, 2.0f);
        this.field_78090_t = 32;
        this.field_78089_u = 32;
        this.backL = new ModelRenderer((Model)this, 0, 16);
        this.backL.field_78809_i = true;
        this.backL.func_78793_a(1.0f, 4.0f, 1.5f);
        this.backL.func_228301_a_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f);
        this.tail4 = new ModelRenderer((Model)this, 8, 18);
        this.tail4.func_78793_a(0.0f, 3.5f, 0.0f);
        this.tail4.func_228301_a_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.tail4, 0.3926991f, 0.0f, 0.0f);
        this.body1 = new ModelRenderer((Model)this, 12, 8);
        this.body1.func_78793_a(0.0f, 15.5f, -2.0f);
        this.body1.func_228301_a_(-2.5f, 0.0f, 0.0f, 5.0f, 4.0f, 5.0f, 0.0f);
        this.backR = new ModelRenderer((Model)this, 0, 16);
        this.backR.func_78793_a(-1.0f, 4.0f, 1.5f);
        this.backR.func_228301_a_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f);
        this.neck = new ModelRenderer((Model)this, 16, 0);
        this.neck.func_78793_a(0.0f, 1.5f, 2.0f);
        this.neck.func_228301_a_(-2.0f, -2.0f, -4.0f, 4.0f, 4.0f, 4.0f, 0.0f);
        this.setRotateAngle(this.neck, -0.2617994f, 0.0f, 0.0f);
        this.earR = new ModelRenderer((Model)this, 0, 12);
        this.earR.func_78793_a(-1.5f, -1.0f, -1.0f);
        this.earR.func_228301_a_(-1.0f, -3.0f, -0.5f, 2.0f, 3.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.earR, 0.0f, 0.2617994f, -0.5235988f);
        this.tail3 = new ModelRenderer((Model)this, 0, 24);
        this.tail3.func_78793_a(0.0f, 3.0f, 0.0f);
        this.tail3.func_228301_a_(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, 0.0f);
        this.snout = new ModelRenderer((Model)this, 0, 0);
        this.snout.func_78793_a(0.0f, 0.0f, -3.0f);
        this.snout.func_228301_a_(-1.5f, 0.0f, -3.0f, 3.0f, 2.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.snout, 0.17453292f, 0.0f, 0.0f);
        this.head = new ModelRenderer((Model)this, 0, 5);
        this.head.func_78793_a(0.0f, 0.0f, -4.0f);
        this.head.func_228301_a_(-2.5f, -2.0f, -3.0f, 5.0f, 4.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.head, 0.2617994f, 0.0f, 0.0f);
        this.tail1 = new ModelRenderer((Model)this, 12, 0);
        this.tail1.func_78793_a(0.0f, 1.0f, 2.5f);
        this.tail1.func_228301_a_(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, 0.0f);
        this.setRotateAngle(this.tail1, 1.1780972f, 0.0f, 0.0f);
        this.earL = new ModelRenderer((Model)this, 0, 12);
        this.earL.field_78809_i = true;
        this.earL.func_78793_a(1.5f, -1.0f, -1.0f);
        this.earL.func_228301_a_(-1.0f, -3.0f, -0.5f, 2.0f, 3.0f, 1.0f, 0.0f);
        this.setRotateAngle(this.earL, 0.0f, -0.2617994f, 0.5235988f);
        this.frontL = new ModelRenderer((Model)this, 0, 16);
        this.frontL.field_78809_i = true;
        this.frontL.func_78793_a(1.0f, 4.0f, 1.0f);
        this.frontL.func_228301_a_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f);
        this.body2 = new ModelRenderer((Model)this, 16, 17);
        this.body2.func_78793_a(0.0f, 0.0f, 5.0f);
        this.body2.func_228301_a_(-2.0f, 0.0f, 0.0f, 4.0f, 4.0f, 3.0f, 0.0f);
        this.frontR = new ModelRenderer((Model)this, 0, 16);
        this.frontR.func_78793_a(-1.0f, 4.0f, 1.0f);
        this.frontR.func_228301_a_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f);
        this.tail2 = new ModelRenderer((Model)this, 16, 24);
        this.tail2.func_78793_a(0.0f, 1.5f, 0.0f);
        this.tail2.func_228301_a_(-1.5f, 0.0f, -1.5f, 3.0f, 3.0f, 3.0f, 0.0f);
        this.setRotateAngle(this.tail2, -0.3926991f, 0.0f, 0.0f);
        this.body2.func_78792_a(this.backL);
        this.tail3.func_78792_a(this.tail4);
        this.body2.func_78792_a(this.backR);
        this.body1.func_78792_a(this.neck);
        this.head.func_78792_a(this.earR);
        this.tail2.func_78792_a(this.tail3);
        this.head.func_78792_a(this.snout);
        this.neck.func_78792_a(this.head);
        this.body2.func_78792_a(this.tail1);
        this.head.func_78792_a(this.earL);
        this.body1.func_78792_a(this.frontL);
        this.body1.func_78792_a(this.body2);
        this.body1.func_78792_a(this.frontR);
        this.tail1.func_78792_a(this.tail2);
    }

    @Nonnull
    protected Iterable<ModelRenderer> func_225602_a_() {
        return ImmutableSet.of();
    }

    @Nonnull
    protected Iterable<ModelRenderer> func_225600_b_() {
        return ImmutableSet.of((Object)this.body1);
    }

    public void setupAnim(LivingEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @Override
    public void setupAnim(ShoulderData data, int ticks, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.backL.func_78793_a(1.0f, 4.0f, 1.5f);
        this.backR.func_78793_a(-1.0f, 4.0f, 1.5f);
        this.body1.func_78793_a(0.0f, 15.5f, -2.0f);
        this.body2.func_78793_a(0.0f, 0.0f, 5.0f);
        this.earL.func_78793_a(1.5f, -1.0f, -1.0f);
        this.earR.func_78793_a(-1.5f, -1.0f, -1.0f);
        this.frontL.func_78793_a(1.0f, 4.0f, 1.0f);
        this.frontR.func_78793_a(-1.0f, 4.0f, 1.0f);
        this.head.func_78793_a(0.0f, 0.0f, -4.0f);
        this.neck.func_78793_a(0.0f, 1.5f, 2.0f);
        this.snout.func_78793_a(0.0f, 0.0f, -3.0f);
        this.tail1.func_78793_a(0.0f, 1.0f, 2.5f);
        this.tail2.func_78793_a(0.0f, 1.5f, 0.0f);
        this.tail3.func_78793_a(0.0f, 3.0f, 0.0f);
        this.tail4.func_78793_a(0.0f, 3.5f, 0.0f);
        this.setRotateAngle(this.backL, -0.8196066f, -0.31869712f, 0.0f);
        this.setRotateAngle(this.backR, -0.8196066f, 0.3642502f, 0.0f);
        this.setRotateAngle(this.body1, -0.68294734f, 0.0f, 0.0f);
        this.setRotateAngle(this.body2, -0.045553092f, 0.0f, 0.0f);
        this.setRotateAngle(this.earL, 0.0f, -0.2617994f, 0.6085963f);
        this.setRotateAngle(this.earR, 0.0f, 0.2617994f, -0.5988225f);
        this.setRotateAngle(this.frontL, 0.31869712f, 0.0f, 0.0f);
        this.setRotateAngle(this.frontR, 0.31869712f, 0.0f, 0.0f);
        this.setRotateAngle(this.neck, 0.3f, 0.0f, 0.0f);
        this.setRotateAngle(this.snout, 0.17453292f, 0.0f, 0.0f);
        this.setRotateAngle(this.tail1, 2.5497515f, 0.0f, 0.061784655f);
        this.setRotateAngle(this.tail2, -0.3926991f, 0.0f, 0.08726646f);
        this.setRotateAngle(this.tail3, 0.0f, 0.0f, 0.061784655f);
        this.setRotateAngle(this.tail4, 0.3926991f, 0.0f, 0.0f);
        this.head.field_78795_f = 0.3f + headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
    }

    @Override
    public void prepare(ShoulderData data) {
    }

    @Override
    public RenderType getRenderType(ShoulderData data) {
        return this.func_228282_a_(this.getTexture(data));
    }

    @Override
    public ResourceLocation getTexture(ShoulderData data) {
        switch (data.getVariant()) {
            default: {
                return Bootstrap.modTex("red_fox");
            }
            case 1: {
                return Bootstrap.modTex("silver_fox");
            }
            case 2: 
        }
        return Bootstrap.modTex("aqua_fox");
    }

    @Override
    public EntityModel<LivingEntity> getModel() {
        return this;
    }

    @Override
    public Iterable<ModelRenderer> getParts() {
        return Iterables.concat(this.func_225602_a_(), this.func_225600_b_());
    }
}

