/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.shoulders.client.models;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import mysticmods.mysticalworld.repack.shoulders.info.ShoulderData;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;

public interface ShoulderRidingModel<T extends Entity> {
    default public void setRotationOffset(ModelRenderer renderer, float x, float y, float z) {
        renderer.field_78795_f = x;
        renderer.field_78796_g = y;
        renderer.field_78808_h = z;
    }

    default public float getSwing(float deg, float ageInTicks) {
        return (float)Math.sin((double)(ageInTicks * 0.125f) * (Math.PI * 2) + Math.toRadians(deg));
    }

    default public float getBobble(float deg, float ageInTicks) {
        return (float)Math.sin((double)(ageInTicks * 0.03125f) * (Math.PI * 2) + Math.toRadians(deg));
    }

    default public void renderOnShoulder(ShoulderData data, MatrixStack pMatrixStack, IVertexBuilder pBuffer, int pPackedLight, int pPackedOverlay, float pLimbSwing, float pLimbSwingAmount, float pNetHeadYaw, float pHeadPitch, int ticks) {
        this.prepare(data);
        this.setupAnim(data, ticks, pLimbSwing, pLimbSwingAmount, 0.0f, pNetHeadYaw, pHeadPitch);
        this.shoulderHeadParts().forEach(part -> part.func_228308_a_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay));
        this.shoulderBodyParts().forEach(part -> part.func_228308_a_(pMatrixStack, pBuffer, pPackedLight, pPackedOverlay));
    }

    public void setupAnim(ShoulderData var1, int var2, float var3, float var4, float var5, float var6, float var7);

    public void prepare(ShoulderData var1);

    public ResourceLocation getTexture(ShoulderData var1);

    public Iterable<ModelRenderer> shoulderHeadParts();

    public Iterable<ModelRenderer> shoulderBodyParts();
}

