/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.noobutil.world.gen.provider;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import mysticmods.mysticalworld.repack.noobutil.NoobUtil;
import mysticmods.mysticalworld.repack.noobutil.type.LazyStateSupplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.BlockStateProviderType;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractSupplierBlockStateProvider
extends BlockStateProvider {
    protected final ResourceLocation key;
    protected BlockState state = null;
    protected final List<LazyStateSupplier.PropertyPair> properties = new ArrayList<LazyStateSupplier.PropertyPair>();

    public static <T extends AbstractSupplierBlockStateProvider> Codec<T> codecBuilder(BiFunction<ResourceLocation, List<LazyStateSupplier.PropertyPair>, T> builder) {
        return RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.fieldOf("key").forGetter(o -> o.key), (App)LazyStateSupplier.PropertyPair.CODEC.listOf().fieldOf("properties").forGetter(o -> o.properties)).apply((Applicative)instance, builder));
    }

    public AbstractSupplierBlockStateProvider(String namespace, String path) {
        this(new ResourceLocation(namespace, path));
    }

    public AbstractSupplierBlockStateProvider(String namespace, String path, @Nullable List<LazyStateSupplier.PropertyPair> pairs) {
        this(new ResourceLocation(namespace, path), pairs);
    }

    public AbstractSupplierBlockStateProvider(ResourceLocation key) {
        this(key, null);
    }

    public AbstractSupplierBlockStateProvider(ResourceLocation key, @Nullable List<LazyStateSupplier.PropertyPair> pairs) {
        this.key = key;
        if (pairs != null) {
            this.properties.addAll(pairs);
        }
    }

    protected abstract BlockStateProviderType<?> func_230377_a_();

    public BlockState func_225574_a_(Random randomIn, BlockPos blockPosIn) {
        if (this.state == null) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(this.key);
            if (block == null) {
                NoobUtil.logger.error("Block couldn't be located for key: " + this.key);
                this.state = Blocks.field_150350_a.func_176223_P();
            } else {
                this.state = this.apply(block.func_176223_P());
            }
        }
        return this.state;
    }

    public BlockState apply(BlockState state) {
        for (LazyStateSupplier.PropertyPair pair : this.properties) {
            state = pair.apply(state);
        }
        return state;
    }

    public AbstractSupplierBlockStateProvider addPair(String name, boolean value) {
        this.properties.add(new LazyStateSupplier.PropertyPair(name, value ? "true" : "false", "boolean"));
        return this;
    }

    public AbstractSupplierBlockStateProvider addPair(String name, int value) {
        this.properties.add(new LazyStateSupplier.PropertyPair(name, String.valueOf(value), "integer"));
        return this;
    }
}

