/*
 * Decompiled with CFR 0.152.
 */
package mysticmods.mysticalworld.repack.noobutil.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import mysticmods.mysticalworld.repack.noobutil.NoobUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;

public class VoxelUtil {
    private static final Vector3d fromOrigin = new Vector3d(-0.5, -0.5, -0.5);

    public static VoxelShape multiOr(VoxelShape base, VoxelShape ... shapes) {
        VoxelShape result = base;
        for (VoxelShape shape : shapes) {
            result = VoxelShapes.func_197872_a((VoxelShape)result, (VoxelShape)shape);
        }
        return result;
    }

    public static VoxelShape multiOr(double[] base, double[] ... shapes) {
        VoxelShape result = VoxelUtil.makeCube(base);
        for (double[] shape : shapes) {
            result = VoxelShapes.func_197872_a((VoxelShape)result, (VoxelShape)VoxelUtil.makeCube(shape));
        }
        return result;
    }

    public static VoxelShape makeCube(double ... p) {
        return VoxelShapes.func_197873_a((double)(p[0] / 16.0), (double)(p[1] / 16.0), (double)(p[2] / 16.0), (double)(p[3] / 16.0), (double)(p[4] / 16.0), (double)(p[5] / 16.0));
    }

    public static void print(double x1, double y1, double z1, double x2, double y2, double z2) {
        NoobUtil.logger.info("makeCuboidShape(" + Math.min(x1, x2) + ", " + Math.min(y1, y2) + ", " + Math.min(z1, z2) + ", " + Math.max(x1, x2) + ", " + Math.max(y1, y2) + ", " + Math.max(z1, z2) + "),");
    }

    public static void printSimplified(String name, VoxelShape shape) {
        NoobUtil.logger.info("Simplified: " + name);
        shape.func_197753_c().func_197756_d().forEach(box -> VoxelUtil.print(box.field_72340_a * 16.0, box.field_72338_b * 16.0, box.field_72339_c * 16.0, box.field_72336_d * 16.0, box.field_72337_e * 16.0, box.field_72334_f * 16.0));
    }

    public static AxisAlignedBB rotate(AxisAlignedBB box, Direction side) {
        switch (side) {
            case DOWN: {
                return box;
            }
            case UP: {
                return new AxisAlignedBB(box.field_72340_a, -box.field_72338_b, -box.field_72339_c, box.field_72336_d, -box.field_72337_e, -box.field_72334_f);
            }
            case NORTH: {
                return new AxisAlignedBB(box.field_72340_a, -box.field_72339_c, box.field_72338_b, box.field_72336_d, -box.field_72334_f, box.field_72337_e);
            }
            case SOUTH: {
                return new AxisAlignedBB(-box.field_72340_a, box.field_72339_c, -box.field_72338_b, -box.field_72336_d, box.field_72334_f, -box.field_72337_e);
            }
            case WEST: {
                return new AxisAlignedBB(box.field_72338_b, -box.field_72339_c, -box.field_72340_a, box.field_72337_e, -box.field_72334_f, -box.field_72336_d);
            }
            case EAST: {
                return new AxisAlignedBB(-box.field_72338_b, box.field_72339_c, box.field_72340_a, -box.field_72337_e, box.field_72334_f, box.field_72336_d);
            }
        }
        return box;
    }

    public static AxisAlignedBB rotate(AxisAlignedBB box, Rotation rotation) {
        switch (rotation) {
            case NONE: {
                return box;
            }
            case CLOCKWISE_90: {
                return new AxisAlignedBB(-box.field_72339_c, box.field_72338_b, box.field_72340_a, -box.field_72334_f, box.field_72337_e, box.field_72336_d);
            }
            case CLOCKWISE_180: {
                return new AxisAlignedBB(-box.field_72340_a, box.field_72338_b, -box.field_72339_c, -box.field_72336_d, box.field_72337_e, -box.field_72334_f);
            }
            case COUNTERCLOCKWISE_90: {
                return new AxisAlignedBB(box.field_72339_c, box.field_72338_b, -box.field_72340_a, box.field_72334_f, box.field_72337_e, -box.field_72336_d);
            }
        }
        return box;
    }

    public static AxisAlignedBB rotateHorizontal(AxisAlignedBB box, Direction side) {
        switch (side) {
            case NORTH: {
                return VoxelUtil.rotate(box, Rotation.NONE);
            }
            case SOUTH: {
                return VoxelUtil.rotate(box, Rotation.CLOCKWISE_180);
            }
            case WEST: {
                return VoxelUtil.rotate(box, Rotation.COUNTERCLOCKWISE_90);
            }
            case EAST: {
                return VoxelUtil.rotate(box, Rotation.CLOCKWISE_90);
            }
        }
        return box;
    }

    public static VoxelShape rotate(VoxelShape shape, Direction side) {
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotate(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, Rotation rotation) {
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotate(box, rotation));
    }

    public static VoxelShape rotateHorizontal(VoxelShape shape, Direction side) {
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotateHorizontal(box, side));
    }

    public static VoxelShape rotate(VoxelShape shape, UnaryOperator<AxisAlignedBB> rotateFunction) {
        ArrayList<VoxelShape> rotatedPieces = new ArrayList<VoxelShape>();
        List sourceBoundingBoxes = shape.func_197756_d();
        for (AxisAlignedBB sourceBoundingBox : sourceBoundingBoxes) {
            rotatedPieces.add(VoxelShapes.func_197881_a((AxisAlignedBB)((AxisAlignedBB)rotateFunction.apply(sourceBoundingBox.func_72317_d(VoxelUtil.fromOrigin.field_72450_a, VoxelUtil.fromOrigin.field_72448_b, VoxelUtil.fromOrigin.field_72449_c))).func_72317_d(-VoxelUtil.fromOrigin.field_72450_a, -VoxelUtil.fromOrigin.field_72449_c, -VoxelUtil.fromOrigin.field_72449_c)));
        }
        return VoxelUtil.combine(rotatedPieces);
    }

    public static VoxelShape combine(VoxelShape ... shapes) {
        return VoxelUtil.batchCombine(VoxelShapes.func_197880_a(), IBooleanFunction.field_223244_o_, true, shapes);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes) {
        return VoxelUtil.combine(shapes, true);
    }

    public static VoxelShape combine(Collection<VoxelShape> shapes, boolean simplify) {
        return VoxelUtil.batchCombine(VoxelShapes.func_197880_a(), IBooleanFunction.field_223244_o_, simplify, shapes);
    }

    public static VoxelShape exclude(VoxelShape ... shapes) {
        return VoxelUtil.batchCombine(VoxelShapes.func_197868_b(), IBooleanFunction.field_223234_e_, true, shapes);
    }

    public static VoxelShape batchCombine(VoxelShape initial, IBooleanFunction function, boolean simplify, Collection<VoxelShape> shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = VoxelShapes.func_197882_b((VoxelShape)combinedShape, (VoxelShape)shape, (IBooleanFunction)function);
        }
        return simplify ? combinedShape.func_197753_c() : combinedShape;
    }

    public static VoxelShape batchCombine(VoxelShape initial, IBooleanFunction function, boolean simplify, VoxelShape ... shapes) {
        VoxelShape combinedShape = initial;
        for (VoxelShape shape : shapes) {
            combinedShape = VoxelShapes.func_197882_b((VoxelShape)combinedShape, (VoxelShape)shape, (IBooleanFunction)function);
        }
        return simplify ? combinedShape.func_197753_c() : combinedShape;
    }

    private static Vector3f rotateVector(float x, float y, float z, float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
        float xReturn = x;
        float yReturn = y;
        float zReturn = z;
        if (rotateAngleZ != 0.0f) {
            float sinZ = (float)Math.sin(rotateAngleZ);
            float cosZ = (float)Math.cos(rotateAngleZ);
            xReturn = x * cosZ - y * sinZ;
            yReturn = x * sinZ + y * cosZ;
            x = xReturn;
            y = yReturn;
        }
        if (rotateAngleY != 0.0f) {
            float sinY = (float)Math.sin(rotateAngleY);
            float cosY = (float)Math.cos(rotateAngleY);
            xReturn = x * cosY + z * sinY;
            z = zReturn = z * cosY - x * sinY;
        }
        if (rotateAngleX != 0.0f) {
            float sinX = (float)Math.sin(rotateAngleX);
            float cosX = (float)Math.cos(rotateAngleX);
            yReturn = y * cosX - z * sinX;
            zReturn = y * sinX + z * cosX;
        }
        return new Vector3f(xReturn, yReturn, zReturn);
    }

    private static class Vector3f {
        public final float x;
        public final float y;
        public final float z;

        public Vector3f(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vector3f scale(float factor) {
            return this.mul(factor, factor, factor);
        }

        public Vector3f subtract(Vector3f vec) {
            return this.subtract(vec.x, vec.y, vec.z);
        }

        public Vector3f subtract(float x, float y, float z) {
            return this.add(-x, -y, -z);
        }

        public Vector3f add(Vector3f vec) {
            return this.add(vec.x, vec.y, vec.z);
        }

        public Vector3f add(float x, float y, float z) {
            return new Vector3f(this.x + x, this.y + y, this.z + z);
        }

        public Vector3f mul(float factorX, float factorY, float factorZ) {
            return new Vector3f(this.x * factorX, this.y * factorY, this.z * factorZ);
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.z + ")";
        }
    }

    @FunctionalInterface
    public static interface ShapeCreator {
        public VoxelShape createShape(float var1, float var2, float var3);
    }
}

